/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odaconsumer.OdaDataException;

public class ExceptionHandler {
    protected static final String sm_packageName = "org.eclipse.birt.data.engine.odaconsumer";
    protected static final String EMPTY_STRING = "";
    protected static final String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance("org.eclipse.birt.data.engine.odaconsumer");
    private String m_loggingClassName;

    ExceptionHandler(String loggingClassName) {
        this.m_loggingClassName = loggingClassName;
    }

    static OdaDataException newException(String errorCode, Object errMsgArgv) {
        if (errMsgArgv == null) {
            return new OdaDataException(errorCode);
        }
        if (errMsgArgv.getClass().isArray()) {
            return new OdaDataException(errorCode, (Object[])errMsgArgv);
        }
        return new OdaDataException(errorCode, errMsgArgv);
    }

    static OdaDataException newException(String errorCode, Object errMsgArgv, Throwable cause) {
        if (errMsgArgv == null) {
            return new OdaDataException(errorCode, cause);
        }
        if (errMsgArgv.getClass().isArray()) {
            return new OdaDataException(errorCode, cause, (Object[])errMsgArgv);
        }
        return new OdaDataException(errorCode, cause, errMsgArgv);
    }

    static OdaDataException newException(String errorCode, Throwable cause) {
        return ExceptionHandler.newException(errorCode, null, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static LogHelper getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<ExceptionHandler> clazz = ExceptionHandler.class;
        synchronized (ExceptionHandler.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = LogHelper.getInstance("org.eclipse.birt.data.engine.odaconsumer");
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    protected void throwException(Throwable cause, String errorCode, String methodName) throws OdaDataException {
        this.throwException(cause, errorCode, null, methodName);
    }

    protected void throwException(Throwable cause, String errorCode, int index, String methodName) throws OdaDataException {
        Integer errMsgArgv = index;
        this.throwException(cause, errorCode, errMsgArgv, methodName);
    }

    protected void throwException(Throwable cause, String errorCode, Object errMsgArgv, String methodName) throws OdaDataException {
        OdaDataException dataEx = ExceptionHandler.newException(errorCode, errMsgArgv, cause);
        sm_logger.logp(Level.SEVERE, this.m_loggingClassName, methodName, dataEx.getErrorCodeMessage(), cause);
        throw dataEx;
    }

    protected void throwUnsupportedException(String errorCode, String methodName) throws OdaDataException {
        this.throwUnsupportedException(errorCode, null, methodName);
    }

    protected void throwUnsupportedException(String errorCode, Object errMsgArgv, String methodName) throws OdaDataException {
        UnsupportedOperationException cause = new UnsupportedOperationException();
        OdaDataException dataEx = ExceptionHandler.newException(errorCode, errMsgArgv, cause);
        sm_logger.logp(Level.WARNING, this.m_loggingClassName, methodName, dataEx.getErrorCodeMessage(), cause);
        throw dataEx;
    }

    protected void throwError(String errorCode, Object errMsgArgv, String methodName) throws OdaDataException {
        OdaDataException dataEx = ExceptionHandler.newException(errorCode, errMsgArgv);
        sm_logger.logp(Level.SEVERE, this.m_loggingClassName, methodName, dataEx.getErrorCodeMessage());
        throw dataEx;
    }
}

