/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ParameterBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.ComboAndButtonSection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.dialogs.MessageDialog;

public class DataSetDescriptorProvider
extends AbstractDescriptorProvider {
    private static final String NONE = Messages.getString((String)"BindingPage.None");
    protected Object input;
    private ComboAndButtonSection section;
    private transient boolean enableAutoCommit = true;
    DataSetColumnBindingsFormHandleProvider dataSetProvider;

    @Override
    public String getDisplayName() {
        return Messages.getString((String)"Element.ReportItem.dataSet");
    }

    @Override
    public Object load() {
        String dataSetName = this.getReportItemHandle().getDataSet() == null ? NONE : this.getReportItemHandle().getDataSet().getQualifiedName();
        if (StringUtil.isBlank((String)dataSetName)) {
            dataSetName = NONE;
        }
        this.section.getButtonControl().setEnabled(!dataSetName.equals(NONE));
        return dataSetName;
    }

    public String[] getItems() {
        String[] dataSets = ChoiceSetFactory.getDataSets();
        String[] newList = new String[dataSets.length + 1];
        newList[0] = NONE;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        return newList;
    }

    public boolean isEnable() {
        return DEUtil.getInputSize((Object)this.input) == 1;
    }

    @Override
    public void save(Object value) throws SemanticException {
        if (value.equals(NONE)) {
            value = null;
        }
        int ret = 0;
        if (!NONE.equals(this.load().toString()) || this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 2, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
            ret = prefDialog.open();
        }
        switch (ret) {
            case 0: {
                this.resetDataSetReference(value, true);
                break;
            }
            case 1: {
                this.resetDataSetReference(value, false);
                break;
            }
            case 2: {
                this.section.getComboControl().setStringValue(this.load() == null ? "" : this.load().toString());
            }
        }
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    private ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input);
    }

    public void setComboAndButtonSection(ComboAndButtonSection section) {
        this.section = section;
    }

    private void resetDataSetReference(Object value, boolean clearHistory) {
        try {
            this.startTrans(Messages.getString((String)"DataColumBindingDialog.stackMsg.resetReference"));
            DataSetHandle dataSet = null;
            if (value != null) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(value.toString());
            }
            boolean isExtendedDataModel = false;
            if (dataSet == null && value != null) {
                this.getReportItemHandle().setDataSet(null);
                isExtendedDataModel = new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), (Object)value.toString());
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel(this.getReportItemHandle(), null);
                this.getReportItemHandle().setDataSet(dataSet);
            }
            if (clearHistory) {
                this.getReportItemHandle().getColumnBindings().clearValue();
                this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            if (!isExtendedDataModel) {
                this.dataSetProvider.generateAllBindingColumns();
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionUtil.handle((Throwable)e);
        }
        this.load();
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    private void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    private void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setDependedProvider(DataSetColumnBindingsFormHandleProvider provider) {
        this.dataSetProvider = provider;
    }

    public void bindingDialog() {
        ParameterBindingDialog dialog = new ParameterBindingDialog(UIUtil.getDefaultShell(), (DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input));
        this.startTrans("");
        if (dialog.open() == 0) {
            this.commit();
        } else {
            this.rollback();
        }
    }
}

