/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Document;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocAccessImpl;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavadocLookup;

public class CoreMarkdownAccessImpl
extends CoreJavadocAccessImpl {
    private Parser fParser;
    private HtmlRenderer fRenderer;
    private int fBlockDepth = 0;

    public CoreMarkdownAccessImpl(IJavaElement element, Javadoc javadoc, String source) {
        super(element, javadoc, source);
        this.init();
    }

    public CoreMarkdownAccessImpl(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
        super(element, javadoc, source, lookup);
        this.init();
    }

    private void init() {
        List<Extension> extensions = List.of(TablesExtension.create());
        this.fParser = Parser.builder().extensions(extensions).build();
        this.fRenderer = HtmlRenderer.builder().extensions(extensions).build();
    }

    @Override
    protected String removeDocLineIntros(String textWithSlashes) {
        String lineBreakGroup = "(\\r\\n?|\\n)";
        String noBreakSpace = "[^\r\n&&\\s]";
        return textWithSlashes.replaceAll(lineBreakGroup + noBreakSpace + "*///" + noBreakSpace + "*", "$1");
    }

    @Override
    protected void handleLink(List<? extends ASTNode> fragments) {
        if (fragments.size() == 2 && fragments.get(0) instanceof TextElement) {
            fragments = Arrays.asList(fragments.get(1), fragments.get(0));
        }
        super.handleLink(fragments);
    }

    @Override
    protected String getBlockTagStart() {
        ++this.fBlockDepth;
        return "\n" + super.getBlockTagStart();
    }

    @Override
    protected String getBlockTagEnd() {
        if (this.fBlockDepth > 0) {
            --this.fBlockDepth;
        }
        return super.getBlockTagEnd();
    }

    @Override
    protected void handleContentElements(List<? extends ASTNode> nodes, boolean skipLeadingWhitespace, TagElement tagElement) {
        int start = this.fBuf.length();
        super.handleContentElements(nodes, skipLeadingWhitespace, tagElement);
        if (this.fBlockDepth > 0) {
            Paragraph para;
            String generated = this.fBuf.substring(start);
            Node node = this.fParser.parse(generated);
            Node node2 = node.getFirstChild();
            if (node2 instanceof Paragraph && (para = (Paragraph)node2).getNext() == null) {
                node = this.eliminateContainerNode((Node)para);
            }
            String rendered = this.fRenderer.render(node);
            this.fBuf.replace(start, this.fBuf.length(), rendered);
        }
    }

    protected Node eliminateContainerNode(Node container) {
        ArrayList<Node> children = new ArrayList<Node>();
        Node child = container.getFirstChild();
        while (child != null) {
            children.add(child);
            child = child.getNext();
        }
        Document doc = new Document();
        for (Node child2 : children) {
            doc.appendChild(child2);
        }
        return doc;
    }

    @Override
    public String toHTML() {
        String content = super.toHTML();
        Node document = this.fParser.parse(content);
        return this.fRenderer.render(document);
    }
}

