/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.views.repository;

import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.pde.bnd.ui.views.repository.ArbitraryNamespaceSearchPanel;
import org.eclipse.pde.bnd.ui.views.repository.PackageSearchPanel;
import org.eclipse.pde.bnd.ui.views.repository.SearchPanel;
import org.eclipse.pde.bnd.ui.views.repository.ServiceSearchPanel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.XMLMemento;
import org.osgi.resource.Requirement;

public class AdvancedSearchDialog
extends TitleAreaDialog
implements IPersistable {
    private final Map<String, SearchPanel> panelMap = new LinkedHashMap<String, SearchPanel>();
    private TabFolder tabFolder;
    private int activeTabIndex = 0;
    private Requirement requirement = null;

    public AdvancedSearchDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.panelMap.put("Package", new PackageSearchPanel());
        this.panelMap.put("Service", new ServiceSearchPanel());
        this.panelMap.put("Other", new ArbitraryNamespaceSearchPanel());
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Advanced Search");
        this.setMessage("Perform a search for resource capabilities in the Repositories. Select the\ncapability namespace using the tab bar.");
        Composite area = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(area, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        PropertyChangeListener changeListener = evt -> this.updateFromPanel();
        for (Map.Entry<String, SearchPanel> panelEntry : this.panelMap.entrySet()) {
            String title = panelEntry.getKey();
            SearchPanel panel = panelEntry.getValue();
            Composite container = new Composite((Composite)this.tabFolder, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            Control control = panel.createControl(container);
            GridData controlLayoutData = new GridData(4, 0x1000000, true, true);
            controlLayoutData.widthHint = 200;
            control.setLayoutData((Object)controlLayoutData);
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(title);
            item.setControl((Control)container);
            item.setData((Object)panel);
            Image image = panel.createImage((Device)this.tabFolder.getDisplay());
            if (image != null) {
                item.setImage(image);
            }
            panel.addPropertyChangeListener(changeListener);
        }
        this.tabFolder.setSelection(this.activeTabIndex);
        SearchPanel currentPanel = (SearchPanel)this.tabFolder.getItem(this.activeTabIndex).getData();
        currentPanel.setFocus();
        this.requirement = currentPanel.getRequirement();
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedSearchDialog.this.activeTabIndex = AdvancedSearchDialog.this.tabFolder.getSelectionIndex();
                AdvancedSearchDialog.this.updateFromPanel();
                AdvancedSearchDialog.this.getSelectedPanel().setFocus();
            }
        });
        return area;
    }

    private SearchPanel getSelectedPanel() {
        int index = this.tabFolder.getSelectionIndex();
        TabItem item = this.tabFolder.getItem(index);
        return (SearchPanel)item.getData();
    }

    private void updateFromPanel() {
        SearchPanel panel = this.getSelectedPanel();
        this.setErrorMessage(panel.getError());
        this.requirement = panel.getRequirement();
        this.getButton(0).setEnabled(this.requirement != null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setText("Search");
        okButton.setEnabled(this.requirement != null);
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public void saveState(IMemento memento) {
        memento.putInteger("tabIndex", this.activeTabIndex);
        for (Map.Entry<String, SearchPanel> panelEntry : this.panelMap.entrySet()) {
            IMemento childMemento = memento.createChild("tab", panelEntry.getKey());
            SearchPanel panel = panelEntry.getValue();
            panel.saveState(childMemento);
        }
    }

    public void restoreState(IMemento memento) {
        IMemento[] children;
        this.activeTabIndex = memento.getInteger("tabIndex");
        IMemento[] iMementoArray = children = memento.getChildren("tab");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            String key = childMemento.getID();
            SearchPanel panel = this.panelMap.get(key);
            if (panel != null) {
                panel.restoreState(childMemento);
            }
            ++n2;
        }
    }

    public static IMemento toNamespaceSearchPanelMemento(Requirement req) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"search");
        memento.putInteger("tabIndex", 2);
        IMemento other = memento.createChild("tab", "Other");
        other.putString("namespace", req.getNamespace());
        other.putString("filter", (String)req.getDirectives().get("filter"));
        return memento;
    }
}

