/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.bndtools;

import aQute.bnd.build.Workspace;
import aQute.bnd.build.WorkspaceRepository;
import aQute.bnd.service.IndexProvider;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.ResolutionPhase;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocation;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocationPage;
import org.eclipse.pde.internal.ui.bndtools.BndToolsMessages;
import org.eclipse.pde.internal.ui.bndtools.RepositoryTargetLocation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class RepositoryTargetLocationPage
extends BndTargetLocationPage {
    private static final String CACHE_REPOSITORY = "cache";
    private RepositoryTargetLocation targetLocation;
    private final List<RepositoryPlugin> repositories;
    private RepositoryPlugin repository;
    private TreeViewer bundleList;
    private Text pluginLocationText;

    public RepositoryTargetLocationPage(ITargetDefinition targetDefinition, RepositoryTargetLocation targetLocation) {
        super(BndToolsMessages.RepositoryTargetLocationPage_AddBndRepositoryContainer, BndToolsMessages.RepositoryTargetLocationPage_AddBndRepository, BndToolsMessages.RepositoryTargetLocationPage_ToBeAdded, targetDefinition);
        Workspace workspace;
        if (targetLocation != null) {
            this.targetLocation = targetLocation;
            this.repository = targetLocation.getRepository();
        }
        this.repositories = new ArrayList<RepositoryPlugin>();
        try {
            workspace = BndTargetLocation.getWorkspace();
        }
        catch (Exception e) {
            this.logError("Unable to locate the Bnd workspace", e);
            return;
        }
        try {
            WorkspaceRepository workspaceRepository = workspace.getWorkspaceRepository();
            this.repositories.add((RepositoryPlugin)workspaceRepository);
            for (RepositoryPlugin repository : workspace.getPlugins(RepositoryPlugin.class)) {
                if (CACHE_REPOSITORY.equals(repository.getName()) || repository instanceof IndexProvider && !((IndexProvider)repository).getSupportedPhases().contains(ResolutionPhase.build)) continue;
                this.repositories.add(repository);
            }
            if (this.repository == null) {
                this.repository = workspaceRepository;
            }
        }
        catch (Exception e) {
            this.repositories.clear();
            this.logError("Unable to resolve Bnd repository plugins", e);
        }
    }

    private String getLocation() {
        return this.repository != null ? this.repository.getLocation() : "";
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        Combo pluginsCombo = this.createRepositoryComboArea(composite);
        SWTFactory.createLabel(composite, BndToolsMessages.RepositoryTargetLocationPage_Contents, 2);
        this.bundleList = this.createBundleListArea(composite, 2);
        this.updateTarget();
        this.selectTargetInCombo(pluginsCombo);
        this.setControl((Control)composite);
    }

    private boolean selectTargetInCombo(Combo pluginsCombo) {
        if (this.repository == null) {
            return false;
        }
        int i = 0;
        while (i < pluginsCombo.getItemCount()) {
            if (pluginsCombo.getItem(i).equals(this.repository.getName())) {
                pluginsCombo.select(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Combo createRepositoryComboArea(Composite composite) {
        String[] names = new String[this.repositories.size()];
        int i = 0;
        for (RepositoryPlugin plugin : this.repositories) {
            names[i++] = plugin.getName();
        }
        SWTFactory.createLabel(composite, BndToolsMessages.RepositoryTargetLocationPage_Repository, 1);
        final Combo pluginsCombo = SWTFactory.createCombo(composite, 8, 1, 768, names);
        SWTFactory.createLabel(composite, BndToolsMessages.RepositoryTargetLocationPage_Location, 1);
        this.pluginLocationText = SWTFactory.createText(composite, 8, 1, 768);
        this.pluginLocationText.setText(this.getLocation());
        pluginsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                RepositoryTargetLocationPage.this.repository = RepositoryTargetLocationPage.this.repositories.get(pluginsCombo.getSelectionIndex());
                RepositoryTargetLocationPage.this.updateTarget();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                RepositoryTargetLocationPage.this.clearTarget();
            }
        });
        return pluginsCombo;
    }

    protected void updateTarget() {
        this.resetMessage();
        if (this.repositories.isEmpty()) {
            this.clearTarget();
            return;
        }
        try {
            this.bundleList.setInput(this.getBundles());
            this.pluginLocationText.setText(this.getLocation());
            this.setPageComplete(true);
        }
        catch (Exception e) {
            this.logError("Unable to list bundles for repository: " + this.repository.getName(), e);
            this.clearTarget();
        }
    }

    private void clearTarget() {
        this.setPageComplete(false);
        this.bundleList.setInput(Collections.emptySet());
        this.repository = null;
    }

    protected Collection<?> getBundles() throws Exception {
        ArrayList<CallSite> bundles = new ArrayList<CallSite>();
        if (this.repository != null) {
            for (String bsn : this.repository.list("*")) {
                bundles.add((CallSite)((Object)(bsn + " - " + String.valueOf(this.repository.versions(bsn).last()))));
            }
            if (bundles.isEmpty()) {
                this.logWarning("Repository is empty: " + this.repository.getName(), null);
            } else {
                this.resetMessage();
            }
        }
        return bundles;
    }

    public RepositoryTargetLocation getBundleContainer() {
        if (this.targetLocation == null) {
            this.targetLocation = new RepositoryTargetLocation();
        }
        return this.targetLocation.setRepository(this.repository);
    }
}

