/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.html.core.internal.HTMLCoreMessages;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.validate.StringMatcher;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.text.correction.IgnoreElementNameCompletionProposal;
import org.eclipse.wst.html.ui.internal.text.correction.RemoveAttributesProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLSyntaxValidationQuickFixProcessor
implements IQuickAssistProcessor {
    private StringMatcher UNKNOWN_ELEMENT_NAME_MATCHER = new StringMatcher(NLS.bind((String)HTMLCoreMessages.Unknown_tag___0____ERROR_, (Object)"*"));
    private IPreferencesService fPreferenceService = Platform.getPreferencesService();

    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        boolean result = false;
        String text = null;
        if (annotation instanceof TemporaryAnnotation) {
            TemporaryAnnotation tempAnnotation = (TemporaryAnnotation)annotation;
            int problemID = tempAnnotation.getProblemID();
            text = tempAnnotation.getText();
            if (problemID == 0 && text != null) {
                result = true;
            }
        } else if (annotation instanceof MarkerAnnotation) {
            IResource resource;
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            text = markerAnnotation.getText();
            IMarker marker = markerAnnotation.getMarker();
            IResource iResource = resource = marker == null ? null : marker.getResource();
            if (resource != null && resource.exists() && resource.isAccessible() && text != null) {
                result = true;
            }
        }
        result = result && this.UNKNOWN_ELEMENT_NAME_MATCHER.match(text);
        return result;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ISourceViewer viewer = invocationContext.getSourceViewer();
        int documentOffset = invocationContext.getOffset();
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<Object> proposals = new ArrayList<Object>();
        if (model instanceof IAnnotationModelExtension2) {
            Iterator iter = ((IAnnotationModelExtension2)model).getAnnotationIterator(documentOffset, length, true, true);
            block0: while (iter.hasNext()) {
                IgnoreElementNameCompletionProposal p;
                String name;
                ProjectScope projectScope;
                IDOMNode node;
                Annotation anno = (Annotation)iter.next();
                if (!this.canFix(anno)) continue;
                int offset = -1;
                if (anno instanceof TemporaryAnnotation) {
                    offset = ((TemporaryAnnotation)anno).getPosition().getOffset();
                } else if (anno instanceof MarkerAnnotation) {
                    offset = ((MarkerAnnotation)anno).getMarker().getAttribute("charStart", -1);
                }
                if (offset == -1 || !((node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset)) instanceof Element)) continue;
                IStructuredDocumentRegion documentRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)viewer, (int)documentOffset);
                if (documentRegion != null && documentRegion.getNumberOfRegions() > 2 && "XML_END_TAG_OPEN".equals(documentRegion.getFirstRegion().getType())) {
                    proposals.add(new RemoveAttributesProposal(documentRegion, HTMLUIMessages.RemoveAttributes));
                }
                Object adapter = node instanceof IAdaptable ? ((IAdaptable)node).getAdapter(IResource.class) : null;
                IProject project = adapter instanceof IResource ? ((IResource)adapter).getProject() : null;
                IScopeContext[] fLookupOrder = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
                if (project != null && (projectScope = new ProjectScope(project)).getNode(this.getPreferenceNodeQualifier()).getBoolean(this.getProjectSettingsKey(), false)) {
                    fLookupOrder = new IScopeContext[]{projectScope, InstanceScope.INSTANCE, DefaultScope.INSTANCE};
                }
                boolean ignore = this.fPreferenceService.getBoolean(this.getPreferenceNodeQualifier(), "ignoreElementNames", false, fLookupOrder);
                String ignoreList = this.fPreferenceService.getString(this.getPreferenceNodeQualifier(), "elementNamesToIgnore", "", fLookupOrder);
                HashSet<String> result = new HashSet<String>();
                if (ignoreList.trim().length() > 0) {
                    String[] names = ignoreList.split(",");
                    int i = 0;
                    while (names != null && i < names.length) {
                        String name2;
                        String string = name2 = names[i] == null ? null : names[i].trim();
                        if (name2 != null && name2.length() > 0) {
                            result.add(name2.toLowerCase());
                        }
                        ++i;
                    }
                }
                if ((name = this.getElementName(node, offset)) == null) continue;
                if (!(ignore && !this.shouldShowQuickFix(result, name.toLowerCase()) || proposals.contains(p = new IgnoreElementNameCompletionProposal(name.toLowerCase(), offset, NLS.bind((String)HTMLUIMessages.DoNotValidateElement, (Object)name), HTMLUIMessages.DoNotValidateElementAddInfo, (Node)node)))) {
                    proposals.add(p);
                }
                int dashIndex = name.indexOf(45);
                while (dashIndex != -1) {
                    StringBuffer namePattern = new StringBuffer(name.substring(0, dashIndex + 1)).append('*');
                    if (ignore && result.contains(namePattern.toString().toLowerCase())) continue block0;
                    IgnoreElementNameCompletionProposal p2 = new IgnoreElementNameCompletionProposal(namePattern.toString().toLowerCase(), offset, NLS.bind((String)HTMLUIMessages.DoNotValidateAllElements, (Object)namePattern.toString()), HTMLUIMessages.DoNotValidateAllElementsAddInfo, (Node)node);
                    if (!proposals.contains(p2)) {
                        proposals.add(p2);
                    }
                    dashIndex = name.indexOf(45, dashIndex + 1);
                }
            }
        }
        if (proposals.isEmpty()) {
            return null;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private String getElementName(IDOMNode node, int offset) {
        return node.getNodeName();
    }

    private boolean shouldShowQuickFix(Set<String> lcIgnoredPatterns, String attrName) {
        String[] lcPatterns = lcIgnoredPatterns.toArray(new String[0]);
        int i = 0;
        while (i < lcPatterns.length) {
            StringMatcher strMatcher = new StringMatcher(lcPatterns[i]);
            if (strMatcher.match(attrName.toLowerCase())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getPreferenceNodeQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    private String getProjectSettingsKey() {
        return "use-project-settings";
    }
}

