/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.TextChangeManager;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.ComponentRenameArguments;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.util.TextChangeCompatibility;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Node;

public class XMLComponentRenameParticipant
extends RenameParticipant {
    protected SearchMatch match;
    protected TextChangeManager changeManager;
    protected List matches;

    protected boolean initialize(Object element) {
        if (this.getArguments() instanceof ComponentRenameArguments) {
            this.changeManager = ((ComponentRenameArguments)this.getArguments()).getChangeManager();
        }
        return false;
    }

    public String getName() {
        return "XML Component Rename Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public TextChangeManager getChangeManager() {
        if (this.changeManager == null) {
            this.changeManager = new TextChangeManager(false);
        }
        return this.changeManager;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Iterator iter = this.matches.iterator();
        while (iter.hasNext()) {
            SearchMatch match = (SearchMatch)iter.next();
            TextChange textChange = this.getChangeManager().get(match.getFile());
            String newName = this.getArguments().getNewName();
            String qualifier = "";
            if (this.getArguments() instanceof ComponentRenameArguments) {
                qualifier = ((ComponentRenameArguments)this.getArguments()).getQualifier();
            }
            if (match.getObject() instanceof Node) {
                Node node = (Node)match.getObject();
                if (node instanceof IDOMAttr) {
                    IDOMAttr attr = (IDOMAttr)node;
                    IDOMElement element = (IDOMElement)attr.getOwnerElement();
                    newName = XMLComponentRenameParticipant.getNewQName((Node)element, qualifier, newName);
                }
                newName = RenameComponentProcessor.quoteString(newName);
            }
            ReplaceEdit replaceEdit = new ReplaceEdit(match.getOffset(), match.getLength(), newName);
            String editName = RefactoringMessages.getString("RenameComponentProcessor.Component_Refactoring_update_reference");
            TextChangeCompatibility.addTextEdit(textChange, editName, (TextEdit)replaceEdit);
        }
        return null;
    }

    private static String getNewQName(Node node, String targetNamespace, String newName) {
        StringBuffer sb = new StringBuffer();
        if (newName != null) {
            String prefix = XSDConstants.lookupQualifier((Node)node, (String)targetNamespace);
            if (prefix != null && prefix.length() > 0) {
                sb.append(prefix);
                sb.append(":");
                sb.append(newName);
            } else {
                sb.append(newName);
            }
        } else {
            sb.append(newName);
        }
        return sb.toString();
    }

    public void setChangeManager(TextChangeManager changeManager) {
        this.changeManager = changeManager;
    }
}

