/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.awt.geom.AffineTransform;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.chart.ui.util.TransformUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class IconCanvas
extends Canvas {
    private Image sourceImage;
    private Image screenImage;
    private AffineTransform transform = new AffineTransform();

    public IconCanvas(Composite parent) {
        this(parent, 0);
    }

    public IconCanvas(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                IconCanvas.this.paint(event.gc);
            }
        });
    }

    public void dispose() {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
        }
        if (this.screenImage != null && !this.screenImage.isDisposed()) {
            this.screenImage.dispose();
        }
    }

    private void paint(GC gc) {
        Rectangle clientRect = this.getClientArea();
        if (this.sourceImage != null) {
            Rectangle imageRect = TransformUtil.inverseTransformRect((AffineTransform)this.transform, (Rectangle)clientRect);
            int gap = 2;
            imageRect.x -= gap;
            imageRect.y -= gap;
            imageRect.width += 2 * gap;
            imageRect.height += 2 * gap;
            Rectangle imageBound = this.sourceImage.getBounds();
            imageRect = imageRect.intersection(imageBound);
            Rectangle destRect = TransformUtil.transformRect((AffineTransform)this.transform, (Rectangle)imageRect);
            if (this.screenImage != null) {
                this.screenImage.dispose();
            }
            this.screenImage = new Image((Device)this.getDisplay(), clientRect.width, clientRect.height);
            GC newGC = new GC((Drawable)this.screenImage);
            newGC.setClipping(clientRect);
            newGC.drawImage(this.sourceImage, imageRect.x, imageRect.y, imageRect.width, imageRect.height, destRect.x, destRect.y, destRect.width, destRect.height);
            newGC.dispose();
            gc.drawImage(this.screenImage, 0, 0);
        } else {
            gc.setClipping(clientRect);
            gc.fillRectangle(clientRect);
        }
    }

    public void syncScrollBars() {
        ScrollBar vertical;
        if (this.sourceImage == null) {
            this.redraw();
            return;
        }
        AffineTransform af = this.transform;
        double sx = af.getScaleX();
        double sy = af.getScaleY();
        double tx = af.getTranslateX();
        double ty = af.getTranslateY();
        if (tx > 0.0) {
            tx = 0.0;
        }
        if (ty > 0.0) {
            ty = 0.0;
        }
        Rectangle imageBound = this.sourceImage.getBounds();
        int cw = this.getClientArea().width;
        int ch = this.getClientArea().height;
        ScrollBar horizontal = this.getHorizontalBar();
        if (horizontal != null) {
            horizontal.setIncrement(this.getClientArea().width / 100);
            horizontal.setPageIncrement(this.getClientArea().width);
            if ((double)imageBound.width * sx > (double)cw) {
                horizontal.setMaximum((int)((double)imageBound.width * sx));
                horizontal.setEnabled(true);
                if ((int)(-tx) > horizontal.getMaximum() - cw) {
                    tx = -horizontal.getMaximum() + cw;
                }
            } else {
                horizontal.setEnabled(false);
                tx = ((double)cw - (double)imageBound.width * sx) / 2.0;
            }
            horizontal.setSelection((int)(-tx));
            horizontal.setThumb(this.getClientArea().width);
        }
        if ((vertical = this.getVerticalBar()) != null) {
            vertical.setIncrement(this.getClientArea().height / 100);
            vertical.setPageIncrement(this.getClientArea().height);
            if ((double)imageBound.height * sy > (double)ch) {
                vertical.setMaximum((int)((double)imageBound.height * sy));
                vertical.setEnabled(true);
                if ((int)(-ty) > vertical.getMaximum() - ch) {
                    ty = -vertical.getMaximum() + ch;
                }
            } else {
                vertical.setEnabled(false);
                ty = ((double)ch - (double)imageBound.height * sy) / 2.0;
            }
            vertical.setSelection((int)(-ty));
            vertical.setThumb(this.getClientArea().height);
        }
        af = AffineTransform.getScaleInstance(sx, sy);
        af.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.transform = af;
        this.redraw();
    }

    public Image loadImage(String filename) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), filename);
        if (this.sourceImage.getBounds().width > this.getBounds().width || this.sourceImage.getBounds().height > this.getBounds().height) {
            this.fitCanvas();
        } else {
            this.showOriginal();
        }
        return this.sourceImage;
    }

    public Image loadImage(URL url) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = ImageDescriptor.createFromURL((URL)url).createImage();
        if (this.sourceImage.getBounds().width > this.getBounds().width || this.sourceImage.getBounds().height > this.getBounds().height) {
            this.fitCanvas();
        } else {
            this.showOriginal();
        }
        return this.sourceImage;
    }

    public Image loadImage(InputStream is) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), is);
        if (this.sourceImage.getBounds().width > this.getBounds().width || this.sourceImage.getBounds().height > this.getBounds().height) {
            this.fitCanvas();
        } else {
            this.showOriginal();
        }
        return this.sourceImage;
    }

    public void fitCanvas() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle imageBound = this.sourceImage.getBounds();
        Rectangle destRect = this.getClientArea();
        double sx = (double)destRect.width / (double)imageBound.width;
        double sy = (double)destRect.height / (double)imageBound.height;
        double s = Math.min(sx, sy);
        double dx = 0.5 * (double)destRect.width;
        double dy = 0.5 * (double)destRect.height;
        this.centerZoom(dx, dy, s, new AffineTransform());
    }

    public void showOriginal() {
        if (this.sourceImage == null) {
            return;
        }
        this.transform = new AffineTransform();
        this.syncScrollBars();
    }

    public void clear() {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
            GC clearGC = new GC((Drawable)this);
            this.paint(clearGC);
            clearGC.dispose();
        }
    }

    public void centerZoom(double dx, double dy, double scale, AffineTransform af) {
        af.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        af.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        af.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        this.transform = af;
        this.syncScrollBars();
    }
}

