/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.report.engine.layout.pdf.font.CharSegment;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingConfig;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FontConfigHandler
extends DefaultHandler {
    private FontMappingConfig config;
    private Stack<ParseState> states = new Stack();
    private static final String TAG_FONT_PATHS = "font-paths";
    private static final String TAG_PATH = "path";
    private static final String ATTR_PATH = "path";
    private static final String TAG_FONT_ALIASES = "font-aliases";
    private static final String TAG_FONT_MAPPINGS = "font-mappings";
    private static final String TAG_MAPPING = "mapping";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FONT_FAMILY = "font-family";
    private static final String TAG_FONT_ENCODINGS = "font-encodings";
    private static final String TAG_ENCODING = "encoding";
    private static final String ATTR_ENCODING = "encoding";
    private static final String TAG_SEARCH_SEQUENCES = "search-sequences";
    private static final String TAG_SEQUENCE = "sequence";
    private static final String ATTR_LOCALE = "locale";
    private static final String TAG_CATALOG = "catalog";
    private static final String TAG_ALL_FONTS = "all-fonts";
    private static final String TAG_BLOCK = "block";
    private static final String ATTR_RANGE_START = "range-start";
    private static final String ATTR_RANGE_END = "range-end";
    private static final String ATTR_START = "start";
    private static final String ATTR_END = "end";
    private static final String TAG_COMPOSITE_FONT = "composite-font";
    private static final String TAG_FONT = "font";
    private static final String ATTR_CATALOG = "catalog";
    private static final String VALUE_DEFAULT_BLOCK = "default";
    private static final String TAG_CHARACTER = "character";
    private static final String ATTR_VALUE = "value";
    private static final String TAG_FONT_KERNING = "kerning-and-ligatures";
    private static final String ATTR_KERNING_ENABLED = "enabled";

    public FontConfigHandler(FontMappingConfig config) {
        this.config = config;
        this.states.push(new RootState());
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attrs) throws SAXException {
        ParseState state = this.states.peek();
        state = state.startElement(rawName);
        state.parseAttrs(attrs);
        this.states.push(state);
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        ParseState elementState = this.states.pop();
        elementState.end();
        ParseState state = this.states.peek();
        state.endElement(elementState);
    }

    private String getStringValue(Attributes attrs, String name) {
        String value = attrs.getValue(name);
        if (value != null && (value = value.trim()).length() != 0) {
            return value;
        }
        return null;
    }

    private int getIntValue(Attributes attrs, String attrName, int defaultValue) {
        String value = attrs.getValue(attrName);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private int getHexValue(Attributes attrs, String attrName, int defaultValue) {
        String value = attrs.getValue(attrName);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value, 16);
    }

    private int getCharValue(String value) {
        if (value.length() == 1) {
            return value.charAt(0);
        }
        if (value.matches("\\\\u\\p{XDigit}{4}")) {
            String unicode = value.substring(2);
            return Integer.parseInt(unicode, 16);
        }
        return -1;
    }

    private class AllFontState
    extends ParseState {
        LinkedHashMap<String, LinkedHashMap<String, ArrayList<CharSegment>>> fonts = new LinkedHashMap();

        private AllFontState() {
        }

        void addComponent(String fontName, int start, int end, String fontFamily) {
            ArrayList<CharSegment> charSegs;
            LinkedHashMap<String, ArrayList<CharSegment>> font = this.fonts.get(fontName);
            if (font == null) {
                font = new LinkedHashMap();
                this.fonts.put(fontName, font);
            }
            if ((charSegs = font.get(fontFamily)) == null) {
                charSegs = new ArrayList();
                font.put(fontFamily, charSegs);
            }
            charSegs.add(new CharSegment(start, end, fontFamily));
        }

        CompositeFontConfig createCompositeFont(String name, Map<String, ArrayList<CharSegment>> fonts) {
            CompositeFontConfig config = new CompositeFontConfig(name);
            for (Map.Entry<String, ArrayList<CharSegment>> entry : fonts.entrySet()) {
                String fontName = entry.getKey();
                Collection charSegs = entry.getValue();
                CharSegment[] segment = charSegs.toArray(new CharSegment[0]);
                CharSegment.sort(segment);
                config.addFont(fontName, null);
                config.addCharSegment(fontName, segment);
            }
            return config;
        }

        @Override
        public void end() {
            for (Map.Entry<String, LinkedHashMap<String, ArrayList<CharSegment>>> entry : this.fonts.entrySet()) {
                LinkedHashMap<String, ArrayList<CharSegment>> fonts;
                String fontName = entry.getKey();
                CompositeFontConfig fontConfig = this.createCompositeFont(fontName, fonts = entry.getValue());
                if (fontConfig.getAllFonts().isEmpty()) continue;
                FontConfigHandler.this.config.addCompositeFont(fontConfig);
            }
        }

        @Override
        public ParseState startElement(String tagName) {
            String tagValue = tagName.toLowerCase();
            if (FontConfigHandler.TAG_BLOCK.equals(tagValue)) {
                return new BlockState();
            }
            return super.startElement(tagName);
        }

        class BlockState
        extends ParseState {
            int rangeStart;
            int rangeEnd;

            BlockState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                this.rangeStart = FontConfigHandler.this.getHexValue(attrs, FontConfigHandler.ATTR_RANGE_START, -1);
                this.rangeEnd = FontConfigHandler.this.getHexValue(attrs, FontConfigHandler.ATTR_RANGE_END, -1);
            }

            @Override
            public ParseState startElement(String tagName) {
                String tagValue;
                if (this.rangeStart != -1 && this.rangeEnd != -1 && FontConfigHandler.TAG_MAPPING.equals(tagValue = tagName.toLowerCase())) {
                    return new MappingState();
                }
                return super.startElement(tagName);
            }

            class MappingState
            extends ParseState {
                MappingState() {
                }

                @Override
                public void parseAttrs(Attributes attrs) {
                    String name = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_NAME);
                    String fontFamily = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_FONT_FAMILY);
                    if (name != null && fontFamily != null) {
                        AllFontState.this.addComponent(name, BlockState.this.rangeStart, BlockState.this.rangeEnd, fontFamily);
                    }
                }
            }
        }
    }

    private class CompositeFontState
    extends ParseState {
        private String fontName;
        private String defaultFont;
        private LinkedHashSet<String> allFonts = new LinkedHashSet();
        private HashMap<String, String> fontCatalogs = new HashMap();
        private HashMap<Integer, String> fontCharacters = new HashMap();
        private LinkedHashMap<String, ArrayList<CharSegment>> fontBlocks = new LinkedHashMap();

        private CompositeFontState() {
        }

        private void addCharacter(String fontFamily, int ch) {
            this.fontCharacters.put(ch, fontFamily);
        }

        private void addBlock(String fontFamily, int start, int end) {
            this.allFonts.add(fontFamily);
            ArrayList<CharSegment> list = this.fontBlocks.get(fontFamily);
            if (list == null) {
                list = new ArrayList();
                this.fontBlocks.put(fontFamily, list);
            }
            list.add(new CharSegment(start, end, fontFamily));
        }

        private void addFont(String fontFamily, String catalog) {
            this.allFonts.add(fontFamily);
            this.fontCatalogs.put(fontFamily, catalog);
        }

        private CompositeFontConfig createCompositeFont() {
            if (this.fontName != null) {
                String fontFamily;
                CompositeFontConfig fontConfig = new CompositeFontConfig(this.fontName);
                fontConfig.setDefaultFont(this.defaultFont);
                ArrayList<CharSegment> characters = new ArrayList<CharSegment>();
                for (Map.Entry<Integer, String> entry : this.fontCharacters.entrySet()) {
                    int ch = entry.getKey();
                    fontFamily = entry.getValue();
                    characters.add(new CharSegment(ch, ch, fontFamily));
                }
                if (!characters.isEmpty()) {
                    CharSegment[] seg = characters.toArray(new CharSegment[0]);
                    CharSegment.sort(seg);
                    fontConfig.setSpecialCharacters(seg);
                }
                fontConfig.allFonts.addAll(this.allFonts);
                fontConfig.fontCatalogs.putAll(this.fontCatalogs);
                for (Map.Entry<String, ArrayList<CharSegment>> entry : this.fontBlocks.entrySet()) {
                    fontFamily = entry.getKey();
                    Collection blocks = entry.getValue();
                    CharSegment[] seg = blocks.toArray(new CharSegment[0]);
                    CharSegment.normalize(seg);
                    fontConfig.addCharSegment(fontFamily, seg);
                }
                return fontConfig;
            }
            return null;
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            this.fontName = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_NAME);
            if (this.fontName != null) {
                this.defaultFont = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_FONT_FAMILY);
            }
        }

        @Override
        public void end() {
            CompositeFontConfig fontConfig = this.createCompositeFont();
            if (fontConfig != null) {
                FontConfigHandler.this.config.addCompositeFont(fontConfig);
            }
        }

        @Override
        public ParseState startElement(String tagName) {
            if (this.fontName != null) {
                String tagValue = tagName.toLowerCase();
                if (FontConfigHandler.TAG_FONT.equals(tagValue)) {
                    return new FontState();
                }
                if (FontConfigHandler.TAG_BLOCK.equals(tagValue)) {
                    return new BlockState();
                }
                if (FontConfigHandler.TAG_CHARACTER.equals(tagValue)) {
                    return new CharacterState();
                }
            }
            return super.startElement(tagName);
        }

        private class BlockState
        extends ParseState {
            private BlockState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                String fontFamily = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_FONT_FAMILY);
                if (fontFamily != null) {
                    String name = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_NAME);
                    if (FontConfigHandler.VALUE_DEFAULT_BLOCK.equals(name)) {
                        if (CompositeFontState.this.defaultFont == null) {
                            CompositeFontState.this.defaultFont = fontFamily;
                        }
                    } else {
                        int rangeStart = FontConfigHandler.this.getHexValue(attrs, FontConfigHandler.ATTR_RANGE_START, -1);
                        int rangeEnd = FontConfigHandler.this.getHexValue(attrs, FontConfigHandler.ATTR_RANGE_END, -1);
                        if (rangeStart != -1 && rangeEnd != -1) {
                            CompositeFontState.this.addBlock(fontFamily, rangeStart, rangeEnd);
                        }
                    }
                }
            }
        }

        private class CharacterState
        extends ParseState {
            private CharacterState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                int ch;
                String value;
                String fontFamily = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_FONT_FAMILY);
                if (fontFamily != null && (value = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_VALUE)) != null && (ch = FontConfigHandler.this.getCharValue(value)) != -1) {
                    CompositeFontState.this.addCharacter(fontFamily, ch);
                }
            }
        }

        private class FontState
        extends ParseState {
            private String fontFamily;
            private String catalog;

            private FontState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                this.fontFamily = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_FONT_FAMILY);
                this.catalog = FontConfigHandler.this.getStringValue(attrs, "catalog");
                if (this.fontFamily != null) {
                    CompositeFontState.this.addFont(this.fontFamily, this.catalog);
                }
            }

            @Override
            public ParseState startElement(String tagName) {
                String tagValue;
                if (this.fontFamily != null && FontConfigHandler.TAG_BLOCK.equals(tagValue = tagName.toLowerCase())) {
                    return new BlockState();
                }
                return super.startElement(tagName);
            }

            private class BlockState
            extends ParseState {
                private BlockState() {
                }

                @Override
                public void parseAttrs(Attributes attrs) {
                    int start = FontConfigHandler.this.getIntValue(attrs, FontConfigHandler.ATTR_START, -1);
                    int end = FontConfigHandler.this.getIntValue(attrs, FontConfigHandler.ATTR_END, start);
                    if (start != -1) {
                        CompositeFontState.this.addBlock(FontState.this.fontFamily, start, end);
                    }
                }
            }
        }
    }

    private class FontAliasesState
    extends ParseState {
        private FontAliasesState() {
        }

        @Override
        public ParseState startElement(String tagName) {
            String tagValue = tagName.toLowerCase();
            if (FontConfigHandler.TAG_MAPPING.equals(tagValue)) {
                return new AliasState();
            }
            return super.startElement(tagName);
        }

        class AliasState
        extends ParseState {
            AliasState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                String fontName = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_NAME);
                String fontFamily = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_FONT_FAMILY);
                if (fontName != null && fontFamily != null) {
                    ((FontAliasesState)FontAliasesState.this).FontConfigHandler.this.config.addFontAlias(fontName, fontFamily);
                }
            }
        }
    }

    private class FontEncodingsState
    extends ParseState {
        private FontEncodingsState() {
        }

        @Override
        public ParseState startElement(String tagName) {
            String tagValue = tagName.toLowerCase();
            if ("encoding".equals(tagValue)) {
                return new EncodingState();
            }
            return super.startElement(tagName);
        }

        class EncodingState
        extends ParseState {
            EncodingState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                String fontFamily = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_FONT_FAMILY);
                String fontEncoding = FontConfigHandler.this.getStringValue(attrs, "encoding");
                if (fontEncoding != null && fontFamily != null) {
                    ((FontEncodingsState)FontEncodingsState.this).FontConfigHandler.this.config.addFontEncoding(fontFamily, fontEncoding);
                }
            }
        }
    }

    private class FontKerningState
    extends ParseState {
        private FontKerningState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            String kerning = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_KERNING_ENABLED);
            if (kerning != null) {
                FontConfigHandler.this.config.setFontKerning(Boolean.valueOf(kerning));
            }
        }
    }

    private class FontPathsState
    extends ParseState {
        private FontPathsState() {
        }

        @Override
        public ParseState startElement(String tagName) {
            String tagValue = tagName.toLowerCase();
            if ("path".equals(tagValue)) {
                return new PathState();
            }
            return super.startElement(tagName);
        }

        class PathState
        extends ParseState {
            PathState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                String path = FontConfigHandler.this.getStringValue(attrs, "path");
                if (path != null) {
                    ((FontPathsState)FontPathsState.this).FontConfigHandler.this.config.addFontPath(path);
                }
            }
        }
    }

    private class FontState
    extends ParseState {
        private FontState() {
        }

        @Override
        public ParseState startElement(String tagName) {
            String tagValue = tagName.toLowerCase();
            if (FontConfigHandler.TAG_FONT_PATHS.equals(tagValue)) {
                return new FontPathsState();
            }
            if (FontConfigHandler.TAG_FONT_ALIASES.equals(tagValue) || FontConfigHandler.TAG_FONT_MAPPINGS.equals(tagValue)) {
                return new FontAliasesState();
            }
            if (FontConfigHandler.TAG_FONT_ENCODINGS.equals(tagValue)) {
                return new FontEncodingsState();
            }
            if (FontConfigHandler.TAG_SEARCH_SEQUENCES.equals(tagValue)) {
                return new SearchSequencesState(FontConfigHandler.this.config.searchSequences);
            }
            if (FontConfigHandler.TAG_ALL_FONTS.equals(tagValue)) {
                return new AllFontState();
            }
            if (FontConfigHandler.TAG_COMPOSITE_FONT.equals(tagValue)) {
                return new CompositeFontState();
            }
            if (FontConfigHandler.TAG_FONT_KERNING.equals(tagValue)) {
                return new FontKerningState();
            }
            return super.startElement(tagName);
        }
    }

    private static class ParseState {
        private ParseState() {
        }

        public void parseAttrs(Attributes attrs) {
        }

        public ParseState startElement(String tagName) {
            return AnyElementState.instance;
        }

        public void endElement(ParseState state) {
        }

        public void end() {
        }

        private static class AnyElementState
        extends ParseState {
            private static AnyElementState instance = new AnyElementState();

            private AnyElementState() {
            }

            @Override
            public ParseState startElement(String tagName) {
                return instance;
            }
        }
    }

    private class RootState
    extends ParseState {
        private RootState() {
        }

        @Override
        public ParseState startElement(String tagName) {
            String tagValue = tagName.toLowerCase();
            if (FontConfigHandler.TAG_FONT.equals(tagValue)) {
                return new FontState();
            }
            return super.startElement(tagName);
        }
    }

    private class SearchSequencesState
    extends ParseState {
        private HashMap<String, String[]> sequences;

        SearchSequencesState(HashMap<String, String[]> sequences) {
            this.sequences = sequences;
        }

        @Override
        public ParseState startElement(String tagName) {
            String tagValue = tagName.toLowerCase();
            if (FontConfigHandler.TAG_SEQUENCE.equals(tagValue)) {
                return new SequenceState();
            }
            return super.startElement(tagName);
        }

        class SequenceState
        extends ParseState {
            private String locale;
            private ArrayList<String> catalogs = new ArrayList();

            SequenceState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                this.locale = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_LOCALE);
            }

            @Override
            public ParseState startElement(String tagName) {
                String tagValue = tagName.toLowerCase();
                if ("catalog".equals(tagValue)) {
                    return new CatalogState();
                }
                return super.startElement(tagName);
            }

            @Override
            public void end() {
                if (this.locale != null && !this.catalogs.isEmpty()) {
                    SearchSequencesState.this.sequences.put(this.locale, this.catalogs.toArray(new String[0]));
                }
            }

            class CatalogState
            extends ParseState {
                CatalogState() {
                }

                @Override
                public void parseAttrs(Attributes attrs) {
                    String name = FontConfigHandler.this.getStringValue(attrs, FontConfigHandler.ATTR_NAME);
                    if (name != null && !SequenceState.this.catalogs.contains(name)) {
                        SequenceState.this.catalogs.add(name);
                    }
                }
            }
        }
    }
}

