/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDesignerStateHandle;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.DesignerStateContent;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;

public class OdaDataSetAdapterTest
extends BaseTestCase {
    private static final String INPUT_FILE = "OdaDataSetConvertTest.xml";
    private static final String INPUT_FILE_WITH_EMPTY_PROPS = "OdaDataSetEmptyProps.xml";
    private static final String INPUT_FILE_WITH_LIB = "OdaDataSetEmptyProps_1.xml";
    static final String DATA_SET_EXTENSIONID = "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet";
    static final String DATA_SOURCE_EXTENSIONID = "org.eclipse.birt.report.data.oda.jdbc";

    public void testROMDataSetToODADataSet() throws Exception {
        this.openDesign(INPUT_FILE);
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        OdaDataSetAdapterTest.assertEquals((String)"myDataSet1", (String)setDesign.getName());
        OdaDataSetAdapterTest.assertEquals((String)DATA_SET_EXTENSIONID, (String)setDesign.getOdaExtensionDataSetId());
        OdaDataSetAdapterTest.assertEquals((String)"My Data Set One", (String)setDesign.getDisplayName());
        Properties props = setDesign.getPublicProperties();
        OdaDataSetAdapterTest.assertEquals((String)"30000", (String)props.findProperty("queryTimeOut").getValue());
        props = setDesign.getPrivateProperties();
        OdaDataSetAdapterTest.assertEquals((int)1, (int)props.getProperties().size());
        OdaDataSetAdapterTest.assertEquals((String)"10000", (String)props.findProperty("queryTimeOut").getValue());
        DataSetParameters params = setDesign.getParameters();
        ParameterDefinition paramDefn = (ParameterDefinition)params.getParameterDefinitions().get(0);
        DataElementAttributes dataAttrs = paramDefn.getAttributes();
        OdaDataSetAdapterTest.assertEquals((int)1, (int)dataAttrs.getNullability().getValue());
        OdaDataSetAdapterTest.assertEquals((int)1, (int)dataAttrs.getPosition());
        OdaDataSetAdapterTest.assertEquals((int)0, (int)dataAttrs.getNativeDataTypeCode());
        OdaDataSetAdapterTest.assertEquals((int)0, (int)paramDefn.getInOutMode().getValue());
        InputParameterAttributes inParamAttrs = paramDefn.getInputAttributes();
        InputElementAttributes inElementAttrs = inParamAttrs.getElementAttributes();
        OdaDataSetAdapterTest.assertTrue((boolean)inElementAttrs.isOptional());
        OdaDataSetAdapterTest.assertEquals((String)"default value 1", (String)inElementAttrs.getDefaultScalarValue());
        OdaDataSetAdapterTest.assertNull((Object)setDesign.getResultSets());
        OdaDataSetAdapterTest.assertEquals((int)0, (int)dataAttrs.getNativeDataTypeCode());
        OdaDataSetAdapterTest.assertEquals((String)"userid", (String)setDesign.getPrimaryResultSetName());
        OdaDataSetAdapterTest.assertEquals((String)"select * from user", (String)setDesign.getQueryText());
        DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
        OdaDataSetAdapterTest.assertNotNull((Object)sourceDesign);
        OdaDataSetAdapterTest.assertEquals((String)"myDataSource1", (String)sourceDesign.getName());
        OdaDataSetAdapterTest.assertEquals((String)DATA_SOURCE_EXTENSIONID, (String)sourceDesign.getOdaExtensionId());
        OdaDataSetAdapterTest.assertEquals((String)"My Data Source One", (String)sourceDesign.getDisplayName());
        props = sourceDesign.getPublicProperties();
        OdaDataSetAdapterTest.assertEquals((String)"com.mysql.jdbc.Driver", (String)props.findProperty("odaDriverClass").getValue());
        OdaDataSetAdapterTest.assertEquals((String)"jdbc:mysql://localhost:3306/birt", (String)props.findProperty("odaURL").getValue());
        OdaDataSetAdapterTest.assertNull((Object)props.findProperty("odaUser").getValue());
        OdaDataSetAdapterTest.assertNull((Object)props.findProperty("odaPassword").getValue());
        props = sourceDesign.getPrivateProperties();
        OdaDataSetAdapterTest.assertEquals((int)2, (int)props.getProperties().size());
        OdaDataSetAdapterTest.assertEquals((String)"User", (String)props.findProperty("odaUser").getValue());
        OdaDataSetAdapterTest.assertEquals((String)"Password", (String)props.findProperty("odaPassword").getValue());
    }

    public void testODADataSetToROMDataSet() throws Exception {
        DataSetDesign setDesign = OdaDataSetAdapterTest.createDataSetDesign();
        this.createDesign();
        OdaDataSetHandle setHandle = new ModelOdaAdapter().createDataSetHandle(setDesign, (ModuleHandle)this.designHandle);
        OdaDataSetAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        OdaDataSetAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        this.designHandle.getDataSets().add((DesignElementHandle)setHandle);
        this.designHandle.getDataSources().add((DesignElementHandle)new ModelOdaAdapter().createDataSourceHandle(setDesign.getDataSourceDesign(), (ModuleHandle)this.designHandle));
        OdaDataSetAdapterTest.assertNotNull((Object)setHandle.getDataSource());
        OdaDataSetAdapterTest.assertEquals((String)"myDataSource1", (String)setHandle.getDataSource().getName());
        this.verifyODADataSetToROMDataSet();
    }

    private void verifyODADataSetToROMDataSet() throws Exception {
        this.saveAndOpenDesign();
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        OdaDataSetAdapterTest.assertNotNull((Object)setHandle);
        OdaDataSetAdapterTest.assertEquals((String)"data set display name", (String)setHandle.getDisplayName());
        OdaDataSetAdapterTest.assertEquals((Object)DATA_SET_EXTENSIONID, (Object)setHandle.getProperty("extensionID"));
        OdaDataSetAdapterTest.assertEquals((Object)"new public query time out", (Object)setHandle.getProperty("queryTimeOut"));
        OdaDataSetAdapterTest.assertEquals((String)"new private query time out", (String)setHandle.getPrivateDriverProperty("queryTimeOut"));
        List params = (List)setHandle.getProperty("parameters");
        OdaDataSetParameter param = (OdaDataSetParameter)params.get(0);
        OdaDataSetAdapterTest.assertEquals((String)"param1", (String)param.getNativeName());
        OdaDataSetAdapterTest.assertFalse((boolean)param.allowNull());
        OdaDataSetAdapterTest.assertEquals((Object)2, (Object)param.getPosition());
        OdaDataSetAdapterTest.assertEquals((Object)1, (Object)param.getNativeDataType());
        OdaDataSetAdapterTest.assertEquals((boolean)true, (boolean)param.isInput());
        OdaDataSetAdapterTest.assertEquals((boolean)true, (boolean)param.isOutput());
        OdaDataSetAdapterTest.assertEquals((String)"default param value", (String)param.getDefaultValue());
        List resultSets = (List)setHandle.getProperty("resultSet");
        OdaResultSetColumn column = (OdaResultSetColumn)resultSets.get(0);
        OdaDataSetAdapterTest.assertEquals((String)"column1", (String)column.getNativeName());
        OdaDataSetAdapterTest.assertEquals((Object)2, (Object)column.getPosition());
        OdaDataSetAdapterTest.assertEquals((Object)3, (Object)column.getNativeDataType());
        OdaDataSetAdapterTest.assertEquals((String)"resultset1", (String)setHandle.getResultSetName());
        OdaDataSetAdapterTest.assertEquals((String)"new query text", (String)setHandle.getQueryText());
    }

    public void testUpdateROMDataSetWithODADataSet() throws Exception {
        this.openDesign(INPUT_FILE_WITH_EMPTY_PROPS);
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = OdaDataSetAdapterTest.createDataSetDesign();
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, true);
        String tmpFile2 = this.saveTempFile();
        OdaDataSetAdapterTest.assertTrue((boolean)this.designHandle.getCommandStack().canUndo());
        OdaDataSetAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        this.designHandle.getCommandStack().undo();
        OdaDataSetAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        OdaDataSetAdapterTest.assertTrue((boolean)this.designHandle.getCommandStack().canRedo());
        this.verifyDataSourceAndDataSetWithEmptyProp();
        this.designHandle.getCommandStack().redo();
        this.save();
        this.verifyODADataSetToROMDataSet();
        this.openDesign(INPUT_FILE_WITH_LIB);
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        OdaDataSetAdapterTest.assertEquals((String)"Library Data Source One", (String)setHandle.getDataSource().getDisplayName());
    }

    private void verifyDataSourceAndDataSetWithEmptyProp() {
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource1");
        OdaDataSetAdapterTest.assertNotNull((Object)sourceHandle);
        OdaDataSetAdapterTest.assertNull((Object)sourceHandle.getProperty("privateDriverProperties"));
        OdaDataSetAdapterTest.assertNull((Object)sourceHandle.getProperty("userProperties"));
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        OdaDataSetAdapterTest.assertNotNull((Object)setHandle);
        OdaDataSetAdapterTest.assertNull((Object)setHandle.getProperty("privateDriverProperties"));
        OdaDataSetAdapterTest.assertNull((Object)setHandle.getProperty("userProperties"));
    }

    static DataSetDesign createDataSetDesign() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        setDesign.setName("myDataSet1");
        setDesign.setDisplayName("data set display name");
        setDesign.setOdaExtensionDataSetId(DATA_SET_EXTENSIONID);
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new public query time out");
        setDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new private query time out");
        setDesign.setPrivateProperties(props);
        DataSetParameters params = DesignFactory.eINSTANCE.createDataSetParameters();
        ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("param1");
        dataAttrs.setNullability(ElementNullability.get((int)2));
        dataAttrs.setPosition(2);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        paramDefn.setAttributes(dataAttrs);
        InputParameterAttributes inParamAttrs = DesignFactory.eINSTANCE.createInputParameterAttributes();
        InputElementAttributes inputElementAttrs = DesignFactory.eINSTANCE.createInputElementAttributes();
        inputElementAttrs.setOptional(false);
        inputElementAttrs.setDefaultScalarValue("default param value");
        inParamAttrs.setElementAttributes(inputElementAttrs);
        paramDefn.setInputAttributes(inParamAttrs);
        params.getParameterDefinitions().add((Object)paramDefn);
        setDesign.setParameters(params);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        ResultSetColumns setColumns = DesignFactory.eINSTANCE.createResultSetColumns();
        ColumnDefinition columnDefn = DesignFactory.eINSTANCE.createColumnDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("column1");
        dataAttrs.setPosition(2);
        dataAttrs.setNativeDataTypeCode(3);
        columnDefn.setAttributes(dataAttrs);
        setColumns.getResultColumnDefinitions().add((Object)columnDefn);
        resultSetDefn.setResultSetColumns(setColumns);
        setDesign.setPrimaryResultSet(resultSetDefn);
        setDesign.setPrimaryResultSetName("resultset1");
        setDesign.setQueryText("new query text");
        setDesign.setDataSourceDesign(OdaDataSetAdapterTest.createDataSourceDesign());
        return setDesign;
    }

    private static DataSourceDesign createDataSourceDesign() {
        DataSourceDesign sourceDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        sourceDesign.setName("myDataSource1");
        sourceDesign.setDisplayName("data source display name");
        sourceDesign.setOdaExtensionId(DATA_SOURCE_EXTENSIONID);
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaURL", "jdbc:sqlserver://localhost");
        props.setProperty("odaUser", "new user");
        sourceDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaPassword", "new password");
        sourceDesign.setPrivateProperties(props);
        return sourceDesign;
    }

    public void testDesignerState() throws Exception {
        this.openDesign("OdaDataSetConvertDesignerState.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DesignerState designerState = new ModelOdaAdapter().newOdaDesignerState(setHandle);
        OdaDataSetAdapterTest.assertEquals((String)"1.1", (String)designerState.getVersion());
        DesignerStateContent stateContent = designerState.getStateContent();
        OdaDataSetAdapterTest.assertEquals((String)"content as string", (String)stateContent.getStateContentAsString());
        OdaDataSetAdapterTest.assertNull((Object)stateContent.getStateContentAsBlob());
        designerState.setVersion("2.0");
        byte[] data = new byte[]{52, 50, 51, 68, 82};
        stateContent.setStateContentAsBlob(data);
        new ModelOdaAdapter().updateROMDesignerState(designerState, setHandle);
        this.save();
        this.compareTextFile("OdaDataSetDesignerState_golden.xml");
        setHandle.setDesignerState(null);
        OdaDataSetAdapterTest.assertNull((Object)setHandle.getDesignerState());
        new ModelOdaAdapter().updateROMDesignerState(designerState, setHandle);
        OdaDesignerStateHandle romDesignerState = setHandle.getDesignerState();
        OdaDataSetAdapterTest.assertNotNull((Object)romDesignerState);
        OdaDataSetAdapterTest.assertEquals((String)"2.0", (String)romDesignerState.getVersion());
    }

    public void testCreateDataSetReferDataSource() throws Exception {
        this.openDesign("CreateDataSetReferDataSource.xml");
        this.designHandle.includeLibrary("Library_2.xml", "lib");
        DataSourceHandle parent = this.designHandle.getLibrary("lib").findDataSource("Data Source");
        OdaDataSetAdapterTest.assertNotNull((Object)parent);
        ModelOdaAdapter adapter = new ModelOdaAdapter();
        OdaDataSourceHandle dataSource = (OdaDataSourceHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)parent, "testSource");
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource);
        OdaDataSetAdapterTest.assertEquals((Object)this.designHandle, (Object)dataSource.getRoot());
        adapter.createDataSourceDesign(dataSource);
        OdaDataSetHandle dataSet = this.designHandle.getElementFactory().newOdaDataSet("testDataSet", DATA_SET_EXTENSIONID);
        dataSet.setDataSource("testSource");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet);
        OdaDataSetAdapterTest.assertEquals((Object)this.designHandle, (Object)dataSet.getRoot());
        DataSetDesign dataSetDesign = adapter.createDataSetDesign(dataSet);
        dataSetDesign.setQueryText("new query text");
        adapter.updateDataSetHandle(dataSetDesign, dataSet, false);
        this.saveAndOpenDesign();
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("testSource");
        OdaDataSetAdapterTest.assertNotNull((Object)sourceHandle);
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("testDataSet");
        OdaDataSetAdapterTest.assertNotNull((Object)setHandle);
        OdaDataSetAdapterTest.assertEquals((String)"new query text", (String)setHandle.getQueryText());
    }
}

