/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.util;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.util.SerializerImpl;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.elements.ReportDesign;

public abstract class BaseTestCase
extends TestCase {
    protected ReportDesignHandle designHandle = null;
    protected LibraryHandle libraryHandle = null;
    protected ModuleHandle moduleHandle = null;
    protected SessionHandle sessionHandle = null;
    protected ByteArrayOutputStream os = null;
    protected static final String ROM_DEF_NAME = "rom.def";
    protected static final String TEST_FOLDER = "test/";
    protected static final String OUTPUT_FOLDER = "/output/";
    protected static final String INPUT_FOLDER = "input/";
    protected static final String GOLDEN_FOLDER = "golden/";
    protected static final ULocale TEST_LOCALE = new ULocale("aa");

    protected void tearDown() throws Exception {
        if (this.designHandle != null) {
            this.designHandle.close();
        }
        if (this.libraryHandle != null) {
            this.libraryHandle.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        super.tearDown();
    }

    protected ReportDesignHandle createDesign() {
        return this.createDesign(null);
    }

    protected ReportDesignHandle createDesign(ULocale locale) {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        this.designHandle = this.sessionHandle.createDesign();
        this.removeExtensionStyles();
        return this.designHandle;
    }

    protected LibraryHandle createLibrary() {
        return this.createLibrary(null);
    }

    protected LibraryHandle createLibrary(ULocale locale) {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        this.libraryHandle = this.sessionHandle.createLibrary();
        return this.libraryHandle;
    }

    protected void openDesign(String fileName) throws DesignFileException {
        this.openDesign(fileName, ULocale.getDefault());
    }

    protected void openDesign(String fileName, ULocale locale) throws DesignFileException {
        this.openDesign(fileName, ULocale.getDefault(), true);
    }

    protected void openDesign(String fileName, ULocale locale, boolean inSingleJarMode) throws DesignFileException {
        if (inSingleJarMode) {
            fileName = INPUT_FOLDER + (String)fileName;
        }
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.designHandle = inSingleJarMode ? this.sessionHandle.openDesign(this.getResource((String)fileName).toString()) : this.sessionHandle.openDesign((String)fileName);
    }

    protected URL getResource(String name) {
        return ((Object)((Object)this)).getClass().getResource(name);
    }

    protected InputStream getResourceAStream(String name) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(name);
    }

    protected void openDesignAsResource(Class theClass, String fileName) throws DesignFileException {
        this.openDesignAsResource(theClass, fileName, ULocale.getDefault());
    }

    protected void openDesignAsResource(Class theClass, String fileName, ULocale locale) throws DesignFileException {
        fileName = this.getFullQualifiedClassName() + INPUT_FOLDER + (String)fileName;
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        InputStream stream = theClass.getResourceAsStream((String)fileName);
        this.designHandle = this.sessionHandle.openDesign((String)fileName, stream);
    }

    protected void openDesign(String fileName, InputStream is) throws DesignFileException {
        this.openDesign(fileName, is, ULocale.getDefault());
    }

    protected void openDesign(String fileName, InputStream is, ULocale locale) throws DesignFileException {
        this.sessionHandle = DesignEngine.newSession((ULocale)locale);
        this.designHandle = this.sessionHandle.openDesign(fileName, is);
    }

    protected boolean compareTextFile(String goldenFileName) throws Exception {
        String tmpFileName = GOLDEN_FOLDER + goldenFileName;
        InputStream streamA = this.getResourceAStream(tmpFileName);
        if (this.os == null) {
            return false;
        }
        String outContent = this.os.toString("utf-8");
        ByteArrayInputStream streamB = new ByteArrayInputStream(this.os.toByteArray());
        InputStreamReader readerA = new InputStreamReader(streamA);
        InputStreamReader readerB = new InputStreamReader(streamB);
        boolean ok = true;
        try {
            ok = this.compareTextFile(readerA, readerB);
        }
        catch (Exception e) {
            String outFileName = goldenFileName.replace("golden", "out");
            this.saveOutputFile(outFileName, outContent);
            throw e;
        }
        return ok;
    }

    private boolean compareTextFile(Reader goldenReader, Reader outputReader) throws Exception {
        StringBuilder errorText = new StringBuilder();
        BufferedReader lineReaderA = null;
        BufferedReader lineReaderB = null;
        boolean same = true;
        int lineNo = 1;
        try {
            lineReaderA = new BufferedReader(goldenReader);
            lineReaderB = new BufferedReader(outputReader);
            String strA = lineReaderA.readLine().trim();
            String strB = lineReaderB.readLine().trim();
            while (strA != null) {
                String normalizedB;
                String normalizedA = strA.trim().replace("\u202f", " ").replaceAll("version=\"[0-9]\\.[0-9]+\\.[0-9]+\"", "");
                same = normalizedA.equals(normalizedB = strB.trim().replace("\u202f", " ").replaceAll("version=\"[0-9]\\.[0-9]+\\.[0-9]+\"", ""));
                if (!same) {
                    StringBuilder message = new StringBuilder();
                    message.append("line=");
                    message.append(lineNo);
                    message.append(" is different:\n");
                    message.append(" The line from golden file: ");
                    message.append(strA);
                    message.append("\n");
                    message.append(" The line from output file: ");
                    message.append(strB);
                    message.append("\n");
                    throw new Exception(message.toString());
                }
                strA = lineReaderA.readLine();
                strB = lineReaderB.readLine();
                ++lineNo;
            }
            same = strA == null && strB == null;
        }
        finally {
            try {
                if (lineReaderA != null) {
                    lineReaderA.close();
                }
                if (lineReaderB != null) {
                    lineReaderB.close();
                }
            }
            catch (Exception e) {
                lineReaderA = null;
                lineReaderB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected void printSemanticError(ReportDesign design) {
        if (design != null) {
            this.printErrorList(design.getAllErrors());
        }
    }

    protected void printSyntaxError(DesignFileException e) {
        if (e != null) {
            this.printErrorList(e.getErrorList());
        }
    }

    private void printErrorList(List errors) {
        if (errors != null && !errors.isEmpty()) {
            for (ErrorDetail ex : errors) {
                System.out.println(ex);
            }
        }
    }

    protected void saveLibrary() throws IOException {
        this.save((ModuleHandle)this.libraryHandle);
    }

    protected String getFullQualifiedClassName() {
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = "/" + ((String)className).replace('.', '/');
        return className;
    }

    protected void saveDesignValuesToFile(DesignValues values) throws IOException {
        if (this.os != null) {
            this.os.close();
            this.os = null;
        }
        this.os = new ByteArrayOutputStream();
        SerializerImpl.instance().write(values, (OutputStream)this.os);
        this.os.close();
    }

    protected DesignValues readDesignValuesFromFile(String fileName) throws IOException {
        fileName = INPUT_FOLDER + (String)fileName;
        InputStream is = this.getResource((String)fileName).openStream();
        BufferedInputStream baIs = new BufferedInputStream(is);
        byte[] b = new byte[8192];
        baIs.read(b);
        String strDesignValues = new String(b, "utf-8");
        DesignValues tmpValues = SerializerImpl.instance().read(strDesignValues);
        baIs.close();
        is.close();
        return tmpValues;
    }

    protected void save() throws IOException {
        this.save((ModuleHandle)this.designHandle);
    }

    protected void save(ModuleHandle moduleHandle) throws IOException {
        if (this.os != null) {
            this.os.close();
            this.os = null;
        }
        this.os = new ByteArrayOutputStream();
        if (moduleHandle != null) {
            moduleHandle.serialize((OutputStream)this.os);
        }
        this.os.close();
    }

    protected void saveOutputFile(String fileName) throws Exception {
        String strDesign = this.os.toString();
        this.saveOutputFile(fileName, strDesign);
    }

    protected void saveOutputFile(String fileName, String content) throws Exception {
        String folder = this.getTempFolder() + OUTPUT_FOLDER;
        File tmpFolder = new File(folder);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(folder + fileName);
        fos.write(content.getBytes("UTF-8"));
        fos.close();
    }

    protected String getTempFolder() {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        String outputPath = (String)tempDir + "org.eclipse.birt.report.model.adapter.oda" + this.getFullQualifiedClassName();
        return outputPath;
    }

    private void removeExtensionStyles() {
        ContainerSlot styles = this.designHandle.getModule().getSlot(0);
        styles.clear();
    }

    protected String saveTempFile() {
        try {
            this.save();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String folder = this.getTempFolder() + OUTPUT_FOLDER;
        File tmpFolder = new File(folder);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        String fileName = folder + "tmp_" + this.os.hashCode();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            fos.write(this.os.toString().getBytes("UTF-8"));
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    protected void saveAndOpenDesign() throws Exception {
        String fileName = this.saveTempFile();
        File file = new File(fileName);
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.designHandle = this.sessionHandle.openDesign(fileName);
        file.delete();
    }
}

