/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ExternalCssStyleSheet3Test
extends BaseTestCase {
    private String fileName = "ExternalCssStyleSheet3Test.css";

    public ExternalCssStyleSheet3Test(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ExternalCssStyleSheet3Test.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        super.createBlankDesign();
    }

    public void testImportExternalCssStyleSheet() throws Exception {
        this.designHandle.setBase(PLUGIN_PATH);
        CssStyleSheetHandle stylesheet = this.loadStyleSheet(this.getTempFolder() + "/input/" + this.fileName);
        ExternalCssStyleSheet3Test.assertNotNull((Object)stylesheet);
        SharedStyleHandle style1 = stylesheet.findStyle("STYLE1");
        SharedStyleHandle style2 = stylesheet.findStyle("styl2");
        SharedStyleHandle style3 = stylesheet.findStyle("style3");
        ExternalCssStyleSheet3Test.assertNotNull((Object)style1);
        ExternalCssStyleSheet3Test.assertNull((Object)style2);
        ExternalCssStyleSheet3Test.assertNotNull((Object)style3);
        ArrayList<SharedStyleHandle> styleList = new ArrayList<SharedStyleHandle>();
        styleList.add(0, style1);
        styleList.add(1, style3);
        ExternalCssStyleSheet3Test.assertEquals((int)0, (int)this.designHandle.getStyles().getCount());
        this.designHandle.importCssStyles(stylesheet, styleList);
        ExternalCssStyleSheet3Test.assertEquals((int)2, (int)this.designHandle.getStyles().getCount());
        ExternalCssStyleSheet3Test.assertEquals((String)"STYLE1", (String)this.designHandle.getStyles().get(0).getName());
        ExternalCssStyleSheet3Test.assertEquals((String)"style3", (String)this.designHandle.getStyles().get(1).getName());
    }

    public void testImportExternalCssStyleSheetWithFile() throws Exception {
        try {
            CssStyleSheetHandle stylesheet3 = this.loadStyleSheet(this.fileName);
            ExternalCssStyleSheet3Test.fail();
        }
        catch (Exception e) {
            ExternalCssStyleSheet3Test.assertNotNull((Object)e);
        }
    }

    private CssStyleSheetHandle loadStyleSheet(String fileName) throws Exception {
        return this.designHandle.openCssStyleSheet(fileName);
    }
}

