/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.util.CompareUtil;

public final class EnumNumber
extends Property
implements Numeric {
    private static final PropertyCache<EnumNumber> CACHE = new PropertyCache();
    private final EnumProperty enumProperty;

    private EnumNumber(Property enumProperty) {
        this.enumProperty = (EnumProperty)enumProperty;
    }

    public static EnumNumber getInstance(Property enumProperty) {
        return CACHE.fetch(new EnumNumber((EnumProperty)enumProperty));
    }

    @Override
    public int getEnum() {
        return this.enumProperty.getEnum();
    }

    @Override
    public String getString() {
        return this.enumProperty.toString();
    }

    @Override
    public Object getObject() {
        return this.enumProperty.getObject();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumNumber)) {
            return false;
        }
        EnumNumber other = (EnumNumber)obj;
        return CompareUtil.equal(this.enumProperty, other.enumProperty);
    }

    public int hashCode() {
        return this.enumProperty.hashCode();
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public double getNumericValue(PercentBaseContext context) {
        log.error((Object)("getNumericValue() called on " + this.enumProperty + " number"));
        return 0.0;
    }

    @Override
    public int getValue(PercentBaseContext context) {
        log.error((Object)("getValue() called on " + this.enumProperty + " number"));
        return 0;
    }

    @Override
    public int getValue() {
        log.error((Object)("getValue() called on " + this.enumProperty + " number"));
        return 0;
    }

    @Override
    public double getNumericValue() {
        log.error((Object)("getNumericValue() called on " + this.enumProperty + " number"));
        return 0.0;
    }

    @Override
    public Numeric getNumeric() {
        return this;
    }
}

