/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.AFPResourceLevelDefaults;
import org.apache.fop.afp.fonts.AFPFontCollection;
import org.apache.fop.afp.fonts.AFPFontInfo;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.RendererConfig;
import org.apache.fop.render.afp.AFPDocumentHandler;
import org.apache.fop.render.afp.AFPFontConfig;
import org.apache.fop.render.afp.AFPRendererConfig;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.util.LogUtil;

public class AFPRendererConfigurator
extends PrintRendererConfigurator {
    private static Log log = LogFactory.getLog(AFPRendererConfigurator.class);
    private final AFPEventProducer eventProducer;

    public AFPRendererConfigurator(FOUserAgent userAgent, RendererConfig.RendererConfigParser rendererConfigParser) {
        super(userAgent, rendererConfigParser);
        this.eventProducer = AFPEventProducer.Provider.get(userAgent.getEventBroadcaster());
    }

    @Override
    public void configure(IFDocumentHandler documentHandler) throws FOPException {
        AFPRendererConfig config = (AFPRendererConfig)this.getRendererConfig(documentHandler);
        if (config != null) {
            AFPDocumentHandler afpDocumentHandler = (AFPDocumentHandler)documentHandler;
            this.configure(afpDocumentHandler, config);
        }
    }

    private void configure(AFPDocumentHandler documentHandler, AFPRendererConfig config) {
        AFPResourceLevelDefaults resourceLevelDefaults;
        Boolean colorImages = config.isColorImages();
        if (colorImages != null) {
            documentHandler.setColorImages(colorImages);
            if (colorImages.booleanValue()) {
                documentHandler.setCMYKImagesSupported(config.isCmykImagesSupported());
            } else {
                documentHandler.setBitsPerPixel(config.getBitsPerPixel());
            }
        }
        if (config.getDitheringQuality() != null) {
            documentHandler.setDitheringQuality(config.getDitheringQuality().floatValue());
        }
        if (config.isNativeImagesSupported() != null) {
            documentHandler.setNativeImagesSupported(config.isNativeImagesSupported());
        }
        if (config.getShadingMode() != null) {
            documentHandler.setShadingMode(config.getShadingMode());
        }
        if (config.getResolution() != null) {
            documentHandler.setResolution(config.getResolution());
        }
        if (config.isWrapPseg() != null) {
            documentHandler.setWrapPSeg(config.isWrapPseg());
        }
        if (config.isGocaWrapPseg() != null) {
            documentHandler.setWrapGocaPSeg(config.isGocaWrapPseg());
        }
        if (config.isFs45() != null) {
            documentHandler.setFS45(config.isFs45());
        }
        if (config.isMaskEnabled() != null) {
            documentHandler.setMaskEnabled(config.isMaskEnabled());
        }
        if (config.allowJpegEmbedding() != null) {
            documentHandler.canEmbedJpeg(config.allowJpegEmbedding());
        }
        if (config.getBitmapEncodingQuality() != null) {
            documentHandler.setBitmapEncodingQuality(config.getBitmapEncodingQuality().floatValue());
        }
        if (config.getLineWidthCorrection() != null) {
            documentHandler.setLineWidthCorrection(config.getLineWidthCorrection().floatValue());
        }
        if (config.isGocaEnabled() != null) {
            documentHandler.setGOCAEnabled(config.isGocaEnabled());
        }
        if (config.isStrokeGocaText() != null) {
            documentHandler.setStrokeGOCAText(config.isStrokeGocaText());
        }
        if (config.getDefaultResourceGroupUri() != null) {
            documentHandler.setDefaultResourceGroupUri(config.getDefaultResourceGroupUri());
        }
        if ((resourceLevelDefaults = config.getResourceLevelDefaults()) != null) {
            documentHandler.setResourceLevelDefaults(resourceLevelDefaults);
        }
    }

    @Override
    protected List<FontCollection> getDefaultFontCollection() {
        return new ArrayList<FontCollection>();
    }

    @Override
    protected FontCollection getCustomFontCollection(InternalResourceResolver uriResolverWrapper, String mimeType) throws FOPException {
        AFPRendererConfig config = (AFPRendererConfig)this.getRendererConfig(mimeType);
        if (config != null) {
            try {
                return new AFPFontCollection(this.userAgent.getEventBroadcaster(), this.createFontsList(config.getFontInfoConfig(), mimeType));
            }
            catch (IOException e) {
                this.eventProducer.invalidConfiguration(this, e);
                LogUtil.handleException(log, e, this.userAgent.validateUserConfigStrictly());
            }
            catch (IllegalArgumentException iae) {
                this.eventProducer.invalidConfiguration(this, iae);
                LogUtil.handleException(log, iae, this.userAgent.validateUserConfigStrictly());
            }
        }
        return new AFPFontCollection(this.userAgent.getEventBroadcaster(), null);
    }

    private List<AFPFontInfo> createFontsList(AFPFontConfig fontConfig, String mimeType) throws FOPException, IOException {
        ArrayList<AFPFontInfo> afpFonts = new ArrayList<AFPFontInfo>();
        for (AFPFontConfig.AFPFontConfigData config : fontConfig.getFontConfig()) {
            afpFonts.add(config.getFontInfo(this.userAgent.getFontManager().getResourceResolver(), this.eventProducer));
        }
        return afpFonts;
    }
}

