/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.integration.wtp.ui.internal.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.integration.wtp.ui.internal.util.DataUtil;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.ContextParamBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.ListenerBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.ServletBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.ServletMappingBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.TagLibBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.WebAppBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JspFactory;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class WebArtifactUtil
implements IBirtWizardConstants {
    public static void configureWebApp(WebAppBean webAppBean, IProject project, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || webAppBean == null || project == null) {
            return;
        }
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        if (webEdit == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            webapp.setDescription(webAppBean.getDescription());
            webEdit.saveIfNecessary(monitor);
        }
        finally {
            webEdit.dispose();
        }
    }

    public static void configureContextParam(Map map, IProject project, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || map == null || project == null) {
            return;
        }
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        if (webEdit == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                ContextParam param;
                String name = DataUtil.getString(it.next(), false);
                ContextParamBean bean = (ContextParamBean)map.get(name);
                if (bean == null) continue;
                EList list = null;
                list = webapp.getVersionID() == 23 ? webapp.getContexts() : webapp.getContextParams();
                Object obj = WebArtifactUtil.getContextParamByName((List)list, name);
                if (obj != null) {
                    String ret = query.queryOverwrite("Context-param '" + name + "'");
                    if ("NO".equalsIgnoreCase(ret)) continue;
                    if ("CANCEL".equalsIgnoreCase(ret)) {
                        monitor.setCanceled(true);
                        return;
                    }
                    webapp.getContextParams().remove(obj);
                }
                String value = bean.getValue();
                String description = bean.getDescription();
                if (webapp.getVersionID() == 23) {
                    param = WebapplicationFactory.eINSTANCE.createContextParam();
                    param.setParamName(name);
                    param.setParamValue(value);
                    if (description != null) {
                        param.setDescription(description);
                    }
                    param.setWebApp(webapp);
                    continue;
                }
                param = CommonFactory.eINSTANCE.createParamValue();
                param.setName(name);
                param.setValue(value);
                if (description != null) {
                    Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
                    descriptionObj.setValue(description);
                    param.getDescriptions().add((Object)descriptionObj);
                    param.setDescription(description);
                }
                webapp.getContextParams().add((Object)param);
            }
            webEdit.saveIfNecessary(monitor);
        }
        finally {
            webEdit.dispose();
        }
    }

    public static Object getContextParamByName(List list, String name) {
        if (list == null || name == null) {
            return null;
        }
        for (Object paramObj : list) {
            ContextParam param;
            if (paramObj instanceof ContextParam && name.equals((param = (ContextParam)paramObj).getParamName())) {
                return param;
            }
            if (!(paramObj instanceof ParamValue) || !name.equals((param = (ParamValue)paramObj).getName())) continue;
            return param;
        }
        return null;
    }

    public static void configureListener(Map map, IProject project, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || map == null || project == null) {
            return;
        }
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        if (webEdit == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String name = DataUtil.getString(it.next(), false);
                ListenerBean bean = (ListenerBean)map.get(name);
                if (bean == null) continue;
                String className = bean.getClassName();
                String description = bean.getDescription();
                Object obj = WebArtifactUtil.getListenerByClassName((List)webapp.getListeners(), className);
                if (obj != null) continue;
                Listener listener = CommonFactory.eINSTANCE.createListener();
                listener.setListenerClassName(className);
                if (description != null) {
                    listener.setDescription(description);
                }
                webapp.getListeners().remove((Object)listener);
                webapp.getListeners().add((Object)listener);
            }
            webEdit.saveIfNecessary(monitor);
        }
        finally {
            webEdit.dispose();
        }
    }

    public static Object getListenerByClassName(List list, String className) {
        if (list == null || className == null) {
            return null;
        }
        for (Listener listener : list) {
            if (listener == null || !className.equals(listener.getListenerClassName())) continue;
            return listener;
        }
        return null;
    }

    public static void configureServlet(Map map, IProject project, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || map == null || project == null) {
            return;
        }
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        if (webEdit == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String name = DataUtil.getString(it.next(), false);
                ServletBean bean = (ServletBean)map.get(name);
                if (bean == null) continue;
                Object obj = WebArtifactUtil.getServletByName((List)webapp.getServlets(), name);
                if (obj != null) {
                    String ret = query.queryOverwrite("Servlet '" + name + "'");
                    if ("NO".equalsIgnoreCase(ret)) continue;
                    if ("CANCEL".equalsIgnoreCase(ret)) {
                        monitor.setCanceled(true);
                        return;
                    }
                    webapp.getServlets().remove(obj);
                }
                String className = bean.getClassName();
                String description = bean.getDescription();
                ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
                servletType.setClassName(className);
                Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
                servlet.setServletName(name);
                if (description != null) {
                    servlet.setDescription(description);
                }
                servlet.setWebType((WebType)servletType);
                servlet.setWebApp(webapp);
            }
            webEdit.saveIfNecessary(monitor);
        }
        finally {
            webEdit.dispose();
        }
    }

    public static Object getServletByName(List list, String name) {
        if (list == null || name == null) {
            return null;
        }
        for (Servlet servlet : list) {
            if (servlet == null || !name.equals(servlet.getServletName())) continue;
            return servlet;
        }
        return null;
    }

    public static void configureServletMapping(Map map, IProject project, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || map == null || project == null) {
            return;
        }
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        if (webEdit == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String uri = DataUtil.getString(it.next(), false);
                ServletMappingBean bean = (ServletMappingBean)map.get(uri);
                if (bean == null) continue;
                Object obj = WebArtifactUtil.getServletMappingByUri((List)webapp.getServletMappings(), uri);
                if (obj != null) {
                    String ret = query.queryOverwrite("Servlet-mapping '" + uri + "'");
                    if ("NO".equalsIgnoreCase(ret)) continue;
                    if ("CANCEL".equalsIgnoreCase(ret)) {
                        monitor.setCanceled(true);
                        return;
                    }
                    webapp.getServletMappings().remove(obj);
                }
                String name = bean.getName();
                ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
                Servlet servlet = webapp.getServletNamed(name);
                if (servlet == null) continue;
                mapping.setServlet(servlet);
                mapping.setUrlPattern(uri);
                mapping.setWebApp(webapp);
            }
            webEdit.saveIfNecessary(monitor);
        }
        finally {
            webEdit.dispose();
        }
    }

    public static Object getServletMappingByUri(List list, String uri) {
        if (list == null || uri == null) {
            return null;
        }
        for (ServletMapping servletMapping : list) {
            if (servletMapping == null || !uri.equals(servletMapping.getUrlPattern())) continue;
            return servletMapping;
        }
        return null;
    }

    public static void configureTaglib(Map map, IProject project, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || map == null || project == null) {
            return;
        }
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        if (webEdit == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String uri = DataUtil.getString(it.next(), false);
                TagLibBean bean = (TagLibBean)map.get(uri);
                if (bean == null) continue;
                Object obj = WebArtifactUtil.getTagLibByUri(webapp, uri);
                if (obj != null) {
                    String ret = query.queryOverwrite("Taglib '" + uri + "'");
                    if ("NO".equalsIgnoreCase(ret)) continue;
                    if ("CANCEL".equalsIgnoreCase(ret)) {
                        monitor.setCanceled(true);
                        return;
                    }
                    if (obj instanceof TagLibRefType && webapp.getJspConfig() != null) {
                        webapp.getJspConfig().getTagLibs().remove(obj);
                    } else {
                        webapp.getTagLibs().remove(obj);
                    }
                }
                String location = bean.getLocation();
                if (webapp.getVersionID() == 23) {
                    TagLibRef taglib = WebapplicationFactory.eINSTANCE.createTagLibRef();
                    taglib.setTaglibURI(uri);
                    taglib.setTaglibLocation(location);
                    webapp.getTagLibs().add((Object)taglib);
                    continue;
                }
                JSPConfig jspConfig = JspFactory.eINSTANCE.createJSPConfig();
                TagLibRefType ref = JspFactory.eINSTANCE.createTagLibRefType();
                ref.setTaglibURI(uri);
                ref.setTaglibLocation(location);
                jspConfig.getTagLibs().add((Object)ref);
                webapp.setJspConfig(jspConfig);
            }
            webEdit.saveIfNecessary(monitor);
        }
        finally {
            webEdit.dispose();
        }
    }

    public static Object getTagLibByUri(WebApp webapp, String uri) {
        if (webapp == null || uri == null) {
            return null;
        }
        EList list = null;
        JSPConfig config = webapp.getJspConfig();
        list = config != null ? config.getTagLibs() : webapp.getTagLibs();
        for (Object obj : list) {
            TagLibRef ref;
            if (obj instanceof TagLibRef && uri.equals((ref = (TagLibRef)obj).getTaglibURI())) {
                return ref;
            }
            if (!(obj instanceof TagLibRefType) || !uri.equals((ref = (TagLibRefType)obj).getTaglibURI())) continue;
            return ref;
        }
        return null;
    }

    public static String getContextParamValue(Map map, String name) {
        if (map == null || name == null) {
            return null;
        }
        ContextParamBean bean = (ContextParamBean)map.get(name);
        if (bean == null) {
            return null;
        }
        return bean.getValue();
    }

    public static void setContextParamValue(Map map, String name, String value) {
        ContextParamBean bean;
        if (name == null) {
            return;
        }
        if (map == null) {
            map = new HashMap<String, ContextParamBean>();
        }
        if ((bean = (ContextParamBean)map.get(name)) == null) {
            bean = new ContextParamBean(name, value);
            map.put(name, bean);
            return;
        }
        bean.setValue(value);
    }

    public static void initializeWebapp(Map map, IProject project) {
        WebArtifactEdit webEdit;
        if (project == null) {
            return;
        }
        if (map == null) {
            map = new HashMap();
        }
        if ((webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project)) == null) {
            return;
        }
        try {
            WebApp webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
            WebArtifactUtil.initializeContextParam(map, webapp);
        }
        finally {
            webEdit.dispose();
        }
    }

    protected static void initializeContextParam(Map map, WebApp webapp) {
        if (webapp == null) {
            return;
        }
        Map son = (Map)map.get("context-param");
        if (son == null) {
            return;
        }
        EList list = null;
        list = webapp.getVersionID() == 23 ? webapp.getContexts() : webapp.getContextParams();
        for (String name : son.keySet()) {
            ContextParam param;
            Object obj = WebArtifactUtil.getContextParamByName((List)list, name);
            if (obj == null) continue;
            String value = null;
            String description = null;
            if (obj instanceof ContextParam) {
                param = (ContextParam)obj;
                name = param.getParamName();
                value = param.getParamValue();
                description = param.getDescription();
            } else if (obj instanceof ParamValue) {
                param = (ParamValue)obj;
                name = param.getName();
                value = param.getValue();
                description = param.getDescription();
            }
            if (value == null) continue;
            ContextParamBean bean = new ContextParamBean(name, value);
            bean.setDescription(description);
            son.put(name, bean);
        }
    }
}

