/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.datafeed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.chart.internal.datafeed.GroupingLookupHelper;
import org.eclipse.birt.chart.internal.datafeed.ResultSetWrapper;

public class ResultSetWrapperTest
extends TestCase {
    private String[] dataExp = new String[]{"Product", "Manufacturer", "Month", "Month"};
    List dataList = new ArrayList<String>(Arrays.asList(this.dataExp));
    private String[] aggExp = new String[]{"Sum", "Sum", "Sum", "Avg"};
    List aggList = new ArrayList<String>(Arrays.asList(this.aggExp));
    List result = new ArrayList();
    Object[] oaTuple1 = new Object[]{"A", "M1", 10, 10};
    Object[] oaTuple2 = new Object[]{"B", "M2", 8, 8};
    ResultSetWrapper wrapper;

    protected void setUp() throws Exception {
        super.setUp();
        this.result.add(this.oaTuple1);
        this.result.add(this.oaTuple2);
        this.wrapper = new ResultSetWrapper(new GroupingLookupHelper((Collection)this.dataList, (Collection)this.aggList), this.result, null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.result = null;
        this.dataList = null;
        this.aggList = null;
    }

    public void testGetColumnCount() {
        ResultSetWrapperTest.assertEquals((int)4, (int)this.wrapper.getColumnCount());
    }

    public void testGetRowCount() {
        ResultSetWrapperTest.assertEquals((int)2, (int)this.wrapper.getRowCount());
    }

    public void testGetGroupCount() {
        ResultSetWrapperTest.assertEquals((int)1, (int)this.wrapper.getGroupCount());
    }

    public void testGetGroupKey() {
        ResultSetWrapperTest.assertEquals((Object)10, (Object)this.wrapper.getGroupKey(0, 2));
        ResultSetWrapperTest.assertEquals((Object)"A", (Object)this.wrapper.getGroupKey(0, "Product", "Sum"));
        ResultSetWrapperTest.assertEquals((Object)10, (Object)this.wrapper.getGroupKey(0, "Month", "Sum"));
    }
}

