/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.script.scale;

import org.eclipse.birt.chart.script.api.scale.ILinearScale;
import org.eclipse.birt.chart.script.api.scale.IScale;
import org.eclipse.birt.chart.tests.script.BaseChartTestCase;

public class LinearScaleTest
extends BaseChartTestCase {
    protected IScale getValueAxisScale(int index) {
        return this.getChartWithAxes().getValueAxes()[index].getScale();
    }

    public void testStepSize() {
        IScale scale = this.getValueAxisScale(1);
        LinearScaleTest.assertTrue((boolean)(scale instanceof ILinearScale));
        ILinearScale ls = (ILinearScale)scale;
        LinearScaleTest.assertEquals((int)ls.getStepSize(), (int)2);
        ls.setStepSize(3);
        LinearScaleTest.assertEquals((int)ls.getStepSize(), (int)3);
        scale = this.getValueAxisScale(2);
        LinearScaleTest.assertTrue((boolean)(scale instanceof ILinearScale));
        LinearScaleTest.assertEquals((int)((ILinearScale)scale).getStepSize(), (int)0);
    }

    public void testNumberOfSteps() {
        IScale scale = this.getValueAxisScale(2);
        LinearScaleTest.assertTrue((boolean)(scale instanceof ILinearScale));
        ILinearScale ls = (ILinearScale)scale;
        LinearScaleTest.assertEquals((int)ls.getNumberOfSteps(), (int)5);
        ls.setNumberOfSteps(6);
        LinearScaleTest.assertEquals((int)ls.getNumberOfSteps(), (int)6);
        scale = this.getValueAxisScale(1);
        LinearScaleTest.assertTrue((boolean)(scale instanceof ILinearScale));
        LinearScaleTest.assertEquals((int)((ILinearScale)scale).getNumberOfSteps(), (int)0);
    }

    public void testMin() {
        IScale scale = this.getValueAxisScale(1);
        LinearScaleTest.assertTrue((boolean)(scale instanceof ILinearScale));
        ILinearScale ls = (ILinearScale)scale;
        LinearScaleTest.assertEquals((int)((int)ls.getMin()), (int)10100);
        ls.setMin(10101.0);
        LinearScaleTest.assertEquals((int)((int)ls.getMin()), (int)10101);
        scale = this.getValueAxisScale(2);
        LinearScaleTest.assertTrue((String)"Axis 3 doesn't set min", (boolean)Double.isNaN(((ILinearScale)scale).getMin()));
    }

    public void testMax() {
        IScale scale = this.getValueAxisScale(1);
        LinearScaleTest.assertTrue((boolean)(scale instanceof ILinearScale));
        ILinearScale ls = (ILinearScale)scale;
        LinearScaleTest.assertEquals((int)((int)ls.getMax()), (int)10110);
        ls.setMax(10111.0);
        LinearScaleTest.assertEquals((int)((int)ls.getMax()), (int)10111);
        scale = this.getValueAxisScale(2);
        LinearScaleTest.assertTrue((String)"Axis 3 doesn't set max", (boolean)Double.isNaN(((ILinearScale)scale).getMax()));
    }
}

