/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.exception;

import java.util.Enumeration;
import java.util.ResourceBundle;
import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.junit.Test;

public class BirtExceptionTest
extends TestCase {
    private static String FATAL_ERROR_KEY = "Fatal_Error";
    private static String CONCATENATED_ERROR_KEY = "Recoverable_Error";
    private static String CONCATENATED_ERROR_ONE_ARG_KEY = "Recoverable_Error_One_Arg";
    private static String fatalError = "A fatal error has happened. please contact system administrator.";
    private static String fatalErrorDE = "German: A fatal error has happened. please contact system administrator.";
    private static String concatenatedError = "A {0} error has happened. please contact {1}.";
    private static String concatenatedErrorDE = "German: A {0} error has happened. please contact {1}.";
    private static String concatenatedErrorOneArg = "A fatal error has happened. please contact {0}.";
    private static String concatenatedErrorDEOneArg = "German: A fatal error has happened. please contact {0}.";
    private static String testPluginId = "org.eclipse.birt.core";

    @Test
    public void testNoRBException() {
        String errorCode = "No RB {0}";
        String error = "No RB Message";
        BirtException e = new BirtException(testPluginId, errorCode, (Object)"Message");
        BirtExceptionTest.assertEquals((String)errorCode, (String)e.getErrorCode());
        BirtExceptionTest.assertEquals((String)error, (String)e.getLocalizedMessage());
        BirtExceptionTest.assertEquals((String)error, (String)e.getMessage());
    }

    @Test
    public void testCorruptFormatException() {
        String errorCode = "No RB {0";
        String error = "No RB {0";
        BirtException e = new BirtException(testPluginId, errorCode, (Object)"Message");
        BirtExceptionTest.assertEquals((String)errorCode, (String)e.getErrorCode());
        BirtExceptionTest.assertEquals((String)error, (String)e.getLocalizedMessage());
        BirtExceptionTest.assertEquals((String)error, (String)e.getMessage());
    }

    @Test
    public void testBirtException() {
        BirtException e1 = new BirtException(testPluginId, FATAL_ERROR_KEY, (ResourceBundle)new MyResources());
        BirtExceptionTest.assertEquals((String)e1.getErrorCode(), (String)FATAL_ERROR_KEY);
        BirtExceptionTest.assertEquals((String)e1.getLocalizedMessage(), (String)fatalError);
        BirtExceptionTest.assertEquals((String)e1.getMessage(), (String)fatalError);
        BirtException e2 = new BirtException(testPluginId, FATAL_ERROR_KEY, (ResourceBundle)new MyResources_de());
        BirtExceptionTest.assertEquals((String)e2.getLocalizedMessage(), (String)fatalErrorDE);
        BirtException e3 = new BirtException(testPluginId, FATAL_ERROR_KEY, (ResourceBundle)new MyResources_de(), (Throwable)e1);
        BirtExceptionTest.assertEquals((String)e3.getLocalizedMessage(), (String)fatalErrorDE);
        BirtExceptionTest.assertEquals((String)e3.getCause().getLocalizedMessage(), (String)fatalError);
        BirtException e4 = new BirtException(testPluginId, CONCATENATED_ERROR_KEY, new Object[]{"fatal", "system administrator"}, (ResourceBundle)new MyResources());
        BirtExceptionTest.assertEquals((String)e4.getErrorCode(), (String)CONCATENATED_ERROR_KEY);
        BirtExceptionTest.assertEquals((String)e4.getLocalizedMessage(), (String)fatalError);
        BirtExceptionTest.assertEquals((String)e4.getMessage(), (String)fatalError);
        BirtException e5 = new BirtException(testPluginId, CONCATENATED_ERROR_KEY, new Object[]{"fatal", "system administrator"}, (ResourceBundle)new MyResources_de());
        BirtExceptionTest.assertEquals((String)e5.getLocalizedMessage(), (String)fatalErrorDE);
        BirtException e6 = new BirtException(testPluginId, CONCATENATED_ERROR_KEY, new Object[]{"fatal", "system administrator"}, (ResourceBundle)new MyResources_de(), (Throwable)e1);
        BirtExceptionTest.assertEquals((String)e6.getLocalizedMessage(), (String)fatalErrorDE);
        BirtExceptionTest.assertEquals((String)e6.getCause().getLocalizedMessage(), (String)fatalError);
        BirtException e7 = new BirtException(testPluginId, CONCATENATED_ERROR_ONE_ARG_KEY, (Object)"system administrator", (ResourceBundle)new MyResources());
        BirtExceptionTest.assertEquals((String)e7.getErrorCode(), (String)CONCATENATED_ERROR_ONE_ARG_KEY);
        BirtExceptionTest.assertEquals((String)e7.getLocalizedMessage(), (String)fatalError);
        BirtExceptionTest.assertEquals((String)e7.getMessage(), (String)fatalError);
        BirtException e8 = new BirtException(testPluginId, CONCATENATED_ERROR_ONE_ARG_KEY, (Object)"system administrator", (ResourceBundle)new MyResources_de());
        BirtExceptionTest.assertEquals((String)e8.getLocalizedMessage(), (String)fatalErrorDE);
        BirtException e9 = new BirtException(testPluginId, CONCATENATED_ERROR_ONE_ARG_KEY, (Object)"system administrator", (ResourceBundle)new MyResources_de(), (Throwable)e1);
        BirtExceptionTest.assertEquals((String)e9.getLocalizedMessage(), (String)fatalErrorDE);
        BirtExceptionTest.assertEquals((String)e9.getCause().getLocalizedMessage(), (String)fatalError);
        BirtException e10 = new BirtException(testPluginId, CONCATENATED_ERROR_ONE_ARG_KEY, (Object)"system administrator");
        BirtExceptionTest.assertEquals((String)testPluginId, (String)e10.getPluginId());
    }

    private class MyResources
    extends ResourceBundle {
        private MyResources() {
        }

        @Override
        public Object handleGetObject(String key) {
            if (key.equals(FATAL_ERROR_KEY)) {
                return fatalError;
            }
            if (key.equals(CONCATENATED_ERROR_KEY)) {
                return concatenatedError;
            }
            if (key.equals(CONCATENATED_ERROR_ONE_ARG_KEY)) {
                return concatenatedErrorOneArg;
            }
            return null;
        }

        public Enumeration getKeys() {
            return null;
        }
    }

    private class MyResources_de
    extends MyResources {
        private MyResources_de() {
        }

        @Override
        public Object handleGetObject(String key) {
            if (key.equals(FATAL_ERROR_KEY)) {
                return fatalErrorDE;
            }
            if (key.equals(CONCATENATED_ERROR_KEY)) {
                return concatenatedErrorDE;
            }
            if (key.equals(CONCATENATED_ERROR_ONE_ARG_KEY)) {
                return concatenatedErrorDEOneArg;
            }
            return null;
        }
    }
}

