/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Random;
import org.eclipse.birt.core.internal.util.EclipseUtil;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class LargeObjectTest
extends ConnectionTest {
    private static final String DTP_FLATFILE_DATASET_ID = "org.eclipse.datatools.connectivity.oda.flatfile.dataSet";
    private static final String DTP_FLATFILE_DATASOURCE_ID = "org.eclipse.datatools.connectivity.oda.flatfile";
    private static final String BIRT_FLATFILE_DATASOURCE_ID = "org.eclipse.birt.report.data.oda.flatfile";
    private static Connection m_flatFileConnection = null;
    private static String sm_pluginFile = null;
    private static String sm_manifestsDir = null;
    private static String sm_pluginFileName = "plugin.xml";
    private static String sm_dtpFlatfileId = "org.eclipse.datatools.connectivity.oda.flatfile";
    private static String sm_birtFlatfileId = "org.eclipse.birt.report.data.oda.flatfile";
    private static boolean sm_pluginTest = Platform.isRunning();
    private static final Bundle dataBundle = EclipseUtil.getBundle((String)"org.eclipse.birt.data");
    private static final Bundle driverBundle = EclipseUtil.getBundle((String)sm_dtpFlatfileId);

    @BeforeClass
    public static void largeObjectSetUp() throws Exception {
        LargeObjectTest.setupDirectories();
        TestUtil.createTestFile();
        Properties prop = new Properties();
        System.out.println("Test database: " + new File("testdatabase").getAbsolutePath());
        prop.setProperty("HOME", new File("testdatabase").getAbsolutePath());
        prop.setProperty("CHARSET", "UTF-16BE");
        m_flatFileConnection = ConnectionManager.getInstance().openConnection(DTP_FLATFILE_DATASOURCE_ID, prop, null);
    }

    @AfterClass
    public static void largeObjectTearDown() throws Exception {
        if (m_flatFileConnection != null && m_flatFileConnection.isOpen()) {
            m_flatFileConnection.close();
        }
    }

    @Test
    public void testJdbc() throws Exception {
        String command = "select * from \"testtable_lob\"";
        PreparedStatement stmt = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertTrue((boolean)stmt.execute());
        ResultSet resultSet = stmt.getResultSet();
        Assert.assertNotNull((Object)resultSet);
        IResultObject resultObject = resultSet.fetch();
        IResultClass resultClass = resultObject.getResultClass();
        Assert.assertEquals((long)2L, (long)resultClass.getFieldCount());
        String[] names = resultClass.getFieldNames();
        Assert.assertEquals((Object)"blob1", (Object)names[0]);
        Assert.assertEquals((Object)"clob1", (Object)names[1]);
        Assert.assertEquals((Object)"BLOB", (Object)resultClass.getFieldNativeTypeName(1));
        Assert.assertEquals((Object)"CLOB", (Object)resultClass.getFieldNativeTypeName(2));
        Assert.assertEquals(IBlob.class, (Object)resultClass.getFieldValueClass(1));
        Assert.assertEquals(IClob.class, (Object)resultClass.getFieldValueClass(2));
        Object obj = resultObject.getFieldValue(1);
        Assert.assertNull((Object)obj);
        obj = resultObject.getFieldValue(2);
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((Object)"abcdefg", (Object)obj.toString());
        Assert.assertEquals((Object)"bcd", (Object)obj.toString().substring(1, 4));
        stmt.close();
    }

    @Test
    public void testFlatfileBlob() throws Exception {
        String command = "select blob_col from table1";
        PreparedStatement stmt = m_flatFileConnection.prepareStatement(command, DTP_FLATFILE_DATASET_ID);
        Assert.assertTrue((boolean)stmt.execute());
        ResultSet resultSet = stmt.getResultSet();
        Assert.assertNotNull((Object)resultSet);
        IResultClass resultClass = resultSet.getMetaData();
        Assert.assertEquals((long)1L, (long)resultClass.getFieldCount());
        String[] names = resultClass.getFieldNames();
        Assert.assertEquals((Object)"blob_col", (Object)names[0]);
        Assert.assertEquals((Object)"BLOB", (Object)resultClass.getFieldNativeTypeName(1));
        Assert.assertEquals(String.class, (Object)resultClass.getFieldValueClass(1));
        IResultObject resultObject = resultSet.fetch();
        Object obj = resultObject.getFieldValue(1);
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((Object)"0123456789", (Object)obj.toString());
        stmt.close();
    }

    @Test
    public void testFlatfileClob() throws Exception {
        String command = "select clob_col from table1";
        PreparedStatement stmt = m_flatFileConnection.prepareStatement(command, DTP_FLATFILE_DATASET_ID);
        Assert.assertTrue((boolean)stmt.execute());
        ResultSet resultSet = stmt.getResultSet();
        Assert.assertNotNull((Object)resultSet);
        IResultObject resultObject = resultSet.fetch();
        IResultClass resultClass = resultObject.getResultClass();
        Assert.assertEquals((long)1L, (long)resultClass.getFieldCount());
        String[] names = resultClass.getFieldNames();
        Assert.assertEquals((Object)"clob_col", (Object)names[0]);
        Assert.assertEquals((Object)"CLOB", (Object)resultClass.getFieldNativeTypeName(1));
        Assert.assertEquals(String.class, (Object)resultClass.getFieldValueClass(1));
        Object obj = resultObject.getFieldValue(1);
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((Object)"abcdefghijklmnopqrstuvwxyz", (Object)obj.toString());
        stmt.close();
    }

    @Test
    public void testFlatfileGetBlob() throws Exception {
    }

    @Test
    public void testFlatfileGetClob() throws Exception {
    }

    private static void setupDirectories() throws IOException {
        String dataDir;
        if (sm_pluginFile != null && sm_manifestsDir != null) {
            return;
        }
        if (sm_pluginTest) {
            URL url = dataBundle.getEntry("/");
            dataDir = FileLocator.toFileURL((URL)url).getPath();
            URL jdbcUrl = driverBundle.getEntry("/");
            sm_pluginFile = FileLocator.toFileURL((URL)jdbcUrl).getPath() + sm_pluginFileName;
        } else {
            dataDir = ".";
            sm_pluginFile = dataDir + "/test/plugins/" + sm_dtpFlatfileId + "/" + sm_pluginFileName;
            System.setProperty("BIRT_HOME", dataDir + "/test");
        }
        sm_manifestsDir = dataDir + "/test/plugins/" + sm_birtFlatfileId + "/manifests/";
    }

    private static class TestUtil {
        public static final String CHARSET = "UTF-16BE";
        public static final String CONN_HOME_DIR_PROP = "HOME";
        public static final String CONN_CHARSET = "CHARSET";

        private TestUtil() {
        }

        public static void createTestFile() throws OdaException {
            TestUtil.createTestFileDirectory();
            TestUtil.createTestFile_test1();
        }

        private static void createTestFileDirectory() throws OdaException {
            File file = new File("testdatabase");
            if (file.exists()) {
                return;
            }
            try {
                file.mkdirs();
            }
            catch (SecurityException e) {
                throw new OdaException(e.getMessage());
            }
        }

        private static void createTestFile_test1() throws OdaException {
            File file = new File("testdatabase" + File.separator + "table1");
            if (file.exists()) {
                return;
            }
            try {
                FileOutputStream fos = new FileOutputStream(file);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARSET);
                Random r = new Random();
                String comma = ",";
                String endOfLine = "\n";
                osw.flush();
                String header = "INT0_COL,DOUBLE0_COL,CLOB_COL,DATE_COL,TIME_COL,TIMESTAMP_COL,BLOB_COL,INT1_COL,DOUBLE1_COL,BIGDECIMAL_COL\n";
                String types = "INT, DOUBLE, CLOB, DATE, TIME, TIMESTAMP, BLOB, INT, DOUBLE, BIGDECIMAL\n";
                osw.write(header);
                osw.write(types);
                int i = 0;
                while (i < 1234) {
                    int j = 0;
                    while (j < 10) {
                        if (j == 0) {
                            osw.write(Integer.toString(i));
                        }
                        if (j == 1 || j == 8) {
                            osw.write(Double.toString(r.nextDouble()));
                        }
                        if (j == 2) {
                            osw.write("abcdefghijklmnopqrstuvwxyz");
                        }
                        if (j == 3) {
                            int year = 1000 + i;
                            int month = i % 12 + 1;
                            int day = i % 28 + 1;
                            String s = Integer.toString(year) + "-" + Integer.toString(month) + "-" + Integer.toString(day);
                            osw.write(s);
                        }
                        if (j == 4) {
                            osw.write(Time.valueOf(i % 24 + ":" + j + ":00").toString());
                        }
                        if (j == 5) {
                            osw.write(Integer.toString(new Timestamp(System.currentTimeMillis()).getNanos()));
                        }
                        if (j == 6) {
                            osw.write("0123456789");
                        }
                        if (j == 7) {
                            osw.write(Integer.toString(r.nextInt()));
                        }
                        if (j == 9) {
                            osw.write(Double.toString(r.nextDouble()));
                        }
                        if (j < 9) {
                            osw.write(comma);
                        }
                        ++j;
                    }
                    osw.write(endOfLine);
                    ++i;
                }
                osw.close();
            }
            catch (Exception e) {
                throw new OdaException(e.getMessage());
            }
        }
    }
}

