/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeMaterializer;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSetWithOneMoreDummyAggr;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.DataSetFromOriginalCube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.SimpleLevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable1;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable2;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.junit.Assert;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.BaseTestCase;

public class FactTableHelperTest2
extends BaseTestCase {
    private DimLevel dimLevel31 = new DimLevel("dimension3", "level31");
    private DimLevel dimLevel21 = new DimLevel("dimension2", "level21");
    private DimLevel dimLevel11 = new DimLevel("dimension1", "level11");
    private DimLevel dimLevel12 = new DimLevel("dimension1", "level12");

    @Test
    public void testFactTableSaveAndLoad() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable1.L1Col);
        iterator.setLevelMember(1, FactTable1.L2Col);
        iterator.setLevelMember(2, FactTable1.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)FactTable1.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable1.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)3L);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        int[] lL1Col = new int[]{1, 2, 3};
        iterator.setLevelMember(0, lL1Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        Assert.assertEquals((long)dimensions[2].length(), (long)3L);
        FactTable1 factTable1 = new FactTable1();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable1, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        Assert.assertEquals((Object)factTable.getDimensionInfo()[0].getDimensionName(), (Object)"dimension1");
        Assert.assertEquals((long)factTable.getDimensionInfo()[0].getDimensionLength(), (long)FactTable1.L1Col.length);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[1].getDimensionName(), (Object)"dimension2");
        Assert.assertEquals((long)factTable.getDimensionInfo()[1].getDimensionLength(), (long)3L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[2].getDimensionName(), (Object)"dimension3");
        Assert.assertEquals((long)factTable.getDimensionInfo()[2].getDimensionLength(), (long)3L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[0].getMeasureName(), (Object)"measure1");
        Assert.assertEquals((long)factTable.getMeasureInfo()[0].getDataType(), (long)2L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[1].getMeasureName(), (Object)"measure2");
        Assert.assertEquals((long)factTable.getMeasureInfo()[1].getDataType(), (long)3L);
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        IDiskArray[] dimensionPosition = new IDiskArray[3];
        dimensionPosition[0] = new BufferedPrimitiveDiskArray();
        dimensionPosition[0].add((Object)new Integer(10));
        dimensionPosition[0].add((Object)new Integer(11));
        dimensionPosition[1] = new BufferedPrimitiveDiskArray();
        dimensionPosition[1].add((Object)new Integer(1));
        dimensionPosition[1].add((Object)new Integer(2));
        dimensionPosition[2] = new BufferedPrimitiveDiskArray();
        dimensionPosition[2].add((Object)new Integer(1));
        dimensionPosition[2].add((Object)new Integer(2));
        dimensionPosition[2].add((Object)new Integer(3));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)10L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(10), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(10.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)11L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(11), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(11.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertFalse((boolean)facttableRowIterator.next());
    }

    private static int[] distinct(int[] iValues) {
        Arrays.sort(iValues);
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        tempList.add(new Integer(iValues[0]));
        int i = 1;
        while (i < iValues.length) {
            if (iValues[i] != iValues[i - 1]) {
                tempList.add(new Integer(iValues[i]));
            }
            ++i;
        }
        int[] result = new int[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (Integer)tempList.get(i2);
            ++i2;
        }
        return result;
    }

    @Test
    public void testFactTableSaveAndLoad2() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad2(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad2(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)3L);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        Assert.assertEquals((long)dimensions[2].length(), (long)12L);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        Assert.assertEquals((Object)factTable.getDimensionInfo()[0].getDimensionName(), (Object)"dimension1");
        Assert.assertEquals((long)factTable.getDimensionInfo()[0].getDimensionLength(), (long)FactTable2.L1Col.length);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[1].getDimensionName(), (Object)"dimension2");
        Assert.assertEquals((long)factTable.getDimensionInfo()[1].getDimensionLength(), (long)3L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[2].getDimensionName(), (Object)"dimension3");
        Assert.assertEquals((long)factTable.getDimensionInfo()[2].getDimensionLength(), (long)12L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[0].getMeasureName(), (Object)"measure1");
        Assert.assertEquals((long)factTable.getMeasureInfo()[0].getDataType(), (long)2L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[1].getMeasureName(), (Object)"measure2");
        Assert.assertEquals((long)factTable.getMeasureInfo()[1].getDataType(), (long)3L);
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        IDiskArray[] dimensionPosition = new IDiskArray[3];
        dimensionPosition[0] = new BufferedPrimitiveDiskArray();
        dimensionPosition[0].add((Object)new Integer(10));
        dimensionPosition[0].add((Object)new Integer(11));
        dimensionPosition[1] = new BufferedPrimitiveDiskArray();
        dimensionPosition[1].add((Object)new Integer(1));
        dimensionPosition[1].add((Object)new Integer(2));
        dimensionPosition[2] = new BufferedPrimitiveDiskArray();
        dimensionPosition[2].add((Object)new Integer(3));
        dimensionPosition[2].add((Object)new Integer(4));
        dimensionPosition[2].add((Object)new Integer(5));
        dimensionPosition[2].add((Object)new Integer(10));
        dimensionPosition[2].add((Object)new Integer(11));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)10L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)10L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(10), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(10.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)11L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)11L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(11), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(11.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertFalse((boolean)facttableRowIterator.next());
    }

    @Test
    public void testFactTableSaveAndLoad3() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad3(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad3(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        IDiskArray positionArray;
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)3L);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        Assert.assertEquals((long)dimensions[2].length(), (long)12L);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        ILevel[] level = dimensions[1].getHierarchy().getLevels();
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(3)}, (boolean)true, (boolean)false);
        Level[] findLevel = new Level[]{(Level)level[0]};
        IDiskArray[] positionForFilter = new IDiskArray[2];
        positionForFilter[0] = positionArray = dimensions[1].find(findLevel, filter);
        Assert.assertEquals((long)positionArray.size(), (long)2L);
        DimensionResultIterator[] dimesionResultSets = new DimensionResultIterator[2];
        dimesionResultSets[0] = new DimensionResultIterator(dimensions[1], positionArray, new StopSign());
        positionArray = dimensions[2].findAll();
        dimesionResultSets[1] = new DimensionResultIterator(dimensions[2], positionArray, new StopSign());
        String[] dimensionNamesForFilter = new String[]{"dimension2", "dimension3"};
        positionForFilter[1] = positionArray;
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNamesForFilter, positionForFilter, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        DataSetFromOriginalCube dataSet4Aggregation = new DataSetFromOriginalCube((IFactTableRowIterator)facttableRowIterator, (IDimensionResultIterator[])dimesionResultSets, null);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(null, (IDataSet4Aggregation)dataSet4Aggregation, aggregations, 0xA00000L);
        IAggregationResultSet[] resultSet = aggregationCalculatorExecutor.execute(new StopSign());
        Assert.assertEquals((long)resultSet[0].length(), (long)2L);
        Assert.assertEquals((long)resultSet[0].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[0].getLevelIndex(this.dimLevel21), (long)0L);
        Assert.assertEquals((long)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (long)2L);
        resultSet[0].seek(0);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        Assert.assertEquals((long)resultSet[1].length(), (long)8L);
        Assert.assertEquals((long)resultSet[1].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[1].getLevelIndex(this.dimLevel31), (long)0L);
        Assert.assertEquals((long)resultSet[1].getLevelKeyDataType(this.dimLevel31, "level31"), (long)2L);
        resultSet[1].seek(0);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(0.0));
        resultSet[1].seek(1);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(2);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(3));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(2.0));
        resultSet[1].seek(3);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(4));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(3.0));
        resultSet[1].seek(4);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(5));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[1].seek(5);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(6));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(6);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(7));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[1].seek(7);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(8));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(7.0));
        this.closeResultSets(resultSet);
    }

    @Test
    public void testFactTableSaveAndLoad4() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad4(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad4(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)3L);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        Assert.assertEquals((long)dimensions[2].length(), (long)12L);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        Cube cube = new Cube("cube", documentManager);
        cube.create(CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper((ICube)cube);
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(3)}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addSimpleLevelFilter(new SimpleLevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        Assert.assertEquals((long)resultSet[0].length(), (long)2L);
        Assert.assertEquals((long)resultSet[0].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[0].getLevelIndex(this.dimLevel21), (long)0L);
        Assert.assertEquals((long)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (long)2L);
        resultSet[0].seek(0);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        Assert.assertEquals((long)resultSet[1].length(), (long)8L);
        Assert.assertEquals((long)resultSet[1].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[1].getLevelIndex(this.dimLevel31), (long)0L);
        Assert.assertEquals((long)resultSet[1].getLevelKeyDataType(this.dimLevel31, "level31"), (long)2L);
        resultSet[1].seek(0);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(0.0));
        resultSet[1].seek(1);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(2);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(3));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(2.0));
        resultSet[1].seek(3);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(4));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(3.0));
        resultSet[1].seek(4);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(5));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[1].seek(5);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(6));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(6);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(7));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[1].seek(7);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(8));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(7.0));
        this.closeResultSets(resultSet);
    }

    @Test
    public void testFactTableSaveAndLoad5() throws IOException, BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(FactTableHelperTest2.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        CubeMaterializer cubeCreatorHelper = new CubeMaterializer(engine, "cub1");
        this.testFactTableSaveAndLoad5(cubeCreatorHelper);
        cubeCreatorHelper.close();
    }

    private void testFactTableSaveAndLoad5(CubeMaterializer cubeMaterializer) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{CubeElementFactory.createLevelDefinition((String)"level11", (String[])new String[]{"level11"}, null), CubeElementFactory.createLevelDefinition((String)"level12", (String[])new String[]{"level12"}, null), CubeElementFactory.createLevelDefinition((String)"level13", (String[])new String[]{"level13"}, null)};
        IHierarchy hierarchy = cubeMaterializer.createHierarchy("dimension1", "hir1", (IDatasetIterator)iterator, levelDefs, new StopSign());
        dimensions[0] = (Dimension)cubeMaterializer.createDimension("dimension1", hierarchy);
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"hir1");
        Assert.assertEquals((long)dimensions[0].length(), (long)FactTable2.L1Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{CubeElementFactory.createLevelDefinition((String)"level21", (String[])new String[]{"level21"}, null)};
        hierarchy = cubeMaterializer.createHierarchy("dimension2", "hir2", (IDatasetIterator)iterator, levelDefs, new StopSign());
        dimensions[1] = (Dimension)cubeMaterializer.createDimension("dimension2", hierarchy);
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"hir2");
        Assert.assertEquals((long)dimensions[1].length(), (long)3L);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        hierarchy = cubeMaterializer.createHierarchy("dimension3", "hir3", (IDatasetIterator)iterator, levelDefs, new StopSign());
        dimensions[2] = (Dimension)cubeMaterializer.createDimension("dimension3", hierarchy);
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"hir3");
        Assert.assertEquals((long)dimensions[2].length(), (long)12L);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        cubeMaterializer.createCube("cube", CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(CubeQueryExecutorHelper.loadCube((String)"cube", (IDocumentManager)cubeMaterializer.getDocumentManager(), (StopSign)new StopSign()));
        ISelection[][] filter = new ISelection[1][2];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(2)}, (boolean)true, (boolean)false);
        filter[0][1] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(2)}, (Object[])new Object[]{new Integer(3)}, (boolean)true, (boolean)false);
        cubeQueryExcutorHelper.addSimpleLevelFilter(new SimpleLevelFilter(this.dimLevel21, filter[0]));
        AggregationDefinition[] aggregations = new AggregationDefinition[2];
        int[] sortType = new int[]{0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel21};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        sortType = new int[]{0, 0};
        levelsForFilter = new DimLevel[]{this.dimLevel31};
        aggregations[1] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        IAggregationResultSet[] resultSet = cubeQueryExcutorHelper.execute(aggregations, new StopSign());
        Assert.assertEquals((long)resultSet[0].length(), (long)2L);
        Assert.assertEquals((long)resultSet[0].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[0].getLevelIndex(this.dimLevel21), (long)0L);
        Assert.assertEquals((long)resultSet[0].getLevelKeyDataType(this.dimLevel21, "level21"), (long)2L);
        resultSet[0].seek(0);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        Assert.assertEquals((long)resultSet[1].length(), (long)8L);
        Assert.assertEquals((long)resultSet[1].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[1].getLevelIndex(this.dimLevel31), (long)0L);
        Assert.assertEquals((long)resultSet[1].getLevelKeyDataType(this.dimLevel31, "level31"), (long)2L);
        resultSet[1].seek(0);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(0.0));
        resultSet[1].seek(1);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[1].seek(2);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(3));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(2.0));
        resultSet[1].seek(3);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(4));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(3.0));
        resultSet[1].seek(4);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(5));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(4.0));
        resultSet[1].seek(5);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(6));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[1].seek(6);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(7));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[1].seek(7);
        Assert.assertEquals((Object)resultSet[1].getLevelKeyValue(0)[0], (Object)new Integer(8));
        Assert.assertEquals((Object)resultSet[1].getAggregationValue(0), (Object)new Double(7.0));
        this.closeResultSets(resultSet);
    }

    @Test
    public void testMaxAggregation() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testMaxAggregation(documentManager);
        documentManager.close();
    }

    private void testMaxAggregation(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)FactTable2.L3Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)3L);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        Assert.assertEquals((long)dimensions[2].length(), (long)12L);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        DimensionResultIterator[] dimesionResultSets = new DimensionResultIterator[1];
        IDiskArray positionArray = dimensions[0].findAll();
        dimesionResultSets[0] = new DimensionResultIterator(dimensions[0], positionArray, new StopSign());
        String[] dimensionNamesForFilter = new String[]{"dimension1"};
        IDiskArray[] positionsForFilter = new IDiskArray[]{positionArray};
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNamesForFilter, positionsForFilter, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("max", "measure1", "MAX")};
        aggregations[0] = new AggregationDefinition(null, null, funcitons);
        DataSetFromOriginalCube dataSet4Aggregation = new DataSetFromOriginalCube((IFactTableRowIterator)facttableRowIterator, (IDimensionResultIterator[])dimesionResultSets, null);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(null, (IDataSet4Aggregation)dataSet4Aggregation, aggregations, 0xA00000L);
        IAggregationResultSet[] resultSet = aggregationCalculatorExecutor.execute(new StopSign());
        Assert.assertEquals((long)resultSet[0].length(), (long)1L);
        resultSet[0].seek(0);
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)11);
        this.closeResultSets(resultSet);
    }

    @Test
    public void testNestAggregation() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testNestAggregation(documentManager);
        documentManager.close();
    }

    private void closeResultSets(IAggregationResultSet[] resultSets) throws IOException {
        IAggregationResultSet[] iAggregationResultSetArray = resultSets;
        int n = resultSets.length;
        int n2 = 0;
        while (n2 < n) {
            IAggregationResultSet rs = iAggregationResultSetArray[n2];
            rs.close();
            ++n2;
        }
    }

    private void testNestAggregation(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L1Col);
        iterator.setLevelMember(1, FactTable2.L2Col);
        iterator.setLevelMember(2, FactTable2.L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)FactTable2.L3Col.length);
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest2.distinct(FactTable2.L1Col));
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)3L);
        levelNames = new String[]{"level31"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTable2.L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level31", new String[]{"level31"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        Assert.assertEquals((long)dimensions[2].length(), (long)12L);
        FactTable2 factTable2 = new FactTable2();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTable2, dimensions, measureColumnName, new StopSign());
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        DimensionResultIterator[] dimesionResultSets = new DimensionResultIterator[1];
        IDiskArray positionArray = dimensions[0].findAll();
        dimesionResultSets[0] = new DimensionResultIterator(dimensions[0], positionArray, new StopSign());
        String[] dimensionNamesForFilter = new String[]{"dimension1"};
        IDiskArray[] positionsForFilter = new IDiskArray[]{positionArray};
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNamesForFilter, positionsForFilter, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        AggregationDefinition[] aggregations = new AggregationDefinition[1];
        int[] sortType = new int[]{0, 0};
        DimLevel[] levelsForFilter = new DimLevel[]{this.dimLevel11, this.dimLevel12};
        AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("total", "measure1", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        DataSetFromOriginalCube dataSet4Aggregation = new DataSetFromOriginalCube((IFactTableRowIterator)facttableRowIterator, (IDimensionResultIterator[])dimesionResultSets, null);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(null, (IDataSet4Aggregation)dataSet4Aggregation, aggregations, 0xA00000L);
        IAggregationResultSet[] resultSet = aggregationCalculatorExecutor.execute(new StopSign());
        Assert.assertEquals((long)resultSet[0].length(), (long)6L);
        Assert.assertEquals((long)resultSet[0].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[0].getLevelIndex(this.dimLevel11), (long)0L);
        Assert.assertEquals((long)resultSet[0].getLevelIndex(this.dimLevel12), (long)1L);
        resultSet[0].seek(0);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(1.0));
        resultSet[0].seek(1);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(5.0));
        resultSet[0].seek(2);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(9.0));
        resultSet[0].seek(3);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(13.0));
        resultSet[0].seek(4);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(3));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(17.0));
        resultSet[0].seek(5);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(3));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(21.0));
        IAggregationResultSet sourceAggrResultSet = resultSet[0];
        aggregations = new AggregationDefinition[1];
        funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("max_total", "total", "MAX")};
        aggregations[0] = new AggregationDefinition(null, null, funcitons);
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        ScriptContext cx = new ScriptContext();
        AggregationResultSetWithOneMoreDummyAggr ars = new AggregationResultSetWithOneMoreDummyAggr(sourceAggrResultSet, "max_total", (IBaseExpression)new ScriptExpression("data[\"total\"]"), (Scriptable)scope, cx);
        resultSet = AggregationHelper.execute((IAggregationResultSet)ars, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        Assert.assertEquals((long)resultSet[0].length(), (long)1L);
        resultSet[0].seek(0);
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(21.0));
        aggregations = new AggregationDefinition[1];
        sortType = new int[]{0};
        levelsForFilter = new DimLevel[]{this.dimLevel11};
        funcitons = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("sum_total", "total", "SUM")};
        aggregations[0] = new AggregationDefinition(levelsForFilter, sortType, funcitons);
        ars = new AggregationResultSetWithOneMoreDummyAggr(sourceAggrResultSet, "sum_total", (IBaseExpression)new ScriptExpression("data[\"total\"]"), (Scriptable)scope, cx);
        resultSet = AggregationHelper.execute((IAggregationResultSet)ars, (AggregationDefinition[])aggregations, (StopSign)new StopSign());
        Assert.assertEquals((long)resultSet[0].length(), (long)3L);
        Assert.assertEquals((long)resultSet[0].getAggregationDataType(0), (long)3L);
        Assert.assertEquals((long)resultSet[0].getLevelIndex(this.dimLevel11), (long)0L);
        resultSet[0].seek(0);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(6.0));
        resultSet[0].seek(1);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(22.0));
        resultSet[0].seek(2);
        Assert.assertEquals((Object)resultSet[0].getLevelKeyValue(0)[0], (Object)new Integer(3));
        Assert.assertEquals((Object)resultSet[0].getAggregationValue(0), (Object)new Double(38.0));
        this.closeResultSets(resultSet);
        Context.exit();
        cx.close();
    }
}

