/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.css.engine.CSSContext;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.AbstractValueManager;
import org.eclipse.birt.report.engine.css.engine.value.ListValue;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class FontFamilyManager
extends AbstractValueManager {
    public static final ListValue DEFAULT_VALUE = new ListValue();
    protected static final StringMap values;

    static {
        DEFAULT_VALUE.append(new StringValue(19, "Arial"));
        DEFAULT_VALUE.append(new StringValue(19, "Helvetica"));
        DEFAULT_VALUE.append(new StringValue(21, "sans-serif"));
        values = new StringMap();
        values.put("cursive", CSSValueConstants.CURSIVE_VALUE);
        values.put("fantasy", CSSValueConstants.FANTASY_VALUE);
        values.put("monospace", CSSValueConstants.MONOSPACE_VALUE);
        values.put("serif", CSSValueConstants.SERIF_VALUE);
        values.put("sans-serif", CSSValueConstants.SANS_SERIF_VALUE);
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public String getPropertyName() {
        return "font-family";
    }

    @Override
    public Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return CSSValueConstants.INHERIT_VALUE;
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
            }
            case 35: 
            case 36: 
        }
        ListValue result = new ListValue();
        do {
            switch (lu.getLexicalUnitType()) {
                case 36: {
                    result.append(new StringValue(19, lu.getStringValue()));
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                case 35: {
                    StringBuilder sb = new StringBuilder(lu.getStringValue());
                    lu = lu.getNextLexicalUnit();
                    if (lu != null && lu.getLexicalUnitType() == 35) {
                        do {
                            sb.append(' ');
                            sb.append(lu.getStringValue());
                        } while ((lu = lu.getNextLexicalUnit()) != null && lu.getLexicalUnitType() == 35);
                        result.append(new StringValue(19, sb.toString()));
                        break;
                    }
                    String id = sb.toString();
                    String s = id.toLowerCase().intern();
                    CSSValue v = (CSSValue)values.get(s);
                    result.append(v != null ? v : new StringValue(19, id));
                }
            }
            if (lu == null) {
                return result;
            }
            if (lu.getLexicalUnitType() == 0) continue;
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        } while ((lu = lu.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    public CSSValue computeValue(CSSEngine engine, int idx, CSSValue value) {
        if (value == DEFAULT_VALUE) {
            CSSContext ctx = engine.getCSSContext();
            value = ctx.getDefaultFontFamily();
        }
        return value;
    }
}

