/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.InlineContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.TextArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFInlineStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;

public class PDFLineAreaLM
extends PDFInlineStackingLM
implements ILineStackingLayoutManager {
    protected int lineCount = 0;
    protected int currentPosition = 0;
    protected boolean breakAfterRelayout = false;
    protected boolean lineFinished = true;
    protected HashMap positionMap = new HashMap();
    protected ContainerArea last = null;
    protected int expectedIP = 0;
    protected IReportItemExecutor unfinishedExecutor = null;
    protected boolean isEmpty = true;

    public PDFLineAreaLM(PDFLayoutEngineContext context, PDFStackingLM parent, IReportItemExecutor executor) {
        super(context, parent, null, executor);
    }

    @Override
    protected boolean submitRoot() {
        boolean submit = super.submitRoot();
        if (!submit) {
            // empty if block
        }
        this.last = this.root;
        return submit;
    }

    @Override
    protected boolean traverseChildren() throws BirtException {
        if (this.last != null) {
            if (!this.parent.addArea(this.last, false, false)) {
                this.context.setAutoPageBreak(true);
                return false;
            }
            this.last = null;
            this.last = null;
            if (this.breakAfterRelayout) {
                this.breakAfterRelayout = false;
                return true;
            }
        }
        boolean childBreak = false;
        if (this.children.size() > 0) {
            Iterator iterLM = this.children.iterator();
            while (iterLM.hasNext()) {
                PDFAbstractLM childLM;
                this.child = childLM = (PDFAbstractLM)iterLM.next();
                boolean currentBreak = childLM.layout();
                if (currentBreak) {
                    childBreak = true;
                    continue;
                }
                iterLM.remove();
            }
            if (childBreak) {
                return true;
            }
        }
        boolean childHasNext = false;
        while (this.executor.hasNextChild() || this.unfinishedExecutor != null) {
            IReportItemExecutor childExecutor = null;
            if (this.unfinishedExecutor != null) {
                childExecutor = this.unfinishedExecutor;
                this.unfinishedExecutor = null;
            } else {
                childExecutor = this.executor.getNextChild();
            }
            assert (childExecutor != null);
            boolean bl = childHasNext = this.handleChild(childExecutor) || childHasNext;
            if (!childHasNext || !this.lineFinished) continue;
            return true;
        }
        return childHasNext;
    }

    protected boolean handleChild(IReportItemExecutor childExecutor) throws BirtException {
        boolean childBreak = false;
        IContent childContent = childExecutor.execute();
        PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, childExecutor);
        if (this.needLineBreak(childContent)) {
            this.unfinishedExecutor = childExecutor;
            return !this.endLine();
        }
        childBreak = childLM.layout();
        if (childBreak && !childLM.isFinished()) {
            this.addChild(childLM);
            if (this.currentIP < this.expectedIP) {
                this.currentIP = this.expectedIP;
            }
        }
        return childBreak;
    }

    @Override
    protected void createRoot() {
        this.root = AreaFactory.createLineArea(this.context.getReport());
        ++this.lineCount;
    }

    @Override
    protected void initialize() {
        this.createRoot();
        this.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        this.maxAvaHeight = this.parent.getCurrentMaxContentHeight();
        this.root.setWidth(this.parent.getCurrentMaxContentWidth());
        this.setCurrentBP(0);
        this.setCurrentIP(0);
        this.setupMinHeight();
    }

    @Override
    public void setTextIndent(ITextContent content) {
        if (this.isEmpty && content != null) {
            IStyle contentStyle = content.getComputedStyle();
            this.setCurrentIP(this.getDimensionValue(contentStyle.getProperty(26), this.maxAvaWidth));
        }
    }

    @Override
    public boolean endLine() {
        this.updateLine();
        this.align(false);
        boolean ret = true;
        if (this.root.getChildrenCount() > 0) {
            ret = this.parent.addArea(this.root, false, false);
        }
        this.lineFinished = true;
        if (ret) {
            this.initialize();
            this.last = null;
            return true;
        }
        this.last = this.root;
        return false;
    }

    @Override
    protected void closeLayout() {
        this.updateLine();
        this.align(true);
    }

    @Override
    public boolean addArea(IArea area, boolean keepWithPrevious, boolean keepWithNext) {
        this.submit((AbstractArea)area);
        return true;
    }

    protected void setupMinHeight() {
        assert (this.parent instanceof PDFBlockStackingLM);
        int lineHeight = ((PDFBlockStackingLM)this.parent).getLineHeight();
        if (lineHeight > 0) {
            this.minHeight = lineHeight;
        }
    }

    protected void updateLine() {
        if (this.root == null) {
            return;
        }
        int height = this.root.getHeight();
        int lineHeight = ((PDFBlockStackingLM)this.parent).getLineHeight();
        height = this.parent.isPageEmpty() ? Math.min(this.maxAvaHeight, Math.max(height, lineHeight)) : Math.max(height, lineHeight);
        this.root.setContentHeight(height);
    }

    protected void align(boolean lastLine) {
        if (this.root == null) {
            return;
        }
        assert (this.parent instanceof PDFBlockStackingLM);
        String align = ((PDFBlockStackingLM)this.parent).getTextAlign();
        boolean isRightAligned = BidiAlignmentResolver.isRightAligned(this.root.getContent(), align, lastLine);
        if (isRightAligned || "center".equalsIgnoreCase(align)) {
            int spacing = this.root.getContentWidth() - this.getCurrentIP();
            Iterator<IArea> iter = this.root.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                if (spacing <= 0) continue;
                if (isRightAligned) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!"center".equalsIgnoreCase(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        } else if ("justify".equalsIgnoreCase(align) && !lastLine) {
            this.justify();
        }
        this.verticalAlign();
    }

    @Override
    public boolean isEmptyLine() {
        return this.isRootEmpty();
    }

    private boolean needLineBreak(IContent content) {
        int specWidth = 0;
        int avaWidth = this.getCurrentMaxContentWidth();
        int calWidth = this.getDimensionValue(content.getWidth());
        if (calWidth > 0 && calWidth < this.maxAvaWidth) {
            specWidth = calWidth;
        }
        if (specWidth <= avaWidth && specWidth > 0) {
            this.expectedIP = this.currentIP + specWidth;
        }
        return specWidth > avaWidth;
    }

    @Override
    public void submit(AbstractArea area) {
        area.setAllocatedPosition(this.getCurrentIP(), this.getCurrentBP());
        this.setCurrentIP(this.getCurrentIP() + area.getAllocatedWidth());
        if (this.getCurrentIP() > this.root.getContentWidth()) {
            this.root.setContentWidth(this.getCurrentIP());
        }
        if (this.getCurrentBP() + area.getAllocatedHeight() > this.root.getContentHeight()) {
            this.root.setContentHeight(this.getCurrentBP() + area.getAllocatedHeight());
        }
        this.root.addChild(area);
        this.isEmpty = false;
        this.lineFinished = false;
    }

    protected void justify() {
        block15: {
            Iterator<IArea> it;
            InlineContainerArea container;
            IStyle style;
            AbstractArea area;
            int index;
            Iterator<IArea> iter;
            int[] chars;
            int charNumber;
            int spacing;
            block14: {
                spacing = this.root.getContentWidth() - this.getCurrentIP();
                int blankNumber = 0;
                charNumber = 0;
                int[] blanks = new int[this.root.getChildrenCount()];
                chars = new int[this.root.getChildrenCount()];
                iter = this.root.getChildren();
                index = 0;
                while (iter.hasNext()) {
                    Iterator<IArea> it2;
                    AbstractArea child;
                    InlineContainerArea container2;
                    AbstractArea area2 = (AbstractArea)iter.next();
                    if (area2 instanceof TextArea) {
                        String text = ((TextArea)area2).getText();
                        blanks[index] = text.split(" ").length - 1;
                        chars[index] = text.length() > 1 ? text.length() - 1 : 0;
                        blankNumber += blanks[index];
                        charNumber += chars[index];
                    } else if (area2 instanceof InlineContainerArea && (container2 = (InlineContainerArea)area2).getChildrenCount() == 1 && (child = (AbstractArea)(it2 = container2.getChildren()).next()) instanceof TextArea) {
                        String text = ((TextArea)child).getText();
                        blanks[index] = text.split(" ").length - 1;
                        chars[index] = text.length() > 1 ? text.length() - 1 : 0;
                        blankNumber += blanks[index];
                        charNumber += chars[index];
                    }
                    ++index;
                }
                if (blankNumber <= 0) break block14;
                iter = this.root.getChildren();
                int posDelta = 0;
                int wordSpacing = spacing / blankNumber;
                index = 0;
                while (iter.hasNext()) {
                    AbstractArea child;
                    area = (AbstractArea)iter.next();
                    if (area instanceof TextArea) {
                        style = area.getStyle();
                        int original = this.getDimensionValue(style.getProperty(42));
                        style.setProperty(42, new FloatValue(1, original + wordSpacing));
                        area.setWidth(area.getWidth() + wordSpacing * blanks[index]);
                    } else if (area instanceof InlineContainerArea && (container = (InlineContainerArea)area).getChildrenCount() == 1 && (child = (AbstractArea)(it = container.getChildren()).next()) instanceof TextArea) {
                        IStyle style2 = child.getStyle();
                        int original = this.getDimensionValue(style2.getProperty(42));
                        style2.setProperty(42, new FloatValue(1, original + wordSpacing));
                        child.setWidth(area.getWidth() + wordSpacing * blanks[index]);
                        area.setWidth(area.getWidth() + wordSpacing * blanks[index]);
                    }
                    area.setPosition(area.getX() + posDelta, area.getY());
                    if (blanks[index] > 0) {
                        posDelta += wordSpacing * blanks[index];
                    }
                    ++index;
                }
                break block15;
            }
            if (charNumber <= 0) break block15;
            iter = this.root.getChildren();
            int posDelta = 0;
            int letterSpacing = spacing / charNumber;
            index = 0;
            while (iter.hasNext()) {
                AbstractArea child;
                area = (AbstractArea)iter.next();
                if (area instanceof TextArea) {
                    style = area.getStyle();
                    int original = this.getDimensionValue(style.getProperty(70));
                    style.setProperty(70, new FloatValue(1, original + letterSpacing));
                    area.setWidth(area.getWidth() + letterSpacing * chars[index]);
                } else if (area instanceof InlineContainerArea && (container = (InlineContainerArea)area).getChildrenCount() == 1 && (child = (AbstractArea)(it = container.getChildren()).next()) instanceof TextArea) {
                    IStyle style3 = child.getStyle();
                    int original = this.getDimensionValue(style3.getProperty(70));
                    style3.setProperty(70, new FloatValue(1, original + letterSpacing));
                    child.setWidth(area.getWidth() + letterSpacing * chars[index]);
                    area.setWidth(area.getWidth() + letterSpacing * chars[index]);
                }
                area.setPosition(area.getX() + posDelta, area.getY());
                if (chars[index] > 0) {
                    posDelta += letterSpacing * chars[index];
                }
                ++index;
            }
        }
    }

    @Override
    public int getMaxLineWidth() {
        return this.maxAvaWidth;
    }
}

