/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignElementCloneForTemplateTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCloneForTemplateLabel() throws Exception {
        this.openDesign("DesignElementCloneForTemplate.xml");
        TemplateElementHandle templateLabelHandle = (TemplateElementHandle)this.designHandle.findElement("template label");
        DesignElementCloneForTemplateTest.assertNotNull((Object)templateLabelHandle);
        String copiedExtendsName = ((DesignElement)templateLabelHandle.copyDefaultElement()).getExtendsName();
        DesignElementCloneForTemplateTest.assertEquals((String)"Library_CloneForTemplate.NewLabel", (String)copiedExtendsName);
    }

    public void testCloneForTemplateTable() throws Exception {
        this.openDesign("DesignElementCloneForTemplate.xml");
        TemplateElementHandle templateLabelHandle = (TemplateElementHandle)this.designHandle.findElement("template table");
        DesignElementCloneForTemplateTest.assertNotNull((Object)templateLabelHandle);
        TableItem copiedTable = (TableItem)templateLabelHandle.copyDefaultElement();
        String copiedExtendsName = copiedTable.getExtendsName();
        DesignElementCloneForTemplateTest.assertEquals((String)"Library_CloneForTemplate.NewTable", (String)copiedExtendsName);
        ContainerSlot slot = copiedTable.getSlot(2);
        DesignElementCloneForTemplateTest.assertEquals((int)1, (int)slot.getCount());
        TableRow row = (TableRow)slot.getContent(0);
        slot = row.getSlot(0);
        DesignElementCloneForTemplateTest.assertTrue((-1L != row.getBaseId() ? 1 : 0) != 0);
        DesignElementCloneForTemplateTest.assertEquals((int)3, (int)slot.getCount());
        TableGroup group = (TableGroup)copiedTable.getSlot(1).getContent(0);
        slot = group.getSlot(0);
        DesignElementCloneForTemplateTest.assertEquals((int)1, (int)slot.getCount());
        row = (TableRow)slot.getContent(0);
        slot = row.getSlot(0);
        DesignElementCloneForTemplateTest.assertTrue((-1L != row.getBaseId() ? 1 : 0) != 0);
        DesignElementCloneForTemplateTest.assertEquals((int)3, (int)slot.getCount());
    }
}

