/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StructRefTest
extends BaseTestCase {
    private static final String fileName = "StructRefTest.xml";
    private static final String fileName_1 = "StructRefTest_1.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(fileName_1);
        StructRefTest.assertEquals((int)1, (int)this.designHandle.getErrorList().size());
    }

    public void testStructReferenceBySet() throws Exception {
        this.openDesign(fileName);
        StructRefTest.assertEquals((int)0, (int)this.designHandle.getErrorList().size());
        EmbeddedImage emImageOne = this.design.findImage("image one");
        EmbeddedImage emImageTwo = this.design.findImage("image two");
        StructRefTest.assertNotNull((Object)emImageOne);
        StructRefTest.assertNotNull((Object)emImageTwo);
        List clients = emImageOne.getClientList();
        StructRefTest.assertEquals((int)2, (int)clients.size());
        StructRefTest.assertEquals((String)"Image1", (String)((BackRef)clients.get(0)).getElement().getName());
        StructRefTest.assertEquals((String)"imageName", (String)((BackRef)clients.get(0)).getPropertyName());
        StructRefTest.assertEquals((String)"Image2", (String)((BackRef)clients.get(1)).getElement().getName());
        StructRefTest.assertEquals((String)"imageName", (String)((BackRef)clients.get(1)).getPropertyName());
        clients = emImageTwo.getClientList();
        StructRefTest.assertEquals((int)1, (int)clients.size());
        StructRefTest.assertEquals((String)"Image3", (String)((BackRef)clients.get(0)).getElement().getName());
        StructRefTest.assertEquals((String)"imageName", (String)((BackRef)clients.get(0)).getPropertyName());
        ActivityStack stack = this.design.getActivityStack();
        ImageHandle imageHandle = this.designHandle.getElementFactory().newImage("Image4");
        SlotHandle body = this.designHandle.getBody();
        body.add((DesignElementHandle)imageHandle);
        imageHandle.setImageName("image one");
        StructRefTest.assertEquals((int)3, (int)emImageOne.getClientList().size());
        stack.undo();
        StructRefTest.assertEquals((int)2, (int)emImageOne.getClientList().size());
        stack.redo();
        StructRefTest.assertEquals((int)3, (int)emImageOne.getClientList().size());
        imageHandle = (ImageHandle)this.designHandle.findElement("Image1");
        imageHandle.setImageName(null);
        StructRefTest.assertEquals((int)2, (int)emImageOne.getClientList().size());
        stack.undo();
        StructRefTest.assertEquals((int)3, (int)emImageOne.getClientList().size());
        stack.redo();
        StructRefTest.assertEquals((int)2, (int)emImageOne.getClientList().size());
        imageHandle.setImageName("wrong image");
        StructRefValue value = (StructRefValue)imageHandle.getElement().getProperty((Module)this.design, "imageName");
        StructRefTest.assertFalse((boolean)value.isResolved());
        StructRefTest.assertEquals((String)"wrong image", (String)imageHandle.getImageName());
        imageHandle.getElement().validateWithContents((Module)this.design);
        StructRefTest.assertTrue((imageHandle.getElement().getErrors().size() > 0 ? 1 : 0) != 0);
    }

    public void testAddRemoveImageItem() throws Exception {
        this.openDesign(fileName);
    }

    public void testDeleteAndReplace() throws Exception {
        this.openDesign(fileName);
        EmbeddedImage emImageOne = this.design.findImage("image one");
        EmbeddedImage emImageTwo = this.design.findImage("image two");
        StructRefTest.assertNotNull((Object)emImageOne);
        StructRefTest.assertNotNull((Object)emImageTwo);
        PropertyHandle images = this.designHandle.getPropertyHandle("images");
        StructRefTest.assertNotNull((Object)images);
        ActivityStack stack = this.design.getActivityStack();
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image3");
        StructRefTest.assertNotNull((Object)imageHandle);
        MyListener listener = new MyListener();
        imageHandle.addListener((Listener)listener);
        images.removeItem((Object)emImageTwo);
        stack.undo();
        ArrayList imageList = images.getListValue();
        StructRefTest.assertEquals((int)2, (int)imageList.size());
        imageHandle = (ImageHandle)this.designHandle.findElement("Image3");
        imageHandle.removeListener((Listener)listener);
        listener = new MyListener();
        imageHandle.addListener((Listener)listener);
        EmbeddedImage newImage = (EmbeddedImage)emImageTwo.copy();
        newImage.setName("image new");
        images.replaceItem((IStructure)emImageTwo, (IStructure)newImage);
        StructRefTest.assertEquals((String)(imageHandle.getName() + " : notification"), (String)listener.getNotification());
        imageHandle.getElement().validateWithContents((Module)this.design);
        StructRefTest.assertTrue((imageHandle.getElement().getErrors().size() > 0 ? 1 : 0) != 0);
    }

    public void testAdd() throws Exception {
        this.openDesign(fileName);
        EmbeddedImage emImageOne = this.design.findImage("image one");
        EmbeddedImage emImageTwo = this.design.findImage("image two");
        StructRefTest.assertNotNull((Object)emImageOne);
        StructRefTest.assertNotNull((Object)emImageTwo);
        PropertyHandle images = this.designHandle.getPropertyHandle("images");
        StructRefTest.assertNotNull((Object)images);
    }

    public void testSetProperty() throws Exception {
        this.openDesign(fileName);
        EmbeddedImage emImageOne = this.design.findImage("image one");
        EmbeddedImage emImageTwo = this.design.findImage("image two");
        StructRefTest.assertNotNull((Object)emImageOne);
        StructRefTest.assertNotNull((Object)emImageTwo);
        PropertyHandle images = this.designHandle.getPropertyHandle("images");
        StructRefTest.assertNotNull((Object)images);
        StructureHandle emImageTwoHandle = images.getAt(1);
        emImageTwoHandle.getMember("name").setValue((Object)"image new");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image3");
        StructRefTest.assertEquals((String)"image new", (String)imageHandle.getImageName());
    }

    public void testSetMember() throws Exception {
        this.openDesign(fileName);
        FreeFormHandle element = this.designHandle.getElementFactory().newFreeForm("test");
        this.designHandle.getBody().add((DesignElementHandle)element);
        PropertyHandle mapRules = element.getPropertyHandle("mapRules");
        MapRule mapRule = StructureFactory.createMapRule();
        StructRefTest.assertNotNull((Object)mapRules);
        mapRules.addItem((IStructure)mapRule);
        StructRefTest.assertEquals((int)1, (int)mapRules.getListValue().size());
        StructRefTest.assertEquals((Object)mapRule, mapRules.getListValue().get(0));
        MapRuleHandle ruleHandle = (MapRuleHandle)mapRules.getAt(0);
        StructRefTest.assertEquals((String)"eq", (String)ruleHandle.getOperator());
        MyListener listener = new MyListener();
        element.addListener((Listener)listener);
        ruleHandle.setOperator(null);
        StructRefTest.assertEquals((String)"eq", (String)ruleHandle.getOperator());
        StructRefTest.assertNull((Object)listener.getNotification());
        ruleHandle.setOperator("eq");
        StructRefTest.assertEquals((String)(element.getName() + " : notification"), (String)listener.getNotification());
    }

    class MyListener
    implements Listener {
        String imageName = null;
        static final String STATUS = " : notification";

        MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.imageName = focus.getName() + STATUS;
        }

        public String getNotification() {
            return this.imageName;
        }
    }
}

