/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import com.ibm.icu.util.ULocale;
import java.net.URLDecoder;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportDesignTest
extends BaseTestCase {
    private String fileName = "ReportDesignTest.xml";

    public void testMakeUniqueName() throws DesignFileException {
        this.openDesign(this.fileName, ULocale.ENGLISH);
        ElementFactory elementFactory = new ElementFactory((Module)this.design);
        OdaDataSetHandle dataSetHandle = elementFactory.newOdaDataSet(null);
        ReportDesignTest.assertEquals((String)"NewOdaDataSet", (String)dataSetHandle.getElement().getName());
        dataSetHandle = elementFactory.newOdaDataSet("firstDataSet");
        ReportDesignTest.assertEquals((String)"firstDataSet1", (String)dataSetHandle.getElement().getName());
        dataSetHandle = elementFactory.newOdaDataSet("firstDataSet10");
        ReportDesignTest.assertEquals((String)"firstDataSet10", (String)dataSetHandle.getElement().getName());
    }

    public void testIsFileExist() throws Exception {
        this.openDesign(this.fileName);
        String base = this.designHandle.getBase();
        ReportDesignTest.assertNull((Object)base);
        ReportDesignTest.assertTrue((boolean)this.design.isFileExist("ReportDesignTest.xml", 1));
        base = this.getResource("input/ReportDesignTest.xml").getFile();
        base = URLDecoder.decode(base, "UTF-8");
        this.design.setFileName(base);
        ReportDesignTest.assertTrue((boolean)this.design.isFileExist("./ReportDesignTest.xml", 1));
        ReportDesignTest.assertFalse((boolean)this.design.isFileExist("1.jpg", 1));
    }

    public void testCollectProperties() throws Exception {
        this.openDesign(this.fileName);
        List list = this.design.collectPropValues(6, "bookmark");
        ReportDesignTest.assertEquals((int)2, (int)list.size());
        ReportDesignTest.assertTrue((boolean)(list.get(0) instanceof Expression));
        ReportDesignTest.assertTrue((boolean)(list.get(1) instanceof Expression));
        ReportDesignTest.assertEquals((String)"TableBookmark", (String)((Expression)list.get(0)).getStringExpression());
        ReportDesignTest.assertEquals((String)"DataBookmark", (String)((Expression)list.get(1)).getStringExpression());
        list = this.design.collectPropValues(6, "toc");
        ReportDesignTest.assertEquals((int)2, (int)list.size());
        ReportDesignTest.assertTrue((boolean)(list.get(0) instanceof TOC));
        ReportDesignTest.assertTrue((boolean)(list.get(1) instanceof TOC));
        ReportDesignTest.assertEquals((String)"TableToc", (String)((TOC)list.get(0)).getExpression());
        ReportDesignTest.assertEquals((String)"DataToc", (String)((TOC)list.get(1)).getExpression());
    }
}

