/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;

public class OSGiPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IProject project = this.getProject(receiver);
        if (project != null && "isOSGiClasspathProject".equals(property)) {
            return OSGiPropertyTester.isOSGiClasspathProject(project);
        }
        return false;
    }

    public static boolean isOSGiClasspathProject(IProject project) {
        if (OSGiPropertyTester.isJavaNature(project)) {
            if (OSGiPropertyTester.isPdeNature(project) || OSGiPropertyTester.isBndToolsNature(project)) {
                return true;
            }
            if (OSGiPropertyTester.isAutomaticManifest(project) || OSGiPropertyTester.isManifestFirst(project)) {
                return true;
            }
            if (OSGiPropertyTester.isBndWithClasspath(project)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAutomaticManifest(IProject project) {
        return project.getFile("pde.bnd").exists();
    }

    protected static boolean isBndWithClasspath(IProject project) {
        File projectDir;
        IPath location;
        IFile bndFile = project.getFile("bnd.bnd");
        if (bndFile.exists() && (location = project.getLocation()) != null && (projectDir = location.toFile()) != null) {
            try {
                Project plainBnd = Workspace.getProject((File)projectDir);
                if (!plainBnd.getBuildpath().isEmpty() || !plainBnd.getTestpath().isEmpty()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected static boolean isManifestFirst(IProject project) {
        IFile manifestFile = project.getFile("META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream contents = manifestFile.getContents();){
                    Manifest manifest = new Manifest(contents);
                    boolean bl = manifest.getMainAttributes().getValue("Bundle-ManifestVersion") != null;
                    return bl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isBndToolsNature(IProject project) {
        try {
            return project.hasNature("bndtools.core.bndnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static boolean isPdeNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.pde.PluginNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static boolean isJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private IProject getProject(Object receiver) {
        if (receiver instanceof IProject) {
            IProject project = (IProject)receiver;
            return project;
        }
        if (receiver instanceof IJavaProject) {
            IJavaProject java = (IJavaProject)receiver;
            return java.getProject();
        }
        return null;
    }
}

