/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import aQute.bnd.build.Workspace;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.RequirementImpl;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.repository.osgi.OSGiRepository;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RepositoryPlugin;
import aQute.service.reporter.Reporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.bndtools.templating.Template;
import org.bndtools.templating.TemplateEngine;
import org.bndtools.templating.TemplateLoader;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.pde.bnd.ui.preferences.ReposPreference;
import org.eclipse.pde.bnd.ui.templating.BundleLocator;
import org.eclipse.pde.bnd.ui.templating.CapabilityBasedTemplate;
import org.eclipse.pde.bnd.ui.templating.DirectDownloadBundleLocator;
import org.eclipse.pde.bnd.ui.templating.RepoPluginsBundleLocator;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.repository.Repository;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@Component(name="org.bndtools.templating.repos", property={"source=workspace", "service.description=Load templates from the Workspace and Repositories", "service.ranking:Integer=2147483647"})
public class ReposTemplateLoader
implements TemplateLoader {
    static final int RANKING = Integer.MAX_VALUE;
    private static final String NS_TEMPLATE = "org.bndtools.template";
    private final ConcurrentMap<String, TemplateEngine> engines = new ConcurrentHashMap<String, TemplateEngine>();
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<Workspace> workspaces = new CopyOnWriteArrayList<Workspace>();
    private PromiseFactory promiseFactory;
    private ExecutorService localExecutor = null;
    @Reference(target="(&(objectClass=org.eclipse.core.runtime.preferences.IScopeContext)(type=bundle))")
    private IScopeContext bundleScope;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    void setExecutorService(ExecutorService executor) {
        this.promiseFactory = new PromiseFactory((Executor)Objects.requireNonNull(executor));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addTemplateEngine(TemplateEngine engine, Map<String, Object> svcProps) {
        String name = (String)svcProps.get("name");
        this.engines.put(name, engine);
    }

    void removeTemplateEngine(TemplateEngine engine, Map<String, Object> svcProps) {
        String name = (String)svcProps.get("name");
        this.engines.remove(name);
    }

    @Activate
    void activate() {
        if (this.promiseFactory == null) {
            this.localExecutor = Executors.newCachedThreadPool();
            this.promiseFactory = new PromiseFactory((Executor)this.localExecutor);
        }
    }

    @Deactivate
    void dectivate() {
        if (this.localExecutor != null) {
            this.localExecutor.shutdown();
        }
    }

    public Promise<List<Template>> findTemplates(String templateType, Reporter reporter) {
        BundleLocator tmpLocator;
        RequirementImpl requirement = CapReqBuilder.createSimpleRequirement((String)NS_TEMPLATE, (String)templateType, null).buildSyntheticRequirement();
        List<Object> workspaceRepos = new ArrayList();
        try {
            ArrayList<RepositoryPlugin> wsRepo = new ArrayList<RepositoryPlugin>();
            for (Workspace workspace : this.workspaces) {
                workspaceRepos.addAll(workspace.getPlugins(Repository.class));
                wsRepo.addAll(workspace.getRepositories());
            }
            tmpLocator = new RepoPluginsBundleLocator(wsRepo);
        }
        catch (Exception e) {
            workspaceRepos = Collections.emptyList();
            tmpLocator = new DirectDownloadBundleLocator();
        }
        DirectDownloadBundleLocator locator = tmpLocator;
        ArrayList<Repository> repos = new ArrayList<Repository>(workspaceRepos.size() + 1);
        repos.addAll(workspaceRepos);
        this.addPreferenceConfiguredRepos(repos, reporter);
        Promise promise = ((Promise)repos.stream().map(arg_0 -> this.lambda$0(locator, reporter, (Requirement)requirement, arg_0)).collect(this.promiseFactory.toPromise())).map(ll -> ll.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return promise;
    }

    private void addPreferenceConfiguredRepos(List<Repository> repos, Reporter reporter) {
        List<String> list;
        IEclipsePreferences preferences = this.bundleScope.getNode("repoTemplateLoader");
        if (preferences.getBoolean("enableTemplateRepositories", false) && !(list = ReposPreference.TEMPLATE_REPOSITORIES_PARSER.apply(preferences.get("templateRepoUriList", ""))).isEmpty()) {
            try {
                OSGiRepository prefsRepo = this.loadRepo(list, reporter);
                repos.add((Repository)prefsRepo);
            }
            catch (Exception ex) {
                reporter.exception((Throwable)ex, "Error loading preference repository: %s", new Object[]{list});
            }
        }
    }

    private OSGiRepository loadRepo(List<String> uris, Reporter reporter) throws Exception {
        OSGiRepository repo = new OSGiRepository();
        repo.setReporter(reporter);
        Workspace workspace = this.workspaces.stream().findFirst().orElse(null);
        if (workspace != null) {
            repo.setRegistry((Registry)workspace);
        } else {
            Processor p = new Processor();
            p.addBasicPlugin((Object)new HttpClient());
            repo.setRegistry((Registry)p);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("locations", uris.stream().collect(Collectors.joining(",")));
        repo.setProperties(map);
        return repo;
    }

    private /* synthetic */ Promise lambda$0(BundleLocator bundleLocator, Reporter reporter, Requirement requirement, Repository repo) {
        return this.promiseFactory.submit(() -> {
            Map providerMap = repo.findProviders(Collections.singleton(requirement));
            return ((Collection)providerMap.get(requirement)).stream().map(cap -> {
                ResourceUtils.IdentityCapability idcap = ResourceUtils.getIdentityCapability((Resource)cap.getResource());
                Object id = idcap.getAttributes().get("osgi.identity");
                Object ver = idcap.getAttributes().get("version");
                try {
                    TemplateEngine engine;
                    String engineName = (String)cap.getAttributes().get("engine");
                    if (engineName == null) {
                        engineName = "stringtemplate";
                    }
                    if ((engine = (TemplateEngine)this.engines.get(engineName)) != null) {
                        return new CapabilityBasedTemplate((Capability)cap, bundleLocator, engine);
                    }
                    reporter.error("Error loading template from resource '%s' version %s: no Template Engine available matching '%s'", new Object[]{id, ver, engineName});
                }
                catch (Exception e) {
                    reporter.error("Error loading template from resource '%s' version %s: %s", new Object[]{id, ver, e.getMessage()});
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        });
    }
}

