/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.context;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.exception.ViewerValidationException;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ViewerAttributeBean
extends BaseAttributeBean {
    private static Set<String> allowedExtensionsForRptDocument;
    private static Set<String> disallowedExtensionsForRptDocument;
    private static final String KEY_RPTDOC_ALLOWED_EXTENSIONS = "reportdocument.allowed-extensions";
    private static final String KEY_RPTDOC_DISALLOWED_EXTENSIONS = "reportdocument.disallowed-extensions";
    private Map parametersAsString = null;
    private Collection parameterDefList = null;
    private Map displayTexts = null;
    private Map moduleOptions = null;
    private String requestType;
    private Map defaultValues;
    private List locParams;
    private Boolean reportRtl;

    static {
        String disallowedExtString;
        int n;
        allowedExtensionsForRptDocument = new HashSet<String>();
        disallowedExtensionsForRptDocument = new HashSet<String>();
        String allowedExtString = ParameterAccessor.getInitProp(KEY_RPTDOC_ALLOWED_EXTENSIONS);
        if (allowedExtString != null && allowedExtString.trim().length() > 0) {
            String[] allowedExtArray;
            String[] stringArray = allowedExtArray = allowedExtString.trim().split(",");
            n = allowedExtArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                allowedExtensionsForRptDocument.add(s.trim());
                ++n2;
            }
        }
        if ((disallowedExtString = ParameterAccessor.getInitProp(KEY_RPTDOC_DISALLOWED_EXTENSIONS)) != null && disallowedExtString.trim().length() > 0) {
            String[] disallowedExtArray;
            String[] stringArray = disallowedExtArray = disallowedExtString.trim().split(",");
            int n3 = disallowedExtArray.length;
            n = 0;
            while (n < n3) {
                String s = stringArray[n];
                disallowedExtensionsForRptDocument.add(s.trim());
                ++n;
            }
        }
    }

    public ViewerAttributeBean(HttpServletRequest request) {
        try {
            this.init(request);
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    @Override
    protected void __init(HttpServletRequest request) throws Exception {
        String servletPath = request.getServletPath();
        if (ParameterAccessor.isGetImageOperator(request) && ("/frameset".equalsIgnoreCase(servletPath) || "/output".equalsIgnoreCase(servletPath) || "/run".equalsIgnoreCase(servletPath) || "/preview".equalsIgnoreCase(servletPath))) {
            return;
        }
        this.category = "BIRT";
        this.masterPageContent = ParameterAccessor.isMasterPageContent(request);
        this.isDesigner = ParameterAccessor.isDesigner();
        this.bookmark = !ParameterAccessor.isBookmarkReportlet(request) ? ParameterAccessor.getBookmark(request) : null;
        this.isToc = ParameterAccessor.isToc(request);
        this.reportPage = ParameterAccessor.getPage(request);
        this.reportPageRange = ParameterAccessor.getPageRange(request);
        this.action = ParameterAccessor.getAction(request);
        boolean checkReportDocumentExtension = false;
        if ("/frameset".equalsIgnoreCase(servletPath) || "/output".equalsIgnoreCase(servletPath)) {
            this.reportDocumentName = ParameterAccessor.getReportDocument(request, null, true);
            checkReportDocumentExtension = true;
        } else if ("/download".equalsIgnoreCase(servletPath) || "/extract".equalsIgnoreCase(servletPath)) {
            this.reportDocumentName = ParameterAccessor.getReportDocument(request, null, true);
        } else {
            this.reportDocumentName = ParameterAccessor.getReportDocument(request, null, false);
            if ("/document".equalsIgnoreCase(servletPath) && this.reportDocumentName != null) {
                checkReportDocumentExtension = true;
            }
        }
        if (checkReportDocumentExtension) {
            ViewerAttributeBean.checkExtensionAllowedForRPTDocument(this.reportDocumentName);
        }
        this.reportDesignName = ParameterAccessor.getReport(request, null);
        this.emitterId = ParameterAccessor.getEmitterId(request);
        this.format = ParameterAccessor.getFormat(request);
        if ("print".equalsIgnoreCase(this.action)) {
            if (ParameterAccessor.isSupportedPrintOnServer) {
                this.format = "postscript";
                this.emitterId = null;
            } else {
                this.action = null;
            }
        }
        BirtResources.setLocale(ParameterAccessor.getLocale(request));
        this.requestType = request.getHeader("request-type");
        this.processReport(request);
        this.reportTitle = ParameterAccessor.getTitle(request);
        this.isShowTitle = ParameterAccessor.isShowTitle(request);
        this.isShowToolbar = ParameterAccessor.isShowToolbar(request);
        this.isShowNavigationbar = ParameterAccessor.isShowNavigationbar(request);
        this.moduleOptions = BirtUtility.getModuleOptions(request);
        this.reportDesignHandle = this.getDesignHandle(request);
        if (this.reportDesignHandle == null) {
            throw new ViewerException("birt.viewer.generalException.NO_REPORT_DESIGN");
        }
        this.reportRtl = null;
        this.__initParameters(request);
    }

    protected void __initParameters(HttpServletRequest request) throws Exception {
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        options.setOption("locale", this.locale);
        options.setOption("timeZone", this.timeZone);
        options.setOption("rtl", this.rtl);
        this.parameterDefList = this.getReportService().getParameterDefinitions(this.reportDesignHandle, options, false);
        if (this.isDesigner && ("/run".equalsIgnoreCase(request.getServletPath()) || "/parameter".equalsIgnoreCase(request.getServletPath()))) {
            this.parseConfigVars(request, this.parameterDefList);
        }
        this.parametersAsString = this.getParsedParametersAsString(this.parameterDefList, request, options);
        this.missingParameter = this.documentInUrl ? false : BirtUtility.validateParameters(this.parameterDefList, this.parametersAsString);
        this.isShowParameterPage = this.checkShowParameterPage(request);
        this.defaultValues = this.getDefaultValues(this.reportDesignHandle, this.parameterDefList, request, options);
        this.displayTexts = BirtUtility.getDisplayTexts(this.parameterDefList, this.displayTexts, request);
        this.locParams = BirtUtility.getLocParams(this.locParams, request);
        this.parameters = (HashMap)this.getParsedParameters(this.reportDesignHandle, this.parameterDefList, request, options);
        this.parametersAsString = this.getParsedParametersAsStringWithDefaultValue(this.parametersAsString, this.parameterDefList, request, options);
    }

    private boolean checkShowParameterPage(HttpServletRequest request) {
        if (!"soap".equalsIgnoreCase(this.requestType) && !"/download".equalsIgnoreCase(request.getServletPath())) {
            String showParameterPage = ParameterAccessor.getShowParameterPage(request);
            if ("false".equalsIgnoreCase(showParameterPage)) {
                return false;
            }
            if ("true".equalsIgnoreCase(showParameterPage)) {
                return true;
            }
        }
        return this.missingParameter;
    }

    protected void parseConfigVars(HttpServletRequest request, Collection parameterList) {
        block20: {
            String reportConfigName;
            this.configMap = new HashMap();
            if (this.displayTexts == null) {
                this.displayTexts = new HashMap();
            }
            if ((reportConfigName = ParameterAccessor.getConfigFileName(this.reportDesignName)) == null) {
                return;
            }
            File configFile = new File(reportConfigName);
            if (!configFile.exists() || !configFile.isFile()) {
                return;
            }
            SessionHandle sessionHandle = new DesignEngine(null).newSessionHandle(ULocale.US);
            ReportDesignHandle handle = null;
            try {
                handle = sessionHandle.openDesign(reportConfigName);
                if (handle == null) break block20;
                String displayTextParam = null;
                Iterator configVars = handle.configVariablesIterator();
                while (configVars != null && configVars.hasNext()) {
                    String expr;
                    ConfigVariableHandle configVar = (ConfigVariableHandle)configVars.next();
                    if (configVar == null) continue;
                    String varName = this.prepareConfigVarName(configVar.getName());
                    String varValue = configVar.getValue();
                    if (varName == null || varValue == null) continue;
                    String tempName = varName;
                    if (varName.toLowerCase().startsWith("__isnull")) {
                        tempName = varValue;
                    } else {
                        displayTextParam = ParameterAccessor.isDisplayText(varName);
                        if (displayTextParam != null) {
                            tempName = displayTextParam;
                        }
                    }
                    String paramName = this.getParameterName(tempName, parameterList);
                    ParameterDefinition parameter = BirtUtility.findParameterDefinition(parameterList, paramName);
                    if (parameter == null) continue;
                    String typeVarName = tempName + "_type_";
                    ConfigVariable typeVar = handle.findConfigVariable(typeVarName);
                    String dataType = ParameterDataTypeConverter.convertDataType(parameter.getDataType());
                    String cachedDateType = null;
                    if (typeVar != null) {
                        cachedDateType = typeVar.getValue();
                    }
                    if (cachedDateType == null || !cachedDateType.equalsIgnoreCase(dataType)) continue;
                    String exprVarName = tempName + "_expr_";
                    ConfigVariable exprVar = handle.findConfigVariable(exprVarName);
                    String cachedExpr = null;
                    if (exprVar != null) {
                        cachedExpr = exprVar.getValue();
                    }
                    if (cachedExpr == null) {
                        cachedExpr = "";
                    }
                    if ((expr = parameter.getValueExpr()) == null) {
                        expr = "";
                    }
                    if (!cachedExpr.equals(expr)) continue;
                    ArrayList<Object> values = null;
                    if (parameter.isMultiValue() && (values = (ArrayList<Object>)this.configMap.get(paramName)) == null) {
                        values = new ArrayList<Object>();
                        this.configMap.put(paramName, values);
                    }
                    if (varName.toLowerCase().startsWith("__isnull")) {
                        if (parameter.isMultiValue()) {
                            values.add(null);
                            continue;
                        }
                        this.configMap.put(paramName, null);
                        continue;
                    }
                    displayTextParam = ParameterAccessor.isDisplayText(varName);
                    if (displayTextParam != null) {
                        this.displayTexts.put(paramName, varValue);
                        continue;
                    }
                    Object varObj = null;
                    try {
                        varObj = DataUtil.convert(varValue, parameter.getDataType());
                    }
                    catch (Exception e) {
                        varObj = varValue;
                    }
                    if (parameter.isMultiValue()) {
                        values.add(varObj);
                        continue;
                    }
                    this.configMap.put(paramName, varObj);
                }
                handle.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String prepareConfigVarName(String name) {
        int index = name.lastIndexOf("_");
        return name.substring(0, index);
    }

    private String getParameterName(String configVarName, Collection parameterList) throws ReportServiceException {
        String paramName = null;
        if (parameterList != null) {
            for (ParameterDefinition parameter : parameterList) {
                Object curName = null;
                if (parameter != null && parameter.getName() != null) {
                    curName = parameter.getName() + "_" + parameter.getId();
                }
                if (curName == null || !((String)curName).equalsIgnoreCase(configVarName)) continue;
                paramName = parameter.getName();
                break;
            }
        }
        return paramName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IViewerReportDesignHandle getDesignHandle(HttpServletRequest request) throws Exception {
        BirtViewerReportDesignHandle design = null;
        IReportRunnable reportRunnable = null;
        IReportDocument reportDocumentInstance = null;
        boolean isDocumentExist = ParameterAccessor.isReportParameterExist(request, "__document");
        boolean isReportExist = ParameterAccessor.isReportParameterExist(request, "__report");
        if (isDocumentExist && !isReportExist) {
            boolean isValidDocument = ParameterAccessor.isValidFilePath(request, ParameterAccessor.getParameter(request, "__document"));
            if (!isValidDocument) throw new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{this.reportDocumentName});
            try {
                reportDocumentInstance = ReportEngineService.getInstance().openReportDocument(this.reportDesignName, this.reportDocumentName, this.moduleOptions);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (reportDocumentInstance == null) throw new ViewerException("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{this.reportDocumentName});
            reportRunnable = reportDocumentInstance.getReportRunnable();
        } else if (isReportExist) {
            if (isDocumentExist && !ParameterAccessor.isValidFilePath(request, ParameterAccessor.getParameter(request, "__document"))) {
                throw new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{this.reportDocumentName});
            }
            try {
                reportDocumentInstance = ReportEngineService.getInstance().openReportDocument(this.reportDesignName, this.reportDocumentName, this.moduleOptions);
            }
            catch (Exception isValidDocument) {
                // empty catch block
            }
            if (ParameterAccessor.isValidFilePath(request, ParameterAccessor.getParameter(request, "__report"))) {
                try {
                    reportRunnable = BirtUtility.getRunnableFromDesignFile(request, this.reportDesignName, this.moduleOptions);
                    if (reportRunnable == null) {
                        throw new ViewerException("birt.viewer.generalException.REPORT_FILE_ERROR", new String[]{new File(this.reportDesignName).getName()});
                    }
                }
                catch (EngineException e) {
                    this.exception = e;
                }
            }
        }
        if (reportDocumentInstance != null) {
            this.documentInUrl = true;
            this.parameterMap = reportDocumentInstance.getParameterValues();
            if (!reportDocumentInstance.isComplete() && isReportExist) {
                this.isDocumentProcessing = true;
            }
            reportDocumentInstance.close();
        }
        if (reportRunnable == null) return design;
        return new BirtViewerReportDesignHandle("rptRunnableObject", reportRunnable);
    }

    protected void processReport(HttpServletRequest request) throws Exception {
        if ("soap".equalsIgnoreCase(this.requestType) || "/download".equalsIgnoreCase(request.getServletPath()) || "/extract".equalsIgnoreCase(request.getServletPath()) || this.reportDocumentName == null) {
            return;
        }
        File reportDocFile = new File(this.reportDocumentName);
        long lastModifiedOfDesign = this.getLastModifiedOfDesign(request);
        if (lastModifiedOfDesign != -1L && reportDocFile != null && reportDocFile.exists() && reportDocFile.isFile() && (lastModifiedOfDesign > reportDocFile.lastModified() || ParameterAccessor.isOverwrite(request))) {
            reportDocFile.delete();
        }
    }

    protected long getLastModifiedOfDesign(HttpServletRequest request) {
        Object designFile = ParameterAccessor.getParameter(request, "__report");
        if (designFile == null) {
            return -1L;
        }
        File file = new File(this.reportDesignName);
        if (file != null && file.exists()) {
            if (file.isFile()) {
                return file.lastModified();
            }
        } else {
            try {
                URL url;
                if (!((String)designFile).startsWith("/")) {
                    designFile = "/" + (String)designFile;
                }
                if ((url = request.getSession().getServletContext().getResource((String)designFile)) != null) {
                    return url.openConnection().getLastModified();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Override
    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    protected Map<String, Object> getParsedParameters(IViewerReportDesignHandle design, Collection<ParameterDefinition> parameterList, HttpServletRequest request, InputOptions options) throws ReportServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (parameterList == null || this.parametersAsString == null) {
            return params;
        }
        for (ParameterDefinition parameter : parameterList) {
            if (parameter == null) continue;
            String paramName = parameter.getName();
            Object paramObj = this.parametersAsString.get(paramName);
            if (paramObj != null) {
                String format = ParameterAccessor.getFormat(request, paramName);
                if (format == null || format.length() <= 0) {
                    format = parameter.getPattern();
                }
                String dataType = ParameterDataTypeConverter.convertDataType(parameter.getDataType());
                boolean isLocale = this.locParams.contains(paramName);
                ArrayList<Object> paramList = null;
                if (paramObj instanceof List) {
                    paramList = (ArrayList<Object>)paramObj;
                } else {
                    paramList = new ArrayList<Object>();
                    paramList.add(paramObj);
                }
                int i = 0;
                while (i < paramList.size()) {
                    try {
                        Object paramValueObj = DataUtil.validate(paramName, dataType, format, (String)paramList.get(i), this.locale, this.timeZone, isLocale);
                        paramList.set(i, paramValueObj);
                    }
                    catch (ViewerValidationException e) {
                        if ("/preview".equalsIgnoreCase(request.getServletPath())) {
                            this.exception = e;
                            break;
                        }
                        paramList.set(i, paramList.get(i));
                    }
                    ++i;
                }
                if (paramObj instanceof List) {
                    List list = (List)paramObj;
                    if (list.size() == 0 || list.size() == 1 && list.get(0) == null) {
                        params.put(paramName, null);
                        continue;
                    }
                    params.put(paramName, paramList.toArray());
                    continue;
                }
                params.put(paramName, paramList.get(0));
                continue;
            }
            Object[] paramValueObj = null;
            if (!this.parametersAsString.containsKey(paramName)) {
                paramValueObj = (Object[])this.defaultValues.get(paramName);
            }
            if (parameter.isMultiValue() && paramValueObj != null && !(paramValueObj instanceof Object[])) {
                paramValueObj = new Object[]{paramValueObj};
            }
            params.put(paramName, paramValueObj);
        }
        return params;
    }

    protected Map getDefaultValues(IViewerReportDesignHandle design, Collection parameterList, HttpServletRequest request, InputOptions options) throws ReportServiceException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ParameterDefinition parameter : parameterList) {
            String paramName;
            if (parameter == null || (paramName = parameter.getName()) == null) continue;
            Object paramValue = this.getReportService().getParameterDefaultValue(design, paramName, options);
            map.put(paramName, paramValue);
        }
        return map;
    }

    protected Map getParsedParametersAsString(Collection parameterList, HttpServletRequest request, InputOptions options) throws ReportServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (parameterList == null) {
            return params;
        }
        for (ParameterDefinition parameter : parameterList) {
            Object values;
            String paramName;
            if (parameter == null || (paramName = parameter.getName()) == null) continue;
            String paramValue = null;
            if (ParameterAccessor.isReportParameterExist(request, paramName)) {
                if (parameter.isMultiValue()) {
                    List<String> values2 = ParameterAccessor.getReportParameters(request, paramName);
                    params.put(paramName, values2);
                    continue;
                }
                paramValue = ParameterAccessor.getReportParameter(request, paramName, null);
                params.put(paramName, paramValue);
                continue;
            }
            ArrayList<Object> valueObj = null;
            if (this.isDesigner && ("/run".equalsIgnoreCase(request.getServletPath()) || "/parameter".equalsIgnoreCase(request.getServletPath())) && this.configMap != null && this.configMap.containsKey(paramName)) {
                valueObj = (ArrayList<Object>)this.configMap.get(paramName);
            } else {
                if (this.parameterMap == null || !this.parameterMap.containsKey(paramName)) continue;
                valueObj = (ArrayList<Object>)this.parameterMap.get(paramName);
                if (valueObj instanceof Object[]) {
                    values = (Object[])valueObj;
                    ArrayList<Object> list = new ArrayList<Object>(((Object[])values).length);
                    int i = 0;
                    while (i < ((Object)values).length) {
                        list.add(values[i]);
                        ++i;
                    }
                    valueObj = list;
                }
            }
            if (valueObj instanceof List) {
                values = valueObj;
                int i = 0;
                while (i < values.size()) {
                    paramValue = DataUtil.getDisplayValue(values.get(i), this.timeZone);
                    values.set(i, paramValue);
                    ++i;
                }
                params.put(paramName, values);
                continue;
            }
            paramValue = DataUtil.getDisplayValue(valueObj, this.timeZone);
            params.put(paramName, paramValue);
        }
        return params;
    }

    protected Map getParsedParametersAsStringWithDefaultValue(Map aParsedParameters, Collection parameterList, HttpServletRequest request, InputOptions options) throws ReportServiceException {
        HashMap<String, Object> parsedParameters = aParsedParameters;
        if (parsedParameters == null) {
            parsedParameters = new HashMap<String, Object>();
        }
        for (ParameterDefinition parameter : parameterList) {
            String paramName;
            if (parameter == null || (paramName = parameter.getName()) == null || parsedParameters.containsKey(paramName)) continue;
            Object defVals = this.defaultValues.get(paramName);
            if (parameter.isMultiValue()) {
                String paramValue;
                if (defVals == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                if (defVals.getClass().isArray()) {
                    int i = 0;
                    while (i < Array.getLength(defVals)) {
                        paramValue = DataUtil.getDisplayValue(Array.get(defVals, i), this.timeZone);
                        values.add(paramValue);
                        ++i;
                    }
                } else {
                    paramValue = DataUtil.getDisplayValue(defVals, this.timeZone);
                    values.add(paramValue);
                }
                parsedParameters.put(paramName, values);
                continue;
            }
            String paramValue = DataUtil.getDisplayValue(defVals, this.timeZone);
            if (paramValue == null && parameter.getControlType() == 1 && !parameter.isRequired() && parameter.allowBlank() && parameter.getGroup() != null && parameter.getGroup().cascade()) {
                paramValue = "";
            }
            parsedParameters.put(paramName, paramValue);
        }
        return parsedParameters;
    }

    public ParameterHandle findParameter(String paramName) throws ReportServiceException {
        return BirtUtility.findParameter(this.reportDesignHandle, paramName);
    }

    public ParameterDefinition findParameterDefinition(String paramName) {
        return BirtUtility.findParameterDefinition(this.parameterDefList, paramName);
    }

    @Override
    public String getReportTitle() throws ReportServiceException {
        String title = BirtUtility.getTitleFromDesign(this.reportDesignHandle);
        if (title == null || title.trim().length() <= 0) {
            title = this.reportTitle;
        }
        return title;
    }

    public Map getParametersAsString() {
        return this.parametersAsString;
    }

    public Collection getParameterDefList() {
        return this.parameterDefList;
    }

    public Map getDisplayTexts() {
        return this.displayTexts;
    }

    public Map getModuleOptions() {
        return this.moduleOptions;
    }

    public Map getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isReportRtl() {
        if (this.reportRtl == null) {
            IReportRunnable r;
            try {
                r = (IReportRunnable)this.reportDesignHandle.getDesignObject();
            }
            catch (ReportServiceException e) {
                return false;
            }
            if (r.getDesignHandle() instanceof ReportDesignHandle) {
                ReportDesignHandle handle = (ReportDesignHandle)r.getDesignHandle();
                this.reportRtl = "rtl".equalsIgnoreCase(handle.getBidiOrientation());
            }
        }
        return this.reportRtl != null ? this.reportRtl : false;
    }

    protected static void checkExtensionAllowedForRPTDocument(String rptDocumentName) throws ViewerException {
        String report = rptDocumentName;
        try {
            report = new File(rptDocumentName).getName();
        }
        catch (Exception e) {
            throw new ViewerException(BirtResources.getMessage("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{report}));
        }
        if (report == null || report.trim().isEmpty() || report.trim().endsWith(".")) {
            throw new ViewerException(BirtResources.getMessage("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{report}));
        }
        int extIndex = report.lastIndexOf(".");
        String extension = null;
        boolean validExtension = true;
        if (extIndex > -1 && extIndex + 1 < report.length()) {
            extension = report.substring(extIndex + 1);
            if (!extension.matches("^[A-Za-z0-9]+$")) {
                validExtension = false;
            }
            if (!disallowedExtensionsForRptDocument.isEmpty() && disallowedExtensionsForRptDocument.contains(extension)) {
                validExtension = false;
            }
            if (!allowedExtensionsForRptDocument.isEmpty() && !allowedExtensionsForRptDocument.contains(extension)) {
                validExtension = false;
            }
            if (!validExtension) {
                throw new ViewerException(BirtResources.getMessage("birt.viewer.error.invalidextfordocumentparam", new String[]{extension}));
            }
        }
    }
}

