/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class BooleanOption
extends TemplateOption {
    private Button button;

    public BooleanOption(BaseOptionTemplateSection section, String name, String label) {
        super(section, name, label);
    }

    public boolean isSelected() {
        return this.getValue() != null && this.getValue().equals(Boolean.TRUE);
    }

    public void setSelected(boolean selected) {
        this.setValue(selected ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (this.button != null) {
            this.button.setSelection(this.isSelected());
        }
    }

    @Override
    public void createControl(Composite parent, int span) {
        this.button = new Button(parent, 32);
        this.button.setText(this.getLabel());
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        this.button.setLayoutData((Object)gd);
        this.button.setSelection(this.isSelected());
        this.button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            BooleanOption.super.setValue(this.button.getSelection() ? Boolean.TRUE : Boolean.FALSE);
            this.getSection().validateOptions(this);
        }));
        this.button.setEnabled(this.isEnabled());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
    }
}

