/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.ui.extension.AggregationCellViewAdapter;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class AggregationCellTextViewProvider
extends AggregationCellViewAdapter {
    @Override
    public String getViewName() {
        return "Text";
    }

    @Override
    public boolean matchView(AggregationCellHandle cell) {
        List contents = cell.getContents();
        if (contents != null && contents.size() == 1) {
            Object content = contents.get(0);
            return content instanceof DataItemHandle;
        }
        return false;
    }

    @Override
    public void switchView(SwitchCellInfo info) {
        this.switchView(info.getAggregationCell());
    }

    @Override
    public void switchView(AggregationCellHandle cell) {
        if (cell == null || !this.canSwitch(cell)) {
            return;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans("Switch to Text View");
        try {
            cell.setSpanOverOnColumn(null);
            cell.setSpanOverOnRow(null);
            List contents = cell.getContents();
            int i = 0;
            while (i < contents.size()) {
                ((DesignElementHandle)contents.get(i)).drop();
                ++i;
            }
            this.createTextView(cell);
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private void createTextView(AggregationCellHandle cell) throws SemanticException {
        CrosstabReportItemHandle crosstab = cell.getCrosstab();
        MeasureViewHandle measureView = (MeasureViewHandle)cell.getContainer();
        LevelHandle rowLevelHandle = cell.getAggregationOnRow();
        LevelHandle colLevelHandle = cell.getAggregationOnColumn();
        String rowLevel = rowLevelHandle == null ? null : rowLevelHandle.getFullName();
        String colLevel = colLevelHandle == null ? null : colLevelHandle.getFullName();
        String rowDimension = null;
        String colDimension = null;
        if (rowLevelHandle != null && rowLevelHandle.getContainer() != null && rowLevelHandle.getContainer().getContainer() != null) {
            rowDimension = rowLevelHandle.getContainer().getContainer().getFullName();
        }
        if (colLevelHandle != null && colLevelHandle.getContainer() != null && colLevelHandle.getContainer().getContainer() != null) {
            colDimension = colLevelHandle.getContainer().getContainer().getFullName();
        }
        CrosstabUtil.addDataItem((CrosstabReportItemHandle)crosstab, (AggregationCellHandle)cell, (MeasureViewHandle)measureView, null, rowDimension, (String)rowLevel, colDimension, (String)colLevel);
    }

    @Override
    public void restoreView(AggregationCellHandle cell) {
    }

    @Override
    @Deprecated
    public boolean canSwitch(AggregationCellHandle cell) {
        return true;
    }

    @Override
    public boolean canSwitch(SwitchCellInfo info) {
        return true;
    }

    @Override
    public String getViewDisplayName() {
        return Messages.getString("AggregationCellTextViewProvider.displayName");
    }
}

