/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageBlockContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageInlineContainer;
import org.w3c.dom.css.CSSValue;

public abstract class InlineStackingArea
extends ContainerArea {
    public InlineStackingArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        this.isInlineStacking = true;
    }

    public InlineStackingArea(InlineStackingArea area) {
        super(area);
    }

    public abstract void endLine(boolean var1) throws BirtException;

    public abstract boolean isEmptyLine();

    public abstract int getMaxLineWidth();

    @Override
    public void update(AbstractArea area) throws BirtException {
        this.currentIP += area.getAllocatedWidth();
    }

    @Override
    public void add(AbstractArea area) {
        this.children.add(area);
        area.setAllocatedPosition(this.currentIP + this.getOffsetX(), this.currentBP + this.getOffsetY());
    }

    @Override
    public int getBaseLine() {
        if (this.baseLine == 0 && this.children.size() > 0) {
            for (AbstractArea child : this.children) {
                this.baseLine = Math.max(this.baseLine, child.getY() + child.getBaseLine());
            }
        }
        return this.baseLine;
    }

    @Override
    public void updateChildrenPosition() {
        this.first = false;
        this.currentIP = 0;
        if (this.children.size() > 0) {
            Iterator iter = this.children.iterator();
            int x = this.getOffsetX();
            int w = 0;
            while (iter.hasNext()) {
                ContainerArea area = (ContainerArea)iter.next();
                area.setAllocatedPosition(x, area.getY());
                int aw = area.getAllocatedWidth();
                x += aw;
                w += aw;
                if (!area.finished) continue;
                this.currentIP += aw;
            }
            this.setContentWidth(w);
        } else {
            this.setContentWidth(0);
        }
    }

    protected void verticalAlign() {
        Iterator<IArea> iter = this.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            CSSValue vAlign = child.getVerticalAlign();
            if (CSSValueConstants.TOP_VALUE.equals(vAlign)) continue;
            int spacing = this.getContentHeight() - child.getAllocatedHeight();
            if (vAlign == null && !this.isImageContainer(child) || CSSValueConstants.BASELINE_VALUE.equals(vAlign)) {
                int lineHeight = this.parent.getLineHeight();
                if (lineHeight > 0) {
                    child.setPosition(child.getX(), this.getBaseLine() - child.getBaseLine() + spacing / 2);
                    continue;
                }
                child.setPosition(child.getX(), this.getBaseLine() - child.getBaseLine());
                continue;
            }
            if (CSSValueConstants.BOTTOM_VALUE.equals(vAlign)) {
                child.setPosition(child.getX(), child.getY() + spacing);
                continue;
            }
            if (!CSSValueConstants.MIDDLE_VALUE.equals(vAlign)) continue;
            child.setPosition(child.getX(), child.getY() + spacing / 2);
        }
    }

    private boolean isImageContainer(AbstractArea area) {
        return area instanceof ImageInlineContainer || area instanceof ImageBlockContainer;
    }

    public abstract void setTextIndent(ITextContent var1);
}

