/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;

public class PPTUtil {
    private static final Logger logger = Logger.getLogger(PPTUtil.class.getName());

    public static HyperlinkDef getHyperlink(IArea area, IEmitterServices services, IReportRunnable reportRunnable, IReportContext context) {
        return PPTUtil.getHyperlink(area, services, reportRunnable, context, false);
    }

    public static HyperlinkDef getHyperlink(IArea area, IEmitterServices services, IReportRunnable reportRunnable, IReportContext context, boolean linkImageToBookmark) {
        IHyperlinkAction hyperlinkAction = area.getAction();
        if (hyperlinkAction != null) {
            try {
                if (hyperlinkAction.getType() != 2 || linkImageToBookmark) {
                    String link = hyperlinkAction.getHyperlink();
                    String tooltip = hyperlinkAction.getTooltip();
                    Object handler = services.getOption("actionHandler");
                    if (handler instanceof IHTMLActionHandler) {
                        if (linkImageToBookmark && hyperlinkAction.getBookmark() != null) {
                            link = hyperlinkAction.getBookmark();
                        } else {
                            IHTMLActionHandler actionHandler = (IHTMLActionHandler)handler;
                            String systemId = reportRunnable == null ? null : reportRunnable.getReportName();
                            Action action = new Action(systemId, hyperlinkAction);
                            link = actionHandler.getURL((IAction)action, context);
                        }
                    }
                    IStyle computedStyle = null;
                    boolean hasHyperlinkDecoration = true;
                    if (area instanceof ContainerArea && (computedStyle = ((ContainerArea)area).getContent().getComputedStyle()) != null) {
                        hasHyperlinkDecoration = computedStyle.getProperty(40) != CSSValueConstants.UNDECORATED;
                    }
                    return new HyperlinkDef(link, tooltip, hasHyperlinkDecoration, hyperlinkAction.getType());
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    public static class HyperlinkDef {
        private String link;
        private String tooltip;
        private boolean hasHyperlinkDecoration = true;
        private int hyperlinkActionType = -1;

        public HyperlinkDef(String link, String tooltip, boolean hasHyperlinkDecoration) {
            this(link, tooltip, hasHyperlinkDecoration, -1);
        }

        public HyperlinkDef(String link, String tooltip, boolean hasHyperlinkDecoration, int hyperlinkActionType) {
            this.link = link;
            this.tooltip = tooltip;
            this.hasHyperlinkDecoration = hasHyperlinkDecoration;
            this.hyperlinkActionType = hyperlinkActionType;
        }

        public String getLink() {
            return this.link;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public boolean isHasHyperlinkDecoration() {
            return this.hasHyperlinkDecoration;
        }

        public int getHyperlinkActionType() {
            return this.hyperlinkActionType;
        }
    }
}

