/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.controller;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.controller.IController;
import org.eclipse.birt.report.designer.ui.preview.editors.AbstractViewer;
import org.eclipse.birt.report.designer.ui.preview.editors.SWTAbstractViewer;
import org.eclipse.birt.report.designer.ui.preview.extension.IViewer;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

public class StaticHTMLController
implements IController {
    private final Display display = Display.getCurrent();
    private final List buttons = new ArrayList();
    private Composite pane = null;
    private ProgressBar progressBar = null;
    private IViewer viewer = null;
    private IEngineTask engineTask;
    private String reportFile;

    @Override
    public void setViewer(IViewer viewer) {
        this.viewer = viewer;
        if (!(viewer instanceof AbstractViewer)) {
            return;
        }
        Composite viewerUI = (Composite)((SWTAbstractViewer)viewer).getUI();
        if (viewerUI == null) {
            return;
        }
        this.pane = new Composite(viewerUI, 0);
        this.pane.setLayoutData((Object)new GridData(256));
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 5;
        this.pane.setLayout((Layout)rowLayout);
        for (ButtonInfo buttonInfo : this.buttons) {
            Button button = new Button(this.pane, 8);
            button.setText(buttonInfo.text);
            button.setToolTipText(buttonInfo.toolTip);
            if (buttonInfo.selectionListener == null) continue;
            button.addSelectionListener(buttonInfo.selectionListener);
        }
        GridData gd = new GridData(3, 2, false, false);
        gd.heightHint = 10;
        gd.widthHint = 100;
        this.progressBar = new ProgressBar(viewerUI, 2);
        this.progressBar.setLayoutData((Object)gd);
        this.setBusy(true);
    }

    @Override
    public Widget getPane() {
        if (this.viewer != null) {
            return this.pane;
        }
        return null;
    }

    @Override
    public void setBusy(final boolean b) {
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StaticHTMLController.this.progressBar != null && !StaticHTMLController.this.progressBar.isDisposed()) {
                        StaticHTMLController.this.progressBar.setVisible(b);
                    }
                }
            });
        }
    }

    @Override
    public void addButton(String text, String toolTip, SelectionListener listener) {
        this.buttons.add(new ButtonInfo(text, toolTip, listener));
    }

    public IEngineTask getEngineTask() {
        return this.engineTask;
    }

    public void setEngineTask(IEngineTask engindTask) {
        this.engineTask = engindTask;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    private static class ButtonInfo {
        String text = "";
        String toolTip = "";
        SelectionListener selectionListener = null;

        private ButtonInfo(String text, String toolTip, SelectionListener selectionListener) {
            this.text = text;
            this.toolTip = toolTip;
            this.selectionListener = selectionListener;
        }
    }
}

