/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.regre;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Scriptable;
import testutil.ConfigText;

public class FeatureTest
extends APITestCase {
    private IBaseDataSetDesign datasetCstm;
    private ScriptExpression[] expressionsCstm;
    private String[] exprNameCstm;
    private QueryDefinition queryDefnCstm;
    private IBaseDataSetDesign datasetCall;
    private ScriptExpression[] expressionsCall;
    private String[] exprNameCall;
    private QueryDefinition queryDefnCall;
    private String callsTableName;

    @Before
    public void featureSetUp() throws Exception {
        this.prepareDataSet(new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestDataCalls.TableName"), ConfigText.getString("Api.TestDataCalls.TableSQL"), ConfigText.getString("Api.TestDataCalls.TestDataFileName")));
        this.callsTableName = ConfigText.getString("Api.TestDataCalls.TableName");
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestDataCustomer.TableName"), ConfigText.getString("Api.TestDataCustomer.TableSQL"), ConfigText.getString("Api.TestDataCustomer.TestDataFileName"));
    }

    @Test
    public void testAllFeatures() throws Exception {
        ArrayList<ParameterDefinition> inputParamDefns = new ArrayList<ParameterDefinition>();
        ArrayList<InputParameterBinding> inputParamBindings = new ArrayList<InputParameterBinding>();
        this.datasetCstm = this.dataSet;
        this.queryDefnCstm = this.createCustomerQueryDefn();
        this.datasetCall = this.newDataSet("data set calls", " SELECT * FROM " + this.callsTableName + " WHERE CustomerID = ?");
        this.queryDefnCall = this.createCallQueryDefn();
        this.addComputedColumnsToDataSetCall();
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 2, true, false);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("0");
        inputParamDefns.add(inputParamDefn);
        InputParameterBinding inputParamBinding = new InputParameterBinding(1, (IBaseExpression)this.expressionsCstm[4]);
        inputParamBindings.add(inputParamBinding);
        this.run(inputParamDefns, inputParamBindings);
    }

    private QueryDefinition createCustomerQueryDefn() {
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition(), new GroupDefinition()};
        groupDefn[0].setKeyExpression("row.CUSTOMERID");
        groupDefn[1].setKeyExpression("row.NAME");
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("CUSTOMERID");
        sortDefn[0].setSortDirection(1);
        this.expressionsCstm = new ScriptExpression[]{new ScriptExpression("dataSetRow.CUSTOMERID", 0), new ScriptExpression("dataSetRow.NAME", 0), new ScriptExpression("dataSetRow.ADDRESS", 0), new ScriptExpression("dataSetRow.CURRENTBALANCE", 0), new ScriptExpression("rows[0].CUSTOMERID", 0)};
        this.exprNameCstm = new String[]{"CUSTOMERID", "NAME", "ADDRESS", "CURRENTBALANCE", "ROWS0CUSTID"};
        return this.createQueryDefnUsingGivenArgs(this.datasetCstm, this.exprNameCstm, this.expressionsCstm, groupDefn, sortDefn, null);
    }

    private QueryDefinition createCallQueryDefn() {
        this.expressionsCall = new ScriptExpression[]{new ScriptExpression("dataSetRow.CUSTOMERID", 0), new ScriptExpression("dataSetRow.CALLTIME", 0), new ScriptExpression("dataSetRow.TONUMBER", 0), new ScriptExpression("dataSetRow.DURATION", 0), new ScriptExpression("dataSetRow.Charge2", 0), new ScriptExpression("Total.sum(dataSetRow.Charge2)", 0)};
        this.exprNameCall = new String[]{"CUSTOMERID", "CALLTIME", "TONUMBER", "DURATION", "Charge2", "TOTALSUMCHARGE"};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("dataSetRow.DURATION", 6, "0"))};
        return this.createQueryDefnUsingGivenArgs(this.datasetCall, this.exprNameCall, this.expressionsCall, null, null, (IFilterDefinition[])filters);
    }

    private QueryDefinition createQueryDefnUsingGivenArgs(IBaseDataSetDesign dataset, String[] exprNames, ScriptExpression[] expressions, GroupDefinition[] groupDefn, SortDefinition[] sortDefn, IFilterDefinition[] filters) {
        int i;
        QueryDefinition queryDefn = this.newReportQuery(dataset);
        if (groupDefn != null) {
            i = 0;
            while (i < groupDefn.length) {
                queryDefn.addGroup((IGroupDefinition)groupDefn[i]);
                ++i;
            }
        }
        if (sortDefn != null) {
            i = 0;
            while (i < sortDefn.length) {
                queryDefn.addSort(sortDefn[i]);
                ++i;
            }
        }
        if (expressions != null) {
            i = 0;
            while (i < expressions.length) {
                queryDefn.addResultSetExpression(exprNames[i], (IBaseExpression)expressions[i]);
                ++i;
            }
        }
        if (filters != null) {
            i = 0;
            while (i < filters.length) {
                queryDefn.addFilter(filters[i]);
                ++i;
            }
        }
        return queryDefn;
    }

    private void addComputedColumnsToDataSetCall() {
        ComputedColumn[] computedColumns = new ComputedColumn[]{new ComputedColumn("Charge2", "row.DURATION*0.05", 3)};
        int i = 0;
        while (i < computedColumns.length) {
            ((BaseDataSetDesign)this.datasetCall).addComputedColumn((IComputedColumn)computedColumns[i]);
            ++i;
        }
    }

    private void run(Collection inputParamDefns, Collection inputParamBindings) throws Exception {
        for (ParameterDefinition inputParamDefn : inputParamDefns) {
            ((OdaDataSetDesign)this.datasetCall).addParameter((IParameterDefinition)inputParamDefn);
        }
        for (InputParameterBinding inputParamBinding : inputParamBindings) {
            this.queryDefnCall.addInputParamBinding(inputParamBinding);
        }
        IPreparedQuery preparedQueryCstm = this.dataEngine.prepare((IQueryDefinition)this.queryDefnCstm);
        IPreparedQuery preparedQueryCall = this.dataEngine.prepare((IQueryDefinition)this.queryDefnCall);
        IQueryResults queryResultsCstm = preparedQueryCstm.execute(this.jsScope);
        IResultIterator resultItCustomer = queryResultsCstm.getResultIterator();
        this.testPrintln("*****A new Report Start!*****");
        while (resultItCustomer.next()) {
            this.testPrint("Customer Name:");
            this.testPrint(this.evalAsString(this.exprNameCstm[1], resultItCustomer));
            this.testPrint("  Address:");
            this.testPrint(this.evalAsString(this.exprNameCstm[2], resultItCustomer));
            this.testPrintln("");
            this.testPrint("Starting Balance: $");
            this.testPrint(this.evalAsString(this.exprNameCstm[3], resultItCustomer));
            this.testPrintln("");
            Scriptable newScope = this.jsContext.newObject(this.jsScope);
            newScope.setParentScope(this.jsScope);
            IQueryResults queryResultsCalls = preparedQueryCall.execute(queryResultsCstm, newScope);
            IResultIterator resultItCalls = queryResultsCalls.getResultIterator();
            while (resultItCalls.next()) {
                int i = 1;
                while (i < this.expressionsCall.length) {
                    this.testPrint(this.evalAsString(this.exprNameCall[i], resultItCalls));
                    this.testPrint(" ");
                    ++i;
                }
                this.testPrintln("");
            }
            this.testPrintln("");
        }
        this.checkOutputFile();
    }
}

