/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;

public class DEUtilTest
extends BaseTestCase {
    private static final String[][] TEST_DATE_STRING = new String[][]{{"yyyy/MM/dd hh:mm:ss.SSS a", "1996-02-28T23:25:27.573", "1996/02/28 11:25:27.573 PM", "1996-02-28T23:25:27.573"}, {"MM/dd/yyyy hh:mm:ss a", "1996-02-28T23:25:27.000", "02/28/1996 11:25:27 PM", "1996-02-28T23:25:27"}, {"yy-MM-dd", "1996-02-28T00:00:00.000", "96-02-28", "1996-02-28"}, {"yyyy-MM-dd HH:mm", "1996-02-28T23:25:00.000", "1996-02-28 23:25", "1996-02-28T23:25"}};

    public DEUtilTest(String name) {
        super(name);
    }

    public void testGetElementSupportListDesignElementHandleint() {
        ArrayList<IElementDefn> expected = new ArrayList<IElementDefn>();
        IMetaDataDictionary dictionary = DEUtil.getMetaDataDictionary();
        expected.add(dictionary.getElement("Label"));
        expected.add(dictionary.getElement("Data"));
        expected.add(dictionary.getElement("Table"));
        expected.add(dictionary.getElement("List"));
        expected.add(dictionary.getElement("Grid"));
        expected.add(dictionary.getElement("Text"));
        expected.add(dictionary.getElement("Image"));
        List result = DEUtil.getElementSupportList((DesignElementHandle)this.getReportDesign().handle(), (int)6);
        DEUtilTest.assertTrue((boolean)result.containsAll(expected));
    }

    public void testEscape() {
        String testString = "abcd\\c\"";
        DEUtilTest.assertEquals((String)"abcd\\\\c\\\"", (String)DEUtil.escape((String)testString));
    }

    public void testConvertToDate() throws ParseException {
        int i = 0;
        while (i < TEST_DATE_STRING.length) {
            String pattern = TEST_DATE_STRING[i][0];
            String xmlString = TEST_DATE_STRING[i][1];
            String original = TEST_DATE_STRING[i][2];
            DateFormatter formatter = new DateFormatter(pattern, ULocale.US);
            DEUtilTest.assertEquals((String)DEUtil.convertToXMLString((Date)formatter.parse(original)), (String)xmlString);
            ++i;
        }
    }

    public void testConvertToXMLString() throws ParseException {
        int i = 0;
        while (i < TEST_DATE_STRING.length) {
            String pattern = TEST_DATE_STRING[i][0];
            String original = TEST_DATE_STRING[i][2];
            String xmlString = TEST_DATE_STRING[i][3];
            DateFormatter formatter = new DateFormatter(pattern, ULocale.US);
            DEUtilTest.assertEquals((String)formatter.format(DEUtil.convertToDate((String)xmlString)), (String)original);
            ++i;
        }
    }
}

