/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.command.ViewsContentEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class MultiViewHandleTest
extends BaseTestCase {
    public void testAPIs() throws Exception {
        this.createDesign();
        TableHandle table1 = this.designHandle.getElementFactory().newTableItem("table1");
        this.designHandle.getBody().add((DesignElementHandle)table1);
        table1.setName("HostTable");
        MyListener tmpListener = new MyListener();
        table1.addListener((Listener)tmpListener);
        ExtendedItemHandle box1 = this.designHandle.getElementFactory().newExtendedItem("box1", "TestingBox");
        table1.addView((DesignElementHandle)box1);
        MultiViewHandleTest.assertTrue((boolean)tmpListener.isChanged());
        tmpListener.resetFlag();
        table1.setCurrentView((DesignElementHandle)box1);
        MultiViewHandleTest.assertTrue((boolean)tmpListener.isChanged());
        tmpListener.resetFlag();
        MultiViewHandleTest.assertTrue((box1.getContainer().getContainer() == table1 ? 1 : 0) != 0);
        MultiViewHandleTest.assertTrue((box1.getHostViewHandle() == table1 ? 1 : 0) != 0);
        MultiViewHandleTest.assertNull((Object)table1.getHostViewHandle());
        List views = table1.getViews();
        MultiViewHandleTest.assertEquals((int)1, (int)views.size());
        MultiViewHandleTest.assertTrue((box1 == views.get(0) ? 1 : 0) != 0);
        MultiViewHandleTest.assertTrue((box1 == table1.getCurrentView() ? 1 : 0) != 0);
        MultiViewHandleTest.assertEquals((Object)table1, (Object)box1.getViewHost());
        MultiViewHandleTest.assertNull((Object)table1.getViewHost());
        table1.dropView((DesignElementHandle)box1);
        MultiViewHandleTest.assertTrue((boolean)tmpListener.isChanged());
        tmpListener.resetFlag();
        MultiViewHandleTest.assertNull((Object)table1.getCurrentView());
        views = table1.getViews();
        MultiViewHandleTest.assertEquals((int)0, (int)views.size());
        MultiViewHandleTest.assertNull((Object)box1.getViewHost());
        table1.setCurrentView((DesignElementHandle)box1);
        MultiViewHandleTest.assertTrue((boolean)tmpListener.isChanged());
        tmpListener.resetFlag();
        MultiViewHandleTest.assertTrue((box1 == table1.getCurrentView() ? 1 : 0) != 0);
        table1.setCurrentView(null);
        views = table1.getViews();
        MultiViewHandleTest.assertEquals((int)1, (int)views.size());
        MultiViewHandleTest.assertNull((Object)table1.getCurrentView());
    }

    public void testHostRelatedPropertySearch() throws Exception {
        this.openDesign("MultiViewHandleTest.xml");
        ExtendedItemHandle box1 = (ExtendedItemHandle)this.designHandle.findElement("box1");
        MultiViewHandleTest.assertEquals((String)"\"a\"", (String)box1.getBookmark());
        MultiViewHandleTest.assertEquals((String)"1+1", (String)box1.getTOC().getExpression());
        Iterator rules = box1.visibilityRulesIterator();
        MultiViewHandleTest.assertTrue((boolean)rules.hasNext());
        PropertyHandle propHandle = box1.getPropertyHandle("visibility");
        MultiViewHandleTest.assertTrue((boolean)propHandle.isReadOnly());
        MultiViewHandleTest.assertEquals((String)"always", (String)box1.getStringProperty("pageBreakBefore"));
        MultiViewHandleTest.assertEquals((String)"always", (String)box1.getStringProperty("pageBreakAfter"));
        MultiViewHandleTest.assertEquals((String)"auto", (String)box1.getStringProperty("pageBreakInside"));
        MultiViewHandleTest.assertEquals((String)"Simple MasterPage", (String)box1.getStringProperty("masterPage"));
    }

    private static class MyListener
    implements Listener {
        private boolean propertyChanged = false;

        private MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev instanceof PropertyEvent && ((PropertyEvent)ev).getPropertyName() == "multiViews") {
                this.propertyChanged = true;
            }
            if (ev instanceof ViewsContentEvent) {
                this.propertyChanged = true;
            }
        }

        boolean isChanged() {
            return this.propertyChanged;
        }

        void resetFlag() {
            this.propertyChanged = false;
        }
    }
}

