/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class ReferenceValueUtilTest
extends BaseTestCase {
    public void testMultiExtendedElements() throws Exception {
        this.openDesign("DesignWithOneCompositeLibrary.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("table3");
        ReferenceValue refValue = (ReferenceValue)table.getElement().getProperty((Module)this.design, "dataSet");
        ReferenceValueUtilTest.assertEquals((String)"Lib1.dataSet1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)this.design));
        LibraryHandle compsiteLib = this.designHandle.getLibrary("CompositeLib");
        ReferenceValueUtilTest.assertEquals((String)"Lib1.dataSet1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)compsiteLib.getModule()));
        LibraryHandle lib1 = compsiteLib.getLibrary("Lib1");
        ReferenceValueUtilTest.assertEquals((String)"dataSet1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)lib1.getModule()));
        table = (TableHandle)this.designHandle.findElement("table4");
        refValue = (ReferenceValue)table.getElement().getProperty((Module)this.design, "dataSet");
        ReferenceValueUtilTest.assertEquals((String)"CompositeLib.dataSet1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)this.design));
        ReferenceValueUtilTest.assertEquals((String)"dataSet1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)compsiteLib.getModule()));
        ReferenceValueUtilTest.assertEquals((String)"CompositeLib.dataSet1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)lib1.getModule()));
        table = (TableHandle)this.designHandle.findElement("table5");
        refValue = (ReferenceValue)table.getElement().getProperty((Module)this.design, "dataSet");
        ReferenceValueUtilTest.assertEquals((String)"Lib1.noExistedDataSet", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)this.design));
        ReferenceValueUtilTest.assertEquals((String)"Lib1.noExistedDataSet", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)compsiteLib.getModule()));
        ReferenceValueUtilTest.assertEquals((String)"noExistedDataSet", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)lib1.getModule()));
    }

    public void testMultiExtendedImages() throws Exception {
        this.openDesign("LibraryStructureTest_4.xml");
        ImageHandle image = (ImageHandle)this.designHandle.findElement("image1");
        ReferenceValue refValue = (ReferenceValue)image.getElement().getProperty((Module)this.design, "imageName");
        ReferenceValueUtilTest.assertEquals((String)"Lib1.image1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)this.design));
        LibraryHandle compsiteLib = this.designHandle.getLibrary("CompositeLib");
        ReferenceValueUtilTest.assertEquals((String)"Lib1.image1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)compsiteLib.getModule()));
        LibraryHandle lib1 = compsiteLib.getLibrary("Lib1");
        ReferenceValueUtilTest.assertEquals((String)"image1", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)lib1.getModule()));
        image = (ImageHandle)this.designHandle.findElement("image2");
        refValue = (ReferenceValue)image.getElement().getProperty((Module)this.design, "imageName");
        ReferenceValueUtilTest.assertEquals((String)"Lib1.noExistedImage", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)this.design));
        ReferenceValueUtilTest.assertEquals((String)"Lib1.noExistedImage", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)compsiteLib.getModule()));
        ReferenceValueUtilTest.assertEquals((String)"noExistedImage", (String)ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)refValue, (Module)lib1.getModule()));
    }
}

