/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.impl.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.impl.internal.InnermostNextable;
import org.eclipse.birt.data.oda.pojo.impl.internal.Nextable;
import org.eclipse.birt.data.oda.pojo.querymodel.ColumnReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.RelayReferenceNode;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetFromPojoInstance {
    private boolean nextCalled;
    private PojoQuery query;
    private Object root;
    private ClassLoader pojoClassLoader;
    private Map<ReferenceNode, Object> referenceValues = new HashMap<ReferenceNode, Object>();
    private Stack<NextableRelayReferenceNode> nextableRelayReferences = new Stack();

    public ResultSetFromPojoInstance(Object root, PojoQuery query, ClassLoader pojoClassLoader) throws OdaException {
        assert (root != null && query != null);
        this.root = root;
        this.query = query;
        this.nextCalled = false;
        this.pojoClassLoader = pojoClassLoader;
        this.fetchReferenceValues();
    }

    public Object getColumnValue(int index) throws OdaException {
        ColumnReferenceNode rn = this.query.getReferenceGraph().getColumnReferenceNode(index);
        return this.referenceValues.get(rn);
    }

    public boolean next() throws OdaException {
        if (!this.nextCalled) {
            this.nextCalled = true;
            return true;
        }
        NextableRelayReferenceNode relayNodeWithNextValue = null;
        while (!this.nextableRelayReferences.isEmpty()) {
            if (this.nextableRelayReferences.peek().getNextable().next()) {
                relayNodeWithNextValue = this.nextableRelayReferences.peek();
                break;
            }
            this.nextableRelayReferences.pop();
        }
        if (relayNodeWithNextValue != null) {
            Object nextValue = relayNodeWithNextValue.getNextable().getValue();
            if (this.referenceValues.containsKey(relayNodeWithNextValue.getRelayReferenceNode())) {
                this.referenceValues.put(relayNodeWithNextValue.getRelayReferenceNode(), nextValue);
            }
            this.fetchDescendantsValues(relayNodeWithNextValue.getRelayReferenceNode(), nextValue);
            return true;
        }
        return false;
    }

    private void fetchReferenceValues() throws OdaException {
        ReferenceNode[] referenceNodeArray = this.query.getReferenceGraph().getRoots();
        int n = referenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceNode rn = referenceNodeArray[n2];
            if (rn instanceof ColumnReferenceNode) {
                this.fetchColumnReferenceNodeValue((ColumnReferenceNode)rn, this.root);
            } else if (rn instanceof RelayReferenceNode) {
                Object value = this.fetchRelayReferenceNodeValue((RelayReferenceNode)rn, this.root);
                this.fetchDescendantsValues((RelayReferenceNode)rn, value);
            } else assert (false);
            ++n2;
        }
    }

    private void fetchColumnReferenceNodeValue(ColumnReferenceNode crn, Object from) throws OdaException {
        IMappingSource ms = crn.getReference();
        this.referenceValues.put(crn, ms.fetchValue(from, this.pojoClassLoader, this.query.getConnection().getClassMethodFieldBuffer()));
    }

    private Object fetchRelayReferenceNodeValue(RelayReferenceNode rrn, Object from) throws OdaException {
        IMappingSource ms = rrn.getReference();
        Object value = ms.fetchValue(from, this.pojoClassLoader, this.query.getConnection().getClassMethodFieldBuffer());
        if (Nextable.isNextable(value)) {
            Nextable n = Nextable.createNextable(value);
            if (n.next()) {
                this.pushNextableRelayReferenceNode(new NextableRelayReferenceNode(new InnermostNextable(n), rrn));
                value = n.getValue();
            } else {
                value = null;
            }
            this.referenceValues.put(rrn, value);
        } else {
            this.referenceValues.put(rrn, value);
        }
        return value;
    }

    private void fetchDescendantsValues(RelayReferenceNode rrn, Object from) throws OdaException {
        ReferenceNode[] referenceNodeArray = rrn.getChildren();
        int n = referenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceNode rn = referenceNodeArray[n2];
            if (rn instanceof ColumnReferenceNode) {
                this.fetchColumnReferenceNodeValue((ColumnReferenceNode)rn, from);
            } else if (rn instanceof RelayReferenceNode) {
                Object value = this.fetchRelayReferenceNodeValue((RelayReferenceNode)rn, from);
                this.fetchDescendantsValues((RelayReferenceNode)rn, value);
            } else assert (false);
            ++n2;
        }
    }

    private void pushNextableRelayReferenceNode(NextableRelayReferenceNode nrrn) throws OdaException {
        if (this.nextableRelayReferences.isEmpty()) {
            this.nextableRelayReferences.push(nrrn);
            return;
        }
        NextableRelayReferenceNode top = this.nextableRelayReferences.peek();
        if (!top.getRelayReferenceNode().isAAncestorFor(nrrn.getRelayReferenceNode())) {
            throw new OdaException(Messages.getString("ResultSetFromPojoInstance.Invalid1ToNMaps"));
        }
        this.nextableRelayReferences.push(nrrn);
    }

    private static class NextableRelayReferenceNode {
        private InnermostNextable nextable;
        private RelayReferenceNode relayReferenceNode;

        public NextableRelayReferenceNode(InnermostNextable nextable, RelayReferenceNode relayReferenceNode) {
            assert (nextable != null && relayReferenceNode != null);
            this.nextable = nextable;
            this.relayReferenceNode = relayReferenceNode;
        }

        public Nextable getNextable() {
            return this.nextable;
        }

        public RelayReferenceNode getRelayReferenceNode() {
            return this.relayReferenceNode;
        }
    }
}

