/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.junit.Assert;
import org.junit.Test;

public class DocumentManagerTest {
    @Test
    public void testFilesDocumentManager() throws IOException, DataException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        Assert.assertTrue((documentManager.createDocumentObject("dimension_student") != null ? 1 : 0) != 0);
        Assert.assertTrue((documentManager.createDocumentObject("dimension_student_index_ID") != null ? 1 : 0) != 0);
        Assert.assertTrue((documentManager.createDocumentObject("dimension_time") != null ? 1 : 0) != 0);
        Assert.assertTrue((documentManager.createDocumentObject("dimension_level_year") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = documentManager.openDocumentObject("dimension_student");
        Assert.assertTrue((documentObject != null ? 1 : 0) != 0);
        this.testDocumentObject1(documentObject);
        documentObject.close();
        documentObject = documentManager.openDocumentObject("dimension_student_index_ID");
        Assert.assertTrue((documentObject != null ? 1 : 0) != 0);
        this.testDocumentObject2(documentObject);
        documentObject.close();
        documentObject = documentManager.openDocumentObject("dimension_time");
        Assert.assertTrue((documentObject != null ? 1 : 0) != 0);
        this.testDocumentObject3(documentObject);
        documentObject.close();
        documentObject = documentManager.openDocumentObject("dimension_level_year");
        Assert.assertTrue((documentObject != null ? 1 : 0) != 0);
        this.testDocumentObject4(documentObject);
        documentObject.close();
        documentManager.close();
    }

    @Test
    public void testFilesDocumentManager2() throws IOException, DataException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        Assert.assertTrue((documentManager.createDocumentObject("dimension_student") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = documentManager.openDocumentObject("dimension_student");
        Assert.assertTrue((documentObject != null ? 1 : 0) != 0);
        documentObject.writeInt(4);
        byte[] b = new byte[10];
        Assert.assertEquals((long)documentObject.read(b, 0, b.length), (long)-1L);
        documentObject.close();
        documentManager.close();
    }

    @Test
    public void testFilesDocumentManager3() throws IOException, DataException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        Assert.assertTrue((documentManager.createDocumentObject("dimension_student") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = documentManager.openDocumentObject("dimension_student");
        Assert.assertTrue((documentObject != null ? 1 : 0) != 0);
        documentObject.writeInt(4);
        byte[] b = new byte[10];
        Assert.assertEquals((long)documentObject.read(b, 0, b.length), (long)-1L);
        documentObject.close();
        documentManager.close();
    }

    @Test
    public void testFilesDocumentManager4() throws IOException, DataException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        Assert.assertTrue((documentManager.createDocumentObject("dimension_student") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = documentManager.openDocumentObject("dimension_student");
        Assert.assertTrue((documentObject != null ? 1 : 0) != 0);
        byte[] b = new byte[100000];
        documentObject.write(b, 0, b.length);
        documentObject.close();
        documentManager.close();
    }

    private void testDocumentObject1(IDocumentObject documentObject) throws IOException {
        int objectNumber = 200;
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeString("string" + i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readString(), (Object)("string" + i));
            ++i;
        }
    }

    private void testDocumentObject2(IDocumentObject documentObject) throws IOException {
        int objectNumber = 200;
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeString("string" + i);
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            documentObject.writeInt(i);
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            documentObject.writeBigDecimal(new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            documentObject.writeDouble(100.0 + (double)i);
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            documentObject.writeBoolean(i % 2 == 0);
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            documentObject.writeDate(new Date(190001000 + i * 1000));
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readString(), (Object)("string" + i));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((long)documentObject.readInt(), (long)i);
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readBigDecimal(), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((double)documentObject.readDouble(), (double)(100.0 + (double)i), (double)0.001);
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readBoolean(), (Object)(i % 2 == 0 ? 1 : 0));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            documentObject.writeDate(new Date(190001000 + i * 1000));
            ++i;
        }
    }

    private void testDocumentObject3(IDocumentObject documentObject) throws IOException {
        int objectNumber = 200;
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeString(i + "string" + i);
            documentObject.writeInt(i);
            documentObject.writeBigDecimal(new BigDecimal("1010101010101010101010" + i));
            documentObject.writeDouble(100.0 + (double)i);
            documentObject.writeBoolean(i % 2 == 0);
            documentObject.writeDate(new Date(1000 + i * 1000));
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)documentObject.readString(), (Object)(i + "string" + i));
            Assert.assertEquals((long)documentObject.readInt(), (long)i);
            Assert.assertEquals((Object)documentObject.readBigDecimal(), (Object)new BigDecimal("1010101010101010101010" + i));
            Assert.assertEquals((double)documentObject.readDouble(), (double)(100.0 + (double)i), (double)0.001);
            Assert.assertEquals((Object)documentObject.readBoolean(), (Object)(i % 2 == 0 ? 1 : 0));
            documentObject.writeDate(new Date(1000 + i * 1000));
            ++i;
        }
    }

    private void testDocumentObject4(IDocumentObject documentObject) throws IOException {
        documentObject.setLength(4000L);
        documentObject.seek(0L);
        documentObject.writeInt(1);
        documentObject.seek(400L);
        documentObject.writeInt(401);
        documentObject.seek(80L);
        documentObject.writeInt(21);
        documentObject.seek(160L);
        documentObject.writeInt(41);
        documentObject.seek(0L);
        Assert.assertEquals((long)documentObject.readInt(), (long)1L);
        documentObject.seek(80L);
        Assert.assertEquals((long)documentObject.readInt(), (long)21L);
        documentObject.seek(160L);
        Assert.assertEquals((long)documentObject.readInt(), (long)41L);
    }
}

