/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.IEarFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class EarFacetInstallDataModelProvider
extends J2EEFacetInstallDataModelProvider
implements IEarFacetInstallDataModelProperties {
    @Override
    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IEarFacetInstallDataModelProperties.CONTENT_DIR");
        names.add("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST");
        names.add("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.ear";
        }
        if (propertyName.equals("IEarFacetInstallDataModelProperties.CONTENT_DIR")) {
            if (this.model.isPropertySet("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
                IVirtualComponent c;
                IVirtualFolder ejbroot;
                IPath configFolderPath;
                IProject project;
                String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                Path path = new Path(projectName);
                IProject iProject = project = projectName.length() > 0 && path.isValidSegment(projectName) ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
                if (project != null && project.exists() && ModuleCoreNature.isFlexibleProject((IProject)project) && (configFolderPath = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder(ejbroot = (c = ComponentCore.createComponent((IProject)project, (boolean)true)).getRootFolder())) != null && (configFolderPath.isRoot() || project.getFolder(configFolderPath).exists())) {
                    return configFolderPath.toString();
                }
            }
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("earContent");
        }
        if (propertyName.equals("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST") || propertyName.equals("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST")) {
            return Collections.EMPTY_LIST;
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
            String facetVersion = this.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
            if (J2EEVersionUtil.convertVersionStringToInt(facetVersion) >= 50) {
                return J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("application_generate_dd");
            }
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String name) {
        if (name.equals("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST")) {
            return this.validateTargetComponentVersion((List)this.model.getProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST"));
        }
        if (name.equals("IEarFacetInstallDataModelProperties.CONTENT_DIR")) {
            return this.validateFolderName(this.getStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR"));
        }
        return super.validate(name);
    }

    private IStatus validateTargetComponentVersion(List list) {
        int earVersion = this.getJ2EEVersion();
        for (IProject handle : list) {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)handle.getProject());
            if (comp == null) {
                return OK_STATUS;
            }
            int compVersion = J2EEVersionUtil.convertVersionStringToInt(comp);
            if (earVersion >= compVersion) continue;
            String errorStatus = NLS.bind((String)ProjectSupportResourceHandler.EarFacetInstallDataModelProvider_The_Module_specification_level_of_, (Object)handle.getName());
            return J2EEPlugin.newErrorStatus(errorStatus, null);
        }
        return OK_STATUS;
    }

    @Override
    protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
        return J2EEVersionUtil.convertVersionStringToInt(version.getVersionString());
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName) && !this.model.isPropertySet("IEarFacetInstallDataModelProperties.CONTENT_DIR")) {
            this.model.notifyPropertyChange("IEarFacetInstallDataModelProperties.CONTENT_DIR", 2);
        }
        return super.propertySet(propertyName, propertyValue);
    }
}

