/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.search.PreviewReferenceAction;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;

public class SchemaPreviewLauncher
implements IEditorLauncher {
    public void open(IPath filePath) {
        PreviewReferenceAction action = new PreviewReferenceAction();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(filePath);
        if (file == null) {
            Display.getDefault().beep();
        } else {
            this.handleUnsavedOpenSchemaEditor(file);
            IAction emptyAction = null;
            action.selectionChanged(emptyAction, (ISelection)new StructuredSelection((Object)file));
            action.run(emptyAction);
        }
    }

    private void handleUnsavedOpenSchemaEditor(IFile file) {
        SchemaEditor editor = PDEModelUtility.getOpenSchemaEditor(file);
        if (editor == null) {
            return;
        }
        if (!editor.isDirty()) {
            return;
        }
        boolean doSave = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PDEUIMessages.SchemaPreviewLauncher_msgEditorHasUnsavedChanges, (String)PDEUIMessages.SchemaPreviewLauncher_msgSaveChanges);
        if (doSave) {
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

