/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.type.impl;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.TypeFactory;
import org.eclipse.birt.chart.model.type.TypePackage;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class BarSeriesImpl
extends SeriesImpl
implements BarSeries {
    protected static final RiserType RISER_EDEFAULT = RiserType.RECTANGLE_LITERAL;
    protected RiserType riser = RISER_EDEFAULT;
    protected boolean riserESet;
    protected ColorDefinition riserOutline;

    protected BarSeriesImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TypePackage.Literals.BAR_SERIES;
    }

    @Override
    public RiserType getRiser() {
        return this.riser;
    }

    @Override
    public void setRiser(RiserType newRiser) {
        RiserType oldRiser = this.riser;
        this.riser = newRiser == null ? RISER_EDEFAULT : newRiser;
        boolean oldRiserESet = this.riserESet;
        this.riserESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldRiser, (Object)this.riser, !oldRiserESet));
        }
    }

    @Override
    public void unsetRiser() {
        RiserType oldRiser = this.riser;
        boolean oldRiserESet = this.riserESet;
        this.riser = RISER_EDEFAULT;
        this.riserESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 12, (Object)oldRiser, (Object)RISER_EDEFAULT, oldRiserESet));
        }
    }

    @Override
    public boolean isSetRiser() {
        return this.riserESet;
    }

    @Override
    public ColorDefinition getRiserOutline() {
        return this.riserOutline;
    }

    public NotificationChain basicSetRiserOutline(ColorDefinition newRiserOutline, NotificationChain msgs) {
        ColorDefinition oldRiserOutline = this.riserOutline;
        this.riserOutline = newRiserOutline;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldRiserOutline, (Object)newRiserOutline);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setRiserOutline(ColorDefinition newRiserOutline) {
        if (newRiserOutline != this.riserOutline) {
            NotificationChain msgs = null;
            if (this.riserOutline != null) {
                msgs = ((InternalEObject)this.riserOutline).eInverseRemove((InternalEObject)this, -14, null, msgs);
            }
            if (newRiserOutline != null) {
                msgs = ((InternalEObject)newRiserOutline).eInverseAdd((InternalEObject)this, -14, null, msgs);
            }
            if ((msgs = this.basicSetRiserOutline(newRiserOutline, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newRiserOutline, (Object)newRiserOutline));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                return this.basicSetRiserOutline(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 12: {
                return this.getRiser();
            }
            case 13: {
                return this.getRiserOutline();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setRiser((RiserType)((Object)newValue));
                return;
            }
            case 13: {
                this.setRiserOutline((ColorDefinition)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.unsetRiser();
                return;
            }
            case 13: {
                this.setRiserOutline(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 12: {
                return this.isSetRiser();
            }
            case 13: {
                return this.riserOutline != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (riser: ");
        if (this.riserESet) {
            result.append((Object)this.riser);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public final boolean canParticipateInCombination() {
        return true;
    }

    @Override
    public boolean canShareAxisUnit() {
        return true;
    }

    public static final Series create() {
        BarSeries bs = TypeFactory.eINSTANCE.createBarSeries();
        ((BarSeriesImpl)bs).initialize();
        return bs;
    }

    @Override
    protected final void initialize() {
        super.initialize();
        this.setRiserOutline(null);
        this.setRiser(RiserType.RECTANGLE_LITERAL);
        this.setVisible(true);
    }

    public static final Series createDefault() {
        BarSeries bs = TypeFactory.eINSTANCE.createBarSeries();
        ((BarSeriesImpl)bs).initDefault();
        return bs;
    }

    @Override
    protected final void initDefault() {
        super.initDefault();
        this.riserOutline = null;
        this.riser = RiserType.RECTANGLE_LITERAL;
        this.visible = true;
    }

    @Override
    public final boolean canBeStacked() {
        return true;
    }

    @Override
    public void translateFrom(Series series, int iSeriesDefinitionIndex, Chart chart) {
        this.setLabel(series.getLabel());
        if (series.isSetLabelPosition()) {
            if (series.getLabelPosition().equals((Object)Position.INSIDE_LITERAL) || series.getLabelPosition().equals((Object)Position.OUTSIDE_LITERAL)) {
                this.setLabelPosition(series.getLabelPosition());
            } else {
                this.setLabelPosition(Position.OUTSIDE_LITERAL);
            }
        }
        if (series.isSetVisible()) {
            this.setVisible(series.isVisible());
        }
        if (series.isSetStacked()) {
            this.setStacked(series.isStacked());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_Triggers())) {
            this.getTriggers().addAll(series.getTriggers());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataPoint())) {
            this.setDataPoint(series.getDataPoint());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataDefinition())) {
            this.getDataDefinition().add((Object)((Query)series.getDataDefinition().get(0)));
        }
        if (series instanceof BarSeries) {
            this.setRiserOutline(((BarSeries)series).getRiserOutline());
        } else if (series instanceof PieSeries) {
            this.setRiserOutline(((PieSeries)series).getSliceOutline());
        } else if (series instanceof StockSeries) {
            this.setRiserOutline(((StockSeries)series).getLineAttributes().getColor());
        }
        if (!(chart instanceof ChartWithAxes)) {
            throw new IllegalArgumentException(Messages.getString("error.invalid.argument.for.barSeries", new Object[]{chart.getClass().getName()}, ULocale.getDefault()));
        }
        chart.setSampleData(this.getConvertedSampleData(chart.getSampleData(), iSeriesDefinitionIndex));
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, int iSeriesDefinitionIndex) {
        EList<OrthogonalSampleData> osdList = currentSampleData.getOrthogonalSampleData();
        int i = 0;
        while (i < osdList.size()) {
            if (i == iSeriesDefinitionIndex) {
                OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
                osd.setDataSetRepresentation(this.getConvertedOrthogonalSampleDataRepresentation(osd.getDataSetRepresentation()));
                currentSampleData.getOrthogonalSampleData().set(i, (Object)osd);
            }
            ++i;
        }
        return currentSampleData;
    }

    private String getConvertedOrthogonalSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        StringBuilder sbNewRepresentation = new StringBuilder("");
        while (strtok.hasMoreTokens()) {
            String sElement = strtok.nextToken().trim();
            if (sElement.startsWith("H")) {
                StringTokenizer strStockTokenizer = new StringTokenizer(sElement);
                sbNewRepresentation.append(strStockTokenizer.nextToken().trim().substring(1));
            } else {
                sbNewRepresentation.append(sElement);
            }
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    @Override
    public String getDisplayName() {
        switch (this.getRiser().getValue()) {
            case 1: {
                return Messages.getString("BarSeriesImpl.pyramidDisplayName");
            }
            case 3: {
                return Messages.getString("BarSeriesImpl.coneDisplayName");
            }
            case 2: {
                return Messages.getString("BarSeriesImpl.tubeDisplayName");
            }
        }
        return Messages.getString("BarSeriesImpl.displayName");
    }

    @Override
    public boolean isSingleCache() {
        return this.isStacked();
    }

    @Override
    public BarSeries copyInstance() {
        BarSeriesImpl dest = new BarSeriesImpl();
        dest.set(this);
        return dest;
    }

    protected void set(BarSeries src) {
        super.set(src);
        if (src.getRiserOutline() != null) {
            this.setRiserOutline(src.getRiserOutline().copyInstance());
        }
        this.riser = src.getRiser();
        this.riserESet = src.isSetRiser();
    }

    @Override
    public NameSet getLabelPositionScope(ChartDimension dimension) {
        if (ChartDimension.THREE_DIMENSIONAL_LITERAL == dimension) {
            return LiteralHelper.outPositionSet;
        }
        return LiteralHelper.inoutPositionSet;
    }
}

