/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.shared.common.error.StandardException;

public final class StatementRoutinePermission
extends StatementPermission {
    private UUID routineUUID;

    public StatementRoutinePermission(UUID routineUUID) {
        this.routineUUID = routineUUID;
    }

    public UUID getRoutineUUID() {
        return this.routineUUID;
    }

    @Override
    public void check(LanguageConnectionContext lcc, boolean forGrant, Activation activation) throws StandardException {
        this.genericCheck(lcc, forGrant, activation, "EXECUTE");
    }

    @Override
    public boolean isCorrectPermission(PermissionsDescriptor raw) {
        if (raw == null || !(raw instanceof RoutinePermsDescriptor)) {
            return false;
        }
        RoutinePermsDescriptor pd = (RoutinePermsDescriptor)raw;
        return pd.getHasExecutePermission();
    }

    @Override
    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dd) throws StandardException {
        return dd.getAliasDescriptor(this.routineUUID);
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return dd.getRoutinePermissions(this.routineUUID, authid);
    }

    @Override
    public String getObjectType() {
        return "ROUTINE";
    }

    public String toString() {
        return "StatementRoutinePermission: " + this.routineUUID;
    }
}

