/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.DataEngineThreadLocal;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

abstract class BaseDiskArray
implements IDiskArray {
    private static final String fileNamePrefix = "BasicDiskList";
    private static final int FILE_BUFFER_SIZE = 1024;
    private static final int bufferSize = 1;
    protected static final short NORMAL_VALUE = 0;
    protected static final short NULL_VALUE = -1;
    private static Logger logger = Logger.getLogger(BaseDiskArray.class.getName());
    private int currentCacheStartIndex = 0;
    private int size = 0;
    private File diskFile = null;
    protected BufferedRandomAccessFile randomAccessFile = null;
    private Object[] buffer = new Object[1];
    private List<Long> segmentOffsets = new ArrayList<Long>();

    public BaseDiskArray() throws IOException {
        this.segmentOffsets.add(0L);
        DataEngineThreadLocal.getInstance().getCloseListener().add(this);
    }

    @Override
    public boolean add(Object o) throws IOException {
        if (this.size >= this.currentCacheStartIndex && this.size < this.currentCacheStartIndex + 1) {
            this.buffer[this.size - this.currentCacheStartIndex] = o;
        }
        this.writeObject(o);
        ++this.size;
        if (this.size % 1 == 0) {
            this.segmentOffsets.add(this.getOffset());
        }
        return true;
    }

    private void createRandomAccessFile() throws IOException {
        this.createCacheFile();
        this.randomAccessFile = new BufferedRandomAccessFile(this.diskFile, "rw", 1024);
    }

    private long getOffset() throws IOException {
        return this.getRandomAccessFile().getFilePointer();
    }

    protected abstract void writeObject(Object var1) throws IOException;

    @Override
    public Object get(int index) throws IOException {
        this.RangeCheck(index);
        if (index < this.currentCacheStartIndex || index > this.currentCacheStartIndex + 1 - 1) {
            int readSize = 1;
            if (index / 1 == this.segmentOffsets.size() - 1) {
                readSize = this.size % 1;
            }
            this.currentCacheStartIndex = index / 1 * 1;
            this.readObjects(this.getSegmentOffset(index), readSize);
        }
        return this.buffer[index % 1];
    }

    private long getSegmentOffset(int index) {
        return this.segmentOffsets.get(index / 1);
    }

    private void readObjects(long offset, int readSize) throws IOException {
        this.getRandomAccessFile().seek(offset);
        int i = 0;
        while (i < readSize) {
            this.buffer[i] = this.readObject();
            ++i;
        }
    }

    protected abstract Object readObject() throws IOException;

    private void createCacheFile() throws IOException {
        String tempFileStr = DataEngineThreadLocal.getInstance().getPathManager().getTempFileName(fileNamePrefix, this.hashCode(), "");
        if (this.diskFile == null) {
            this.diskFile = new File(tempFileStr);
            FileSecurity.createNewFile(this.diskFile);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        this.clearDiskFile();
        this.size = 0;
        this.buffer = null;
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void clearDiskFile() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        if (this.diskFile != null) {
            FileSecurity.fileDelete(this.diskFile);
            this.diskFile = null;
        }
    }

    @Override
    public void clear() throws IOException {
        this.currentCacheStartIndex = -1;
        this.size = 0;
        this.clearDiskFile();
        this.segmentOffsets.clear();
        this.segmentOffsets.add(0L);
        this.createRandomAccessFile();
    }

    public BufferedRandomAccessFile getRandomAccessFile() throws IOException {
        if (this.randomAccessFile == null) {
            this.createRandomAccessFile();
        }
        return this.randomAccessFile;
    }
}

