/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class HistoryToolBar
extends Composite {
    private ToolBarManager toolbarManager = null;
    private List history = new ArrayList();
    private int historyIndex = -1;
    private TreeViewer viewer;

    public HistoryToolBar(Composite parent, TreeViewer viewer, int style) {
        super(parent, 0);
        GridLayout toolbarLayout = new GridLayout();
        toolbarLayout.marginHeight = 0;
        toolbarLayout.verticalSpacing = 0;
        this.setLayout((Layout)toolbarLayout);
        this.setLayoutData(new GridData(0x1000008, 4, false, true));
        ToolBar toolBar = new ToolBar((Composite)this, style);
        toolBar.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        this.toolbarManager = new ToolBarManager(toolBar);
        this.viewer = viewer;
        this.createHistoryControls(toolBar);
        this.toolbarManager.update(false);
        this.initAccessible();
    }

    private void createHistoryControls(ToolBar historyBar) {
        abstract class HistoryNavigationAction
        extends Action
        implements IMenuCreator {
            private Menu lastMenu;
            protected static final int MAX_ENTRIES = 5;

            HistoryNavigationAction() {
                super("", 4);
            }

            public IMenuCreator getMenuCreator() {
                return this;
            }

            public void dispose() {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                    this.lastMenu = null;
                }
            }

            public Menu getMenu(Control parent) {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                }
                this.lastMenu = new Menu(parent);
                this.createEntries(this.lastMenu);
                return this.lastMenu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            protected void addActionToMenu(Menu parent, IAction action) {
                ActionContributionItem item = new ActionContributionItem(action);
                item.fill(parent, -1);
            }

            protected abstract void createEntries(Menu var1);
        }
        HistoryNavigationAction backward = new HistoryNavigationAction(this){
            {
            }

            public void run() {
                this.jumpToHistory(historyIndex - 1);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = historyIndex > 0;
                if (enabled) {
                    this.setToolTipText(this.getHistoryToolTip(this.getText(), historyIndex - 1));
                } else {
                    this.setToolTipText(this.getText());
                }
                return enabled;
            }

            @Override
            protected void createEntries(Menu menu) {
                int limit = Math.max(0, historyIndex - 5);
                int i = historyIndex - 1;
                while (i >= limit) {
                    class HistoryItemAction
                    extends Action {
                        private final int index;

                        HistoryItemAction(int index, String label) {
                            super(label, 1);
                            this.index = index;
                        }

                        public void run() {
                            HistoryToolBar.this.jumpToHistory(this.index);
                        }
                    }
                    HistoryItemAction action = new HistoryItemAction(i, this.getHistoryPropertyNode(i).getNodeLabel());
                    this.addActionToMenu(menu, (IAction)action);
                    --i;
                }
            }
        };
        backward.setText(Messages.getString((String)"dataset.editor.historybar.backward"));
        if (HistoryToolBar.isBidi()) {
            backward.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"ForwardEnabled"));
            backward.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"ForwardDisabled"));
        } else {
            backward.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"BackwardEnabled"));
            backward.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"BackwardDisabled"));
        }
        this.toolbarManager.add((IAction)backward);
        HistoryNavigationAction forward = new HistoryNavigationAction(this){
            {
            }

            public void run() {
                this.jumpToHistory(historyIndex + 1);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = historyIndex < history.size() - 1;
                if (enabled) {
                    this.setToolTipText(this.getHistoryToolTip(this.getText(), historyIndex + 1));
                } else {
                    this.setToolTipText(this.getText());
                }
                return enabled;
            }

            @Override
            protected void createEntries(Menu menu) {
                int limit = Math.min(history.size(), historyIndex + 5 + 1);
                int i = historyIndex + 1;
                while (i < limit) {
                    HistoryItemAction action = new HistoryItemAction(i, this.getHistoryPropertyNode(i).getNodeLabel());
                    this.addActionToMenu(menu, (IAction)action);
                    ++i;
                }
            }
        };
        forward.setText(Messages.getString((String)"dataset.editor.historybar.forward"));
        if (HistoryToolBar.isBidi()) {
            forward.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"BackwardEnabled"));
            forward.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"BackwardDisabled"));
        } else {
            forward.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"ForwardEnabled"));
            forward.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"ForwardDisabled"));
        }
        this.toolbarManager.add((IAction)forward);
    }

    private static boolean isBidi() {
        String lang = (String)System.getProperties().get("osgi.nl.user");
        return "iw".equals(lang) || "ar".equals(lang) || "fa".equals(lang) || "ur".equals(lang);
    }

    private void jumpToHistory(int index) {
        if (this.canLeave() && index >= 0 && index < this.history.size()) {
            this.historyIndex = index;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)((PropertyNode)this.history.get(this.historyIndex))));
        }
        this.updateHistoryControls();
    }

    private boolean canLeave() {
        if (this.history.get(this.historyIndex) != null) {
            return ((PropertyNode)this.history.get(this.historyIndex)).getPage().canLeave();
        }
        return false;
    }

    public void addHistoryNode(PropertyNode node) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(node)) {
            this.history.subList(this.historyIndex + 1, this.history.size()).clear();
            this.history.add(node);
            ++this.historyIndex;
            this.updateHistoryControls();
        }
    }

    private void updateHistoryControls() {
        this.toolbarManager.update(false);
        IContributionItem[] items = this.toolbarManager.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].update("enabled");
            items[i].update("toolTipText");
            ++i;
        }
    }

    private String getHistoryToolTip(String toolTipPrefix, int index) {
        return toolTipPrefix + " " + Messages.getString((String)"dataset.editor.historybar.to") + " " + this.getHistoryPropertyNode(index).getNodeLabel();
    }

    private PropertyNode getHistoryPropertyNode(int index) {
        return (PropertyNode)this.history.get(index);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = HistoryToolBar.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = HistoryToolBar.this.toControl(new Point(e.x, e.y));
                if (HistoryToolBar.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = HistoryToolBar.this.getBounds();
                Point pt = HistoryToolBar.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

