/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineDecorator;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.SeriesValueImpl;
import org.eclipse.birt.chart.model.component.DialRegion;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.DialRegionImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;

public final class Regression_124765_swing
extends JPanel
implements ICallBackNotifier,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private boolean bNeedsGeneration = true;
    private GeneratedChartState gcs = null;
    private Chart cm = null;
    private IDeviceRenderer idr = null;
    private BufferedImage bi = null;
    private Map contextMap = new HashMap();

    public static void main(String[] args) {
        final Regression_124765_swing siv = new Regression_124765_swing();
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(2);
        jf.addComponentListener(siv);
        Container co = jf.getContentPane();
        co.setLayout(new BorderLayout());
        co.add((Component)siv, "Center");
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dApp = new Dimension(600, 400);
        jf.setSize(dApp);
        jf.setLocation((dScreen.width - dApp.width) / 2, (dScreen.height - dApp.height) / 2);
        jf.setTitle(siv.getClass().getName() + " [device=" + siv.idr.getClass().getName() + "]");
        Regression_124765_swing regression_124765_swing = siv;
        regression_124765_swing.getClass();
        ControlPanel cp = regression_124765_swing.new ControlPanel(siv);
        co.add((Component)cp, "South");
        siv.idr.setProperty("device.component", (Object)siv);
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                siv.idr.dispose();
            }
        });
        jf.setVisible(true);
    }

    Regression_124765_swing() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.SWING");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_124765_swing.highlight_MeterChart();
    }

    public void regenerateChart() {
        this.bNeedsGeneration = true;
        this.updateBuffer();
        this.repaint();
    }

    public void repaintChart() {
        this.repaint();
    }

    public Object peerInstance() {
        return this;
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    public Object putContext(Object key, Object value) {
        return this.contextMap.put(key, value);
    }

    public Object removeContext(Object key) {
        return this.contextMap.remove(key);
    }

    public void updateBuffer() {
        Dimension d = this.getSize();
        if (this.bi == null || this.bi.getWidth() != d.width || this.bi.getHeight() != d.height) {
            this.bi = new BufferedImage(d.width, d.height, 2);
        }
        Graphics2D g2d = (Graphics2D)this.bi.getGraphics();
        this.idr.setProperty("device.output.context", (Object)g2d);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        if (this.bNeedsGeneration) {
            this.bNeedsGeneration = false;
            try {
                this.gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, null, null, null);
            }
            catch (ChartException ex) {
                this.showException(g2d, (Exception)((Object)ex));
            }
        }
        try {
            try {
                gr.render(this.idr, this.gcs);
            }
            catch (ChartException rex) {
                this.showException(g2d, (Exception)((Object)rex));
                g2d.dispose();
            }
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.bi == null) {
            this.updateBuffer();
        }
        g.drawImage(this.bi, 0, 0, this);
    }

    private void showException(Graphics2D g2d, Exception ex) {
        String sWrappedException = ex.getClass().getName();
        Exception th = ex;
        while (ex.getCause() != null) {
            ex = (Exception)ex.getCause();
        }
        String sException = ex.getClass().getName();
        if (sWrappedException.equals(sException)) {
            sWrappedException = null;
        }
        String sMessage = null;
        sMessage = th instanceof BirtException ? ((BirtException)th).getLocalizedMessage() : ex.getMessage();
        if (sMessage == null) {
            sMessage = "<null>";
        }
        StackTraceElement[] stea = ex.getStackTrace();
        Dimension d = this.getSize();
        Font fo = new Font("Monospaced", 1, 14);
        g2d.setFont(fo);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(20, 20, d.width - 40, d.height - 40);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(20, 20, d.width - 40, d.height - 40);
        g2d.setClip(20, 20, d.width - 40, d.height - 40);
        int x = 25;
        int y = 20 + fm.getHeight();
        g2d.drawString("Exception:", x, y);
        g2d.setColor(Color.RED);
        g2d.drawString(sException, x += fm.stringWidth("Exception:") + 5, y);
        x = 25;
        y += fm.getHeight();
        if (sWrappedException != null) {
            g2d.setColor(Color.BLACK);
            g2d.drawString("Wrapped In:", x, y);
            g2d.setColor(Color.RED);
            g2d.drawString(sWrappedException, x += fm.stringWidth("Wrapped In:") + 5, y);
            x = 25;
            y += fm.getHeight();
        }
        g2d.setColor(Color.BLACK);
        g2d.drawString("Message:", x, y += 10);
        g2d.setColor(Color.BLUE);
        g2d.drawString(sMessage, x += fm.stringWidth("Message:") + 5, y);
        x = 25;
        y += fm.getHeight();
        g2d.setColor(Color.BLACK);
        g2d.drawString("Trace:", x, y += 10);
        x = 40;
        y += fm.getHeight();
        g2d.setColor(Color.GREEN.darker());
        int i = 0;
        while (i < stea.length) {
            g2d.drawString(stea[i].getClassName() + ":" + stea[i].getMethodName() + "(...):" + stea[i].getLineNumber(), x, y);
            x = 40;
            y += fm.getHeight();
            ++i;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.bNeedsGeneration = true;
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void callback(Object event, Object source, CallBackValue value) {
        JOptionPane.showMessageDialog(this, value.getIdentifier());
    }

    public static Chart highlight_MeterChart() {
        DialChart dChart = (DialChart)DialChartImpl.create();
        dChart.setDialSuperimposition(false);
        dChart.setGridColumnCount(2);
        dChart.setSeriesThickness(25.0);
        dChart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot p = dChart.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.CREAM());
        p.getClientArea().getOutline().setVisible(false);
        p.getOutline().setVisible(false);
        dChart.getTitle().getLabel().getCaption().setValue("Meter Chart");
        dChart.getTitle().getOutline().setVisible(false);
        Legend lg = dChart.getLegend();
        LineAttributes lia = lg.getOutline();
        lg.getText().getFont().setSize(16.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        lg.getInsets().setLeft(10.0);
        lg.getInsets().setRight(10.0);
        lg.setBackground(null);
        lg.getOutline().setVisible(false);
        lg.setShowValue(true);
        lg.getClientArea().setBackground((Fill)ColorDefinitionImpl.PINK());
        lg.getClientArea().getOutline().setVisible(true);
        lg.getTitle().getCaption().getFont().setSize(20.0f);
        lg.getTitle().setInsets(InsetsImpl.create((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        lg.setTitlePosition(Position.ABOVE_LITERAL);
        lg.setPosition(Position.BELOW_LITERAL);
        lg.setItemType(LegendItemType.SERIES_LITERAL);
        lg.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.HIGHLIGHT_LITERAL, (ActionValue)SeriesValueImpl.create((String)"not-used"))));
        TextDataSet categoryValues = TextDataSetImpl.create((Object)new String[]{"Moto"});
        SeriesDefinition sd = SeriesDefinitionImpl.create();
        dChart.getSeriesDefinitions().add((Object)sd);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        sd.getSeries().add((Object)seCategory);
        SeriesDefinition sdCity = SeriesDefinitionImpl.create();
        Fill[] fiaOrth = new Fill[]{ColorDefinitionImpl.PINK(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.WHITE()};
        sdCity.getSeriesPalette().getEntries().clear();
        int i = 0;
        while (i < fiaOrth.length) {
            sdCity.getSeriesPalette().getEntries().add((Object)fiaOrth[i]);
            ++i;
        }
        DialSeries seDial1 = (DialSeries)DialSeriesImpl.create();
        seDial1.setDataSet((DataSet)NumberDataSetImpl.create((Object)new double[]{20.0}));
        seDial1.getDial().setFill((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)255, (int)225), (ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (double)45.0, (boolean)false));
        seDial1.setSeriesIdentifier((Object)"Temperature");
        seDial1.getNeedle().setDecorator(LineDecorator.CIRCLE_LITERAL);
        seDial1.getDial().setStartAngle(-45.0);
        seDial1.getDial().setStopAngle(225.0);
        seDial1.getDial().getMinorGrid().getTickAttributes().setVisible(true);
        seDial1.getDial().getMinorGrid().getTickAttributes().setColor(ColorDefinitionImpl.BLACK());
        seDial1.getDial().getMinorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        seDial1.getDial().getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        seDial1.getDial().getScale().setMax((DataElement)NumberDataElementImpl.create((double)90.0));
        seDial1.getDial().getScale().setStep(10.0);
        seDial1.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        seDial1.getLabel().setBackground((Fill)ColorDefinitionImpl.GREY().brighter());
        DialRegion dregion1 = DialRegionImpl.create();
        dregion1.setFill((Fill)ColorDefinitionImpl.GREEN());
        dregion1.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        dregion1.setStartValue((DataElement)NumberDataElementImpl.create((double)70.0));
        dregion1.setEndValue((DataElement)NumberDataElementImpl.create((double)90.0));
        dregion1.setInnerRadius(40.0);
        dregion1.setOuterRadius(-1.0);
        seDial1.getDial().getDialRegions().add((Object)dregion1);
        DialRegion dregion2 = DialRegionImpl.create();
        dregion2.setFill((Fill)ColorDefinitionImpl.YELLOW());
        dregion2.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        dregion2.setStartValue((DataElement)NumberDataElementImpl.create((double)40.0));
        dregion2.setEndValue((DataElement)NumberDataElementImpl.create((double)70.0));
        dregion2.setOuterRadius(70.0);
        seDial1.getDial().getDialRegions().add((Object)dregion2);
        DialRegion dregion3 = DialRegionImpl.create();
        dregion3.setFill((Fill)ColorDefinitionImpl.RED());
        dregion3.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        dregion3.setStartValue((DataElement)NumberDataElementImpl.create((double)0.0));
        dregion3.setEndValue((DataElement)NumberDataElementImpl.create((double)40.0));
        dregion3.setInnerRadius(40.0);
        dregion3.setOuterRadius(90.0);
        seDial1.getDial().getDialRegions().add((Object)dregion3);
        DialSeries seDial2 = (DialSeries)DialSeriesImpl.create();
        seDial2.setDataSet((DataSet)NumberDataSetImpl.create((Object)new double[]{58.0}));
        seDial2.getDial().setFill((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)255, (int)225), (ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (double)45.0, (boolean)false));
        seDial2.setSeriesIdentifier((Object)"Wind Speed");
        seDial2.getNeedle().setDecorator(LineDecorator.CIRCLE_LITERAL);
        seDial2.getDial().setStartAngle(-45.0);
        seDial2.getDial().setStopAngle(225.0);
        seDial2.getDial().getMinorGrid().getTickAttributes().setVisible(true);
        seDial2.getDial().getMinorGrid().getTickAttributes().setColor(ColorDefinitionImpl.BLACK());
        seDial2.getDial().getMinorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        seDial2.getDial().getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        seDial2.getDial().getScale().setMax((DataElement)NumberDataElementImpl.create((double)90.0));
        seDial2.getDial().getScale().setStep(10.0);
        seDial2.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        seDial2.getLabel().setBackground((Fill)ColorDefinitionImpl.GREY().brighter());
        seDial2.getDial().getDialRegions().add((Object)dregion1);
        seDial2.getDial().getDialRegions().add((Object)dregion2);
        seDial2.getDial().getDialRegions().add((Object)dregion3);
        DialSeries seDial3 = (DialSeries)DialSeriesImpl.create();
        seDial3.setDataSet((DataSet)NumberDataSetImpl.create((Object)new double[]{80.0}));
        seDial3.getDial().setFill((Fill)GradientImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)225, (int)255, (int)225), (ColorDefinition)ColorDefinitionImpl.create((int)225, (int)225, (int)255), (double)45.0, (boolean)false));
        seDial3.setSeriesIdentifier((Object)"Viscosity");
        seDial3.getNeedle().setDecorator(LineDecorator.CIRCLE_LITERAL);
        seDial3.getDial().setStartAngle(-45.0);
        seDial3.getDial().setStopAngle(225.0);
        seDial3.getDial().getMinorGrid().getTickAttributes().setVisible(true);
        seDial3.getDial().getMinorGrid().getTickAttributes().setColor(ColorDefinitionImpl.BLACK());
        seDial3.getDial().getMinorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        seDial3.getDial().getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        seDial3.getDial().getScale().setMax((DataElement)NumberDataElementImpl.create((double)90.0));
        seDial3.getDial().getScale().setStep(10.0);
        seDial3.getLabel().setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY().darker(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        seDial3.getLabel().setBackground((Fill)ColorDefinitionImpl.GREY().brighter());
        seDial3.getDial().getDialRegions().add((Object)dregion1);
        seDial3.getDial().getDialRegions().add((Object)dregion2);
        seDial3.getDial().getDialRegions().add((Object)dregion3);
        dChart.setDialSuperimposition(true);
        sd.getSeriesDefinitions().add((Object)sdCity);
        sdCity.getSeries().add((Object)seDial1);
        sdCity.getSeries().add((Object)seDial2);
        sdCity.getSeries().add((Object)seDial3);
        return dChart;
    }

    private final class ControlPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final Regression_124765_swing siv;

        ControlPanel(Regression_124765_swing siv) {
            this.siv = siv;
            this.setLayout(new GridLayout(0, 1, 0, 0));
            JPanel jp = new JPanel();
            jp.setLayout(new FlowLayout(0, 3, 3));
            this.add(jp);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Regression_124765_swing.this.cm = Regression_124765_swing.highlight_MeterChart();
            Regression_124765_swing.this.bNeedsGeneration = true;
            this.siv.updateBuffer();
            this.siv.repaint();
        }
    }
}

