/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;

public class MathUtil {
    private static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;

    public static final Number add(Object obj1, Object obj2) throws BirtException {
        return MathUtil.doOp(MathUtil.populateOprand(obj1), MathUtil.populateOprand(obj2), Operator.ADD);
    }

    public static final Number subtract(Object obj1, Object obj2) throws BirtException {
        return MathUtil.doOp(MathUtil.populateOprand(obj1), MathUtil.populateOprand(obj2), Operator.SUBTRACT);
    }

    public static final Number multiply(Object obj1, Object obj2) throws BirtException {
        return MathUtil.doOp(MathUtil.populateOprand(obj1), MathUtil.populateOprand(obj2), Operator.MULTIPLY);
    }

    public static final Number divide(Object dividend, Object divisor) throws BirtException {
        return MathUtil.doOp(MathUtil.populateOprand(dividend), MathUtil.populateOprand(divisor), Operator.DIVIDE);
    }

    public static final Object safeDivide(Object dividend, Object divisor, Object ifZero) throws BirtException {
        try {
            Number ret = MathUtil.divide(dividend, divisor);
            if (ret instanceof Double) {
                Double d = (Double)ret;
                return Double.isNaN(d) || Double.isInfinite(d) ? ifZero : ret;
            }
            return ret;
        }
        catch (ArithmeticException e) {
            return ifZero;
        }
    }

    public static final int compareTo0(Object number) throws BirtException {
        return MathUtil.compare(number, 0);
    }

    public static final int compare(Object number1, Object number2) throws BirtException {
        assert (number1 != null && number2 != null);
        if (number1 instanceof BigDecimal) {
            if (number2 instanceof BigDecimal) {
                return ((BigDecimal)number1).compareTo((BigDecimal)number2);
            }
            return ((BigDecimal)number1).compareTo(new BigDecimal(DataTypeUtil.toDouble(number2)));
        }
        Double d1 = DataTypeUtil.toDouble(number1);
        if (number2 instanceof BigDecimal) {
            return new BigDecimal(DataTypeUtil.toDouble(d1)).compareTo((BigDecimal)number2);
        }
        return d1.compareTo(DataTypeUtil.toDouble(number2));
    }

    public static final Number abs(Object number) throws BirtException {
        assert (number != null);
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).abs();
        }
        return Math.abs(DataTypeUtil.toDouble(number));
    }

    public static final Number negate(Object number) throws BirtException {
        assert (number != null);
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).negate();
        }
        return DataTypeUtil.toDouble(number) * -1.0;
    }

    public static final Number toNumber(Object obj1) throws BirtException {
        if (obj1 == null) {
            return null;
        }
        if (obj1 instanceof BigDecimal) {
            return (BigDecimal)obj1;
        }
        return DataTypeUtil.toDouble(obj1);
    }

    private static final Number doOp(Object obj1, Object obj2, Operator op) throws BirtException {
        if (obj1 instanceof BigDecimal) {
            return MathUtil.doOp((BigDecimal)obj1, obj2, op);
        }
        if (obj2 instanceof BigDecimal) {
            return MathUtil.doOp(obj1, (BigDecimal)obj2, op);
        }
        return MathUtil.doOp(DataTypeUtil.toDouble(obj1), DataTypeUtil.toDouble(obj2), op);
    }

    private static final Number doOp(BigDecimal op1, BigDecimal op2, Operator op) throws BirtException {
        if (op == Operator.ADD) {
            return op1.add(op2);
        }
        if (op == Operator.SUBTRACT) {
            return op1.subtract(op2);
        }
        if (op == Operator.MULTIPLY) {
            return op1.multiply(op2);
        }
        if (op == Operator.DIVIDE) {
            return op1.divide(op2, MATH_CONTEXT);
        }
        return null;
    }

    private static final Number doOp(Object op1, BigDecimal op2, Operator op) throws BirtException {
        return MathUtil.doOp(DataTypeUtil.toBigDecimal(op1), op2, op);
    }

    private static final Number doOp(BigDecimal op1, Object op2, Operator op) throws BirtException {
        return MathUtil.doOp(op1, DataTypeUtil.toBigDecimal(op2), op);
    }

    private static Number doOp(Double d1, Double d2, Operator op) {
        if (op == Operator.SUBTRACT) {
            return d1 - d2;
        }
        if (op == Operator.ADD) {
            return d1 + d2;
        }
        if (op == Operator.MULTIPLY) {
            return d1 * d2;
        }
        if (op == Operator.DIVIDE) {
            return d1 / d2;
        }
        return null;
    }

    private static Object populateOprand(Object obj) {
        return obj != null ? obj : new Double(0.0);
    }

    private static enum Operator {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }
}

