/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashSet;
import org.eclipse.birt.data.aggregation.impl.BuildInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.junit.Assert;
import org.junit.Test;

public class TotalTest {
    private double[] weight = new double[]{1.2, 1.4, 2.0, 0.5, 1.4, 2.4, 1.5, 2.5, 3.7, 1.4, 1.03, 0.5, 0.2, 0.6, 1.3, 1.5, 12.4};
    private double[] doubleArray1 = new double[]{1.0, 3.0, 5.0, 4.0, 6.0, 8.0, 3.0, 4.0, 5.0, 7.0, 9.0, 10.0, 4.0, 6.0, 7.0};
    private boolean[] doubleArray1TopBottom;
    private double[] doubleArray2;
    private Double[] doubleArray3;
    private Double[] doubleArrayNull;
    private boolean[] doubleArray3TopBottom;
    private int[] doubleArray3RankDec;
    private int[] doubleArray3RankAsc;
    private int[] doubleArray3DenseRankDec;
    private int[] doubleArray3DenseRankAsc;
    private int[] doubleArray3PercentRank;
    private Object[] doubleArray3PercentSum;
    private String[] str1;
    private double[] doubleArray4;
    private double[] doubleArray5;
    private double[] doubleArray6;
    private Object[] anyObjectArray;
    private Object[] anyObjectArray2;
    private Date[] dates;
    private Date[] dates2;
    private String[] str2;
    private String[] str4;
    private BigDecimal[] bigDecimalArray;
    private int[] bigDecimalRankAsc;
    private int[] bigDecimalDenseRankAsc;
    private int[] bigDecimalPercentRank;
    private int[] bigDecimalPercentSum;
    private BuildInAggregationFactory buildInAggrFactory;

    public TotalTest() {
        boolean[] blArray = new boolean[15];
        blArray[5] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[14] = true;
        this.doubleArray1TopBottom = blArray;
        this.doubleArray2 = new double[]{4.0, -43.0, 4.0, 23.0, -15.0, -6.0, 4.0, -6.0, 3.0, 63.0, 33.0, -6.0, -23.0, 34.0};
        Double[] doubleArray = new Double[8];
        doubleArray[0] = Double.valueOf("100");
        doubleArray[1] = Double.valueOf("20");
        doubleArray[3] = Double.valueOf("300");
        doubleArray[5] = Double.valueOf("40");
        doubleArray[6] = Double.valueOf("10");
        doubleArray[7] = Double.valueOf("10");
        this.doubleArray3 = doubleArray;
        this.doubleArrayNull = new Double[2];
        boolean[] blArray2 = new boolean[8];
        blArray2[0] = true;
        blArray2[3] = true;
        this.doubleArray3TopBottom = blArray2;
        this.doubleArray3RankDec = new int[]{2, 4, 7, 1, 7, 3, 5, 5};
        this.doubleArray3RankAsc = new int[]{7, 5, 1, 8, 1, 6, 3, 3};
        this.doubleArray3DenseRankDec = new int[]{2, 4, 6, 1, 6, 3, 5, 5};
        this.doubleArray3DenseRankAsc = new int[]{5, 3, 1, 6, 1, 4, 2, 2};
        int[] nArray = new int[8];
        nArray[0] = 857;
        nArray[1] = 571;
        nArray[3] = 1000;
        nArray[5] = 714;
        nArray[6] = 285;
        nArray[7] = 285;
        this.doubleArray3PercentRank = nArray;
        Object[] objectArray = new Object[8];
        objectArray[0] = 208;
        objectArray[1] = 41;
        objectArray[3] = 625;
        objectArray[5] = 83;
        objectArray[6] = 20;
        objectArray[7] = 20;
        this.doubleArray3PercentSum = objectArray;
        this.str1 = new String[]{"4", "-43", "4", "23", "-15", "-6", "4", "-6", "3", "63", "33", "-6", "-23", "34"};
        this.doubleArray4 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        this.doubleArray5 = new double[]{1.0, 2.0, 2.0, 3.0, 1.0, 3.0, 4.0, 1.0, 2.0};
        this.doubleArray6 = new double[]{1.0, 2.0, 2.0, 3.0, 1.0, 3.0, 4.0, 2.0, 1.0};
        Object[] objectArray2 = new Object[8];
        objectArray2[0] = "aa";
        objectArray2[1] = "bb";
        objectArray2[3] = 0;
        objectArray2[5] = 1.0;
        objectArray2[6] = new Float(0.0f);
        this.anyObjectArray = objectArray2;
        Object[] objectArray3 = new Object[10];
        objectArray3[0] = "aa";
        objectArray3[1] = "bb";
        objectArray3[3] = 0;
        objectArray3[5] = 1.0;
        objectArray3[6] = new Float(0.0f);
        objectArray3[8] = false;
        objectArray3[9] = new Date(1000000L);
        this.anyObjectArray2 = objectArray3;
        this.dates = new Date[]{new Date(1000000L), new Date(2000000L), new Date(3000000L), new Date(4000000L)};
        this.dates2 = new Date[]{new Date(1000000L), new Date(2000000L), new Date(2000000L), new Date(3000000L), new Date(4000000L)};
        this.str2 = new String[]{"test", "string", "array", "for", "aggregation"};
        this.str4 = new String[]{"test", "string", "array", "for", "aggregation", "test", "string", "array", "for", "aggregation"};
        this.bigDecimalArray = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("3"), new BigDecimal("5"), new BigDecimal("4"), new BigDecimal("6"), new BigDecimal("8"), new BigDecimal("3"), new BigDecimal("4"), new BigDecimal("5"), new BigDecimal("7"), new BigDecimal("9"), new BigDecimal("10"), new BigDecimal("4"), new BigDecimal("6"), new BigDecimal("7")};
        this.bigDecimalRankAsc = new int[]{1, 2, 7, 4, 9, 13, 2, 4, 7, 11, 14, 15, 4, 9, 11};
        this.bigDecimalDenseRankAsc = new int[]{1, 2, 4, 3, 5, 7, 2, 3, 4, 6, 8, 9, 3, 5, 6};
        int[] nArray2 = new int[15];
        nArray2[1] = 71;
        nArray2[2] = 428;
        nArray2[3] = 214;
        nArray2[4] = 571;
        nArray2[5] = 857;
        nArray2[6] = 71;
        nArray2[7] = 214;
        nArray2[8] = 428;
        nArray2[9] = 714;
        nArray2[10] = 928;
        nArray2[11] = 1000;
        nArray2[12] = 214;
        nArray2[13] = 571;
        nArray2[14] = 714;
        this.bigDecimalPercentRank = nArray2;
        this.bigDecimalPercentSum = new int[]{12, 36, 60, 48, 73, 97, 36, 48, 60, 85, 109, 121, 48, 73, 85};
        this.buildInAggrFactory = new BuildInAggregationFactory();
    }

    @Test
    public void testTotalConcatenate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("concatenate");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"CONCATENATE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)4L, (long)ag.getParameterDefn().length);
        String separator = "-";
        Object result = "";
        ac.start();
        int i = 0;
        while (i < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i];
            objectArray[1] = separator;
            ac.onRow(objectArray);
            result = (String)result + this.str2[i];
            result = (String)result + separator;
            ++i;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str4.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str4[i];
            objectArray[1] = separator;
            ac.onRow(objectArray);
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        boolean exceedsMaxLength = false;
        int i2 = 0;
        while (i2 < this.str4.length) {
            ac.onRow(new Object[]{this.str4[i2], separator, 50, true});
            if (exceedsMaxLength || ((String)result).getBytes().length > 50 - this.str4[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = (String)result + this.str4[i2];
                result = (String)result + separator;
            }
            ++i2;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || ((String)result).getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = (String)result + this.str2[i2];
                result = (String)result + separator;
            }
            ++i2;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = ";  ";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || ((String)result).getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = (String)result + this.str2[i2];
                result = (String)result + separator;
            }
            ++i2;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "\n";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || ((String)result).getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = (String)result + this.str2[i2];
                result = (String)result + separator;
            }
            ++i2;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "\t";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || ((String)result).getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = (String)result + this.str2[i2];
                result = (String)result + separator;
            }
            ++i2;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "   ";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || ((String)result).getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = (String)result + this.str2[i2];
                result = (String)result + separator;
            }
            ++i2;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = ",,, ";
        exceedsMaxLength = false;
        i2 = 0;
        while (i2 < this.str2.length) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.str2[i2];
            objectArray[1] = separator;
            objectArray[2] = 20;
            ac.onRow(objectArray);
            if (exceedsMaxLength || ((String)result).getBytes().length > 20 - this.str2[i2].length()) {
                exceedsMaxLength = true;
            } else {
                result = (String)result + this.str2[i2];
                result = (String)result + separator;
            }
            ++i2;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
        ac.start();
        result = "";
        separator = "#";
        exceedsMaxLength = false;
        LinkedHashSet<String> objects = new LinkedHashSet<String>();
        int i3 = 0;
        while (i3 < this.anyObjectArray2.length) {
            if (this.anyObjectArray2[i3] != null) {
                objects.add(this.anyObjectArray2[i3].toString());
            }
            ++i3;
        }
        for (String value : objects) {
            ac.onRow(new Object[]{value, separator, 30, false});
            if (value == null) continue;
            if (exceedsMaxLength || ((String)result).getBytes().length > 30 - value.length()) {
                exceedsMaxLength = true;
                continue;
            }
            result = (String)result + value;
            result = (String)result + separator;
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - separator.length());
        }
        ac.finish();
        Assert.assertEquals((Object)result, (Object)ac.getValue());
    }

    @Test
    public void testTotalCount() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("count");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"COUNT", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        ac.start();
        int i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(new Object[]{this.anyObjectArray[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)5, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(null);
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)8, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow(new Object[0]);
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)15, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow(new Object[0]);
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)14, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[0]);
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)14, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals((Object)0, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testTotalSum() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("sum");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"SUM", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        BigDecimal[] bigDecimalArray = new BigDecimal[5];
        bigDecimalArray[2] = new BigDecimal("1.0");
        bigDecimalArray[4] = new BigDecimal("2.5");
        BigDecimal[] arr = bigDecimalArray;
        ac.start();
        int i = 0;
        while (i < arr.length) {
            ac.onRow(new Object[]{arr[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)3.5, (Object)ac.getValue());
        ac.start();
        int i2 = 0;
        while (i2 < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i2]});
            ++i2;
        }
        ac.finish();
        Assert.assertEquals((Object)82.0, (Object)ac.getValue());
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i2]});
            ++i2;
        }
        ac.finish();
        Assert.assertEquals((Object)69.0, (Object)ac.getValue());
        ac.start();
        i2 = 0;
        while (i2 < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i2]});
            ++i2;
        }
        ac.finish();
        Assert.assertEquals((Object)69.0, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        try {
            i = 0;
            while (i < this.str2.length) {
                ac.onRow(new Object[]{this.str2[i]});
                ++i;
            }
            Assert.fail();
        }
        catch (DataException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)82.0, (Object)ac.getValue());
        ac.start();
        ac.onRow(new Object[]{new BigDecimal("1.2")});
        ac.finish();
        Assert.assertEquals((Object)1.2, (Object)ac.getValue());
        Number[] numberArray = new Number[]{BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.TEN, Double.valueOf("0.1"), new BigDecimal("0.1"), new BigDecimal(0.1), new BigDecimal("0.1"), 0.1};
        ac.start();
        i = 0;
        while (i < numberArray.length) {
            ac.onRow(new Object[]{numberArray[i]});
            ++i;
        }
        ac.finish();
        Number x = (Number)ac.getValue();
        Assert.assertTrue((new BigDecimal("11.49").compareTo(new BigDecimal(x.toString())) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((new BigDecimal("11.51").compareTo(new BigDecimal(x.toString())) == 1 ? 1 : 0) != 0);
        ac.start();
        ac.onRow(new Object[]{Double.NaN});
        ac.onRow(new Object[]{Double.valueOf("0.1"), Double.valueOf("0.2")});
        ac.onRow(new Object[]{new BigDecimal("0.3")});
        ac.finish();
        Number x2 = (Number)ac.getValue();
        Assert.assertTrue((x2 instanceof Double && ((Double)x2).isNaN() ? 1 : 0) != 0);
        ac.start();
        ac.onRow(new Object[]{Double.valueOf("0.1")});
        ac.onRow(new Object[]{new BigDecimal("0.2"), new BigDecimal("0.3")});
        ac.onRow(new Object[]{Double.NaN});
        ac.onRow(new Object[]{new BigDecimal("0.4")});
        ac.finish();
        x2 = (Number)ac.getValue();
        Assert.assertTrue((x2 instanceof Double && ((Double)x2).isNaN() ? 1 : 0) != 0);
        ac.start();
        ac.onRow(new Object[]{Double.POSITIVE_INFINITY});
        ac.onRow(new Object[]{Double.valueOf("0.1"), Double.valueOf("0.2")});
        ac.onRow(new Object[]{new BigDecimal("0.3")});
        ac.finish();
        x2 = (Number)ac.getValue();
        Assert.assertTrue((boolean)(x2 instanceof Double));
        Assert.assertTrue((boolean)((Double)x2).isNaN());
        ac.start();
        ac.onRow(new Object[]{Double.valueOf("0.1"), Double.valueOf("0.2")});
        ac.onRow(new Object[]{new BigDecimal("0.3")});
        ac.onRow(new Object[]{Double.NEGATIVE_INFINITY});
        ac.finish();
        x2 = (Number)ac.getValue();
        Assert.assertTrue((boolean)(x2 instanceof Double));
        Assert.assertTrue((boolean)((Double)x2).isNaN());
        ac.start();
        ac.onRow(new Object[]{Double.valueOf("0.1")});
        ac.onRow(new Object[]{Double.NEGATIVE_INFINITY});
        ac.onRow(new Object[]{new BigDecimal("0.3")});
        ac.finish();
        x2 = (Number)ac.getValue();
        Assert.assertTrue((boolean)(x2 instanceof Double));
        Assert.assertTrue((boolean)((Double)x2).isNaN());
    }

    @Test
    public void testTotalRunningSum() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("RUNNINGSUM");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"RUNNINGSUM", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        double sum = 0.0;
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            Assert.assertEquals((Object)(sum += this.doubleArray1[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        sum = 0.0;
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            Assert.assertEquals((Object)(sum += this.doubleArray2[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        Double sum2 = 0.0;
        ac.start();
        int i2 = 0;
        while (i2 < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i2]});
            sum2 = sum2 + Double.valueOf(this.str1[i2]);
            Assert.assertTrue((boolean)(ac.getValue() instanceof Double));
            Assert.assertEquals((Object)sum2, (Object)ac.getValue());
            ++i2;
        }
        ac.finish();
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        Double bigSum = 0.0;
        ac.start();
        i2 = 0;
        while (i2 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i2]});
            bigSum = bigSum + this.bigDecimalArray[i2].doubleValue();
            Object ret = ac.getValue();
            Assert.assertTrue((boolean)(ret instanceof Double));
            Assert.assertEquals((Object)bigSum, (Object)ret);
            ++i2;
        }
        ac.finish();
    }

    @Test
    public void testTotalAve() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("ave");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"AVE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)2500000.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)5.466666666666667, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)4.928571428571429, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)4.928571428571429, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)5.466666666666667, (Object)ret);
    }

    @Test
    public void testTotalFirst() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("first");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"FIRST", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)1.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)4.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)"4", (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof BigDecimal));
        Assert.assertTrue((new BigDecimal(1).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTotalLast() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("last");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"LAST", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)7.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)34.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)"34", (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof BigDecimal));
        Assert.assertTrue((new BigDecimal(7).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTotalMax() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("max");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"MAX", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)10.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)63.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)"63", (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof BigDecimal));
        Assert.assertTrue((new BigDecimal(10).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTotalMin() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("min");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"MIN", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)1.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)-43.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)"-15", (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof BigDecimal));
        Assert.assertTrue((new BigDecimal(1).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTotalRange() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("range");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"RANGE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)9.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)106.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)0.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArrayNull.length) {
            ac.onRow(new Object[]{this.doubleArrayNull[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)9.0, (Object)ret);
    }

    @Test
    public void testTotalMedian() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("median");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"MEDIAN", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)5.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)3.5, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)3.5, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)2500000.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.dates2.length) {
            ac.onRow(new Object[]{this.dates2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)2000000.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)5.0, (Object)ret);
    }

    @Test
    public void testTotalMode() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("mode");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"MODE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)4.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)4.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray4.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray4[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray5.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray5[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)1.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray6.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray6[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)1.0, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)"4", (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        ac.onRow((Object[])new Double[]{4.0});
        ac.onRow((Object[])new Double[]{4.0});
        ac.onRow((Object[])new Double[]{3.0});
        ac.finish();
        Assert.assertEquals((Object)ac.getValue(), (Object)4.0);
        ac.start();
        i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)ac.getValue(), null);
        ac.start();
        i = 0;
        while (i < this.dates2.length) {
            ac.onRow(new Object[]{this.dates2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)ac.getValue(), (Object)new Date(2000000L));
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof BigDecimal));
        Assert.assertTrue((new BigDecimal(4).compareTo((BigDecimal)ret) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTotalStdDev() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("stddev");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"STDDEV", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)2.445598573141631, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)26.560422510872147, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)26.560422510872147, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)2.445598573141631, (Object)ret);
    }

    @Test
    public void testTotalVariance() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("variance");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"VARIANCE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)5.980952380952381, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)705.4560439560439, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)705.4560439560439, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)5.980952380952381, (Object)ret);
    }

    @Test
    public void testTotalWeightedAva() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("weightedAve");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"WEIGHTEDAVE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], this.weight[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)5.343042071197409, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray2[i], this.weight[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)3.236104279390063, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i], this.weight[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)3.236104279390063, (Object)ac.getValue());
        ac.start();
        ac.onRow(new Object[]{1.0, 1.0});
        ac.onRow(new Object[]{2.0, 2.0});
        ac.finish();
        Assert.assertEquals((Object)1.6666666666666667, (Object)ac.getValue());
        ac.start();
        Object[] objectArray = new Object[2];
        objectArray[1] = 3.0;
        ac.onRow(objectArray);
        ac.onRow(new Object[]{2.0, 2.0});
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = 2.0;
        ac.onRow(objectArray2);
        ac.finish();
        Assert.assertEquals((Object)2.0, (Object)ac.getValue());
        ac.start();
        ac.onRow(new Object[]{1.0, 3.0});
        ac.onRow(new Object[]{1.0, -3.0});
        ac.finish();
        Assert.assertEquals((Object)Double.NaN, (Object)ac.getValue());
        ac.start();
        ac.onRow(new Object[]{1.0, 2.0});
        ac.onRow(new Object[]{2.0, -4.0});
        ac.finish();
        Assert.assertEquals((Object)3.0, (Object)ac.getValue());
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        ac.start();
        try {
            ac.getValue();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)true);
        }
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], this.weight[i]});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)5.343042071197409, (Object)ret);
    }

    @Test
    public void testTotalMovingAve() throws Exception {
        double[] values1 = new double[]{1.0, 2.0, 3.0, 3.25, 3.8, 4.5, 4.285714285714286, 4.25, 4.75, 5.25, 5.75, 6.5, 6.25, 6.0, 6.5};
        String[] values2 = new String[]{"4", "-19.5", "-11.66666666666666666666666666666667", "-3", "-5.4", "-5.5", "-5.5", "0.6666666666666666666666666666666667", "0.5", "7.166666666666666666666666666666667", "15.16666666666666666666666666666667", "15.16666666666666666666666666666667", "10.66666666666666666666666666666667", "17.33333333333333333333333333333333"};
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("movingAve");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"MOVINGAVE", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow(new Object[]{this.doubleArray1[i], 8});
            Assert.assertEquals((Object)values1[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray2.length) {
            ac.onRow(new Object[]{this.doubleArray2[i], 6});
            Assert.assertEquals((Object)Double.valueOf(values2[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.str1.length) {
            ac.onRow(new Object[]{this.str1[i], 6});
            Assert.assertEquals((Object)Double.valueOf(values2[i]), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        ac.finish();
        Assert.assertEquals(null, (Object)ac.getValue());
        BigDecimal[] expectResults = new BigDecimal[]{new BigDecimal("1.0"), new BigDecimal("2.0"), new BigDecimal("3.0"), new BigDecimal("3.25"), new BigDecimal("3.8"), new BigDecimal("4.5"), new BigDecimal("4.285714285714285714285714285714286"), new BigDecimal("4.25"), new BigDecimal("4.75"), new BigDecimal("5.25"), new BigDecimal("5.75"), new BigDecimal("6.5"), new BigDecimal("6.25"), new BigDecimal("6.0"), new BigDecimal("6.5")};
        ac.start();
        int i2 = 0;
        while (i2 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i2], 8});
            Object ret = ac.getValue();
            Assert.assertTrue((boolean)(ret instanceof Double));
            Assert.assertEquals((Object)expectResults[i2].doubleValue(), (Object)ret);
            ++i2;
        }
        ac.finish();
    }

    @Test
    public void testTotalAveDate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("ave");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)2500000.0, (Object)ac.getValue());
    }

    @Test
    public void testTotalMaxDate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("max");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)new Date(4000000L), (Object)ac.getValue());
    }

    @Test
    public void testTotalMinDate() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("min");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.dates.length) {
            ac.onRow(new Object[]{this.dates[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)new Date(1000000L), (Object)ac.getValue());
    }

    @Test
    public void testTotalMaxString() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("max");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.str2.length) {
            ac.onRow(new Object[]{this.str2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)"test", (Object)ac.getValue());
    }

    @Test
    public void testTotalMinString() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("min");
        Accumulator ac = ag.newAccumulator();
        ac.start();
        int i = 0;
        while (i < this.str2.length) {
            ac.onRow(new Object[]{this.str2[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)"aggregation", (Object)ac.getValue());
    }

    @Test
    public void testTotalTop() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("isTopN");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"ISTOPN", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 5.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 5.0});
            Assert.assertEquals((Object)this.doubleArray1TopBottom[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isTopN");
        ac = ag.newAccumulator();
        Assert.assertEquals((Object)"ISTOPN", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        ac.onRow((Object[])new Double[]{6.0, 5.0});
        ac.finish();
        ac.start();
        ac.onRow((Object[])new Double[]{6.0, 5.0});
        ac.finish();
        Assert.assertEquals((Object)true, (Object)ac.getValue());
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 5.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 5.0});
            Assert.assertEquals((Object)this.doubleArray1TopBottom[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isTopNPercent");
        ac = ag.newAccumulator();
        Assert.assertEquals((Object)"ISTOPNPERCENT", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 33.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 33.0});
            Assert.assertEquals((Object)this.doubleArray1TopBottom[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 33.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 33.0});
            Assert.assertEquals((Object)this.doubleArray1TopBottom[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isTopNPercent");
        ac = ag.newAccumulator();
        Assert.assertEquals((Object)"ISTOPNPERCENT", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        ac.onRow((Object[])new Double[]{6.0, 100.0});
        ac.finish();
        ac.start();
        ac.onRow((Object[])new Double[]{6.0, 100.0});
        ac.finish();
        Assert.assertEquals((Object)true, (Object)ac.getValue());
    }

    @Test
    public void testTotalTop2() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("isTopN");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"ISTOPN", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray3[i], 2.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray3[i], 2.0});
            Assert.assertEquals((Object)this.doubleArray3TopBottom[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
    }

    @Test
    public void testTotalBottom() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("isBottomN");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"ISBOTTOMN", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 10.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 10.0});
            Assert.assertEquals((Object)(!this.doubleArray1TopBottom[i] ? 1 : 0), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 10.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 10.0});
            Assert.assertEquals((Object)(!this.doubleArray1TopBottom[i] ? 1 : 0), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("isBottomNPercent");
        ac = ag.newAccumulator();
        Assert.assertEquals((Object)"ISBOTTOMNPERCENT", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertTrue((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 66.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 66.0});
            Assert.assertEquals((Object)(!this.doubleArray1TopBottom[i] ? 1 : 0), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 66.0});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 66.0});
            Assert.assertEquals((Object)(!this.doubleArray1TopBottom[i] ? 1 : 0), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
    }

    @Test
    public void testTotalRank() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("rank");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"RANK", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertFalse((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], false});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], 0});
            Assert.assertEquals((Object)this.doubleArray3RankDec[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("rank");
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], true});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], 1});
            Assert.assertEquals((Object)this.doubleArray3RankAsc[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], true});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 0.0});
            Assert.assertEquals((Object)this.bigDecimalRankAsc[i], (Object)ac.getValue());
            ++i;
        }
        ac.finish();
    }

    @Test
    public void testTotalDenseRank() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("denserank");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"DENSERANK", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertFalse((!ag.getParameterDefn()[1].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], false});
            ++i;
        }
        ac.finish();
        ac.start();
        int[] doubleResultArray3DenseRankDec = new int[this.doubleArray3.length];
        int i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 0});
            doubleResultArray3DenseRankDec[i2] = (Integer)ac.getValue();
            ++i2;
        }
        Assert.assertArrayEquals((int[])this.doubleArray3DenseRankDec, (int[])doubleResultArray3DenseRankDec);
        ac.finish();
        ag = this.buildInAggrFactory.getAggregation("denserank");
        ac = ag.newAccumulator();
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], true});
            ++i2;
        }
        ac.finish();
        ac.start();
        int[] doubleResultArray3DenseRankAsc = new int[this.doubleArray3.length];
        int i3 = 0;
        while (i3 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i3], 1});
            doubleResultArray3DenseRankAsc[i3] = (Integer)ac.getValue();
            ++i3;
        }
        Assert.assertArrayEquals((int[])this.doubleArray3DenseRankAsc, (int[])doubleResultArray3DenseRankAsc);
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i3 = 0;
        while (i3 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i3], true});
            ++i3;
        }
        ac.finish();
        ac.start();
        int[] bigDecimalResultArray3DenseRankAsc = new int[this.bigDecimalArray.length];
        int i4 = 0;
        while (i4 < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i4], 0.0});
            bigDecimalResultArray3DenseRankAsc[i4] = (Integer)ac.getValue();
            ++i4;
        }
        Assert.assertArrayEquals((int[])this.bigDecimalDenseRankAsc, (int[])bigDecimalResultArray3DenseRankAsc);
        ac.finish();
    }

    @Test
    public void testTotalPercentRank() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("percentrank");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"PERCENTRANK", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            Assert.assertEquals((long)this.doubleArray3PercentRank[i], (long)Double.valueOf((Double)ac.getValue() * 1000.0).intValue());
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            Assert.assertEquals((long)this.bigDecimalPercentRank[i], (long)Double.valueOf((Double)ac.getValue() * 1000.0).intValue());
            ++i;
        }
        ac.finish();
    }

    @Test
    public void testTotalPercentSum() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("percentsum");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"PERCENTSUM", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i]});
            Assert.assertEquals((Object)(this.doubleArray3PercentSum[i] == null ? Integer.valueOf(0) : this.doubleArray3PercentSum[i]), (Object)((int)(Double.parseDouble(ac.getValue().toString()) * 1000.0)));
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.str2.length) {
            try {
                ac.onRow(new Object[]{this.str2[i]});
                Assert.fail();
            }
            catch (DataException dataException) {
                // empty catch block
            }
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i]});
            Object ret = ac.getValue();
            Assert.assertTrue((boolean)(ret instanceof Double));
            Assert.assertEquals((long)this.bigDecimalPercentSum[i], (long)Double.valueOf(((Number)ret).doubleValue() * 1000.0).intValue());
            ++i;
        }
        ac.finish();
    }

    @Test
    public void testTotalPercentile() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("percentile");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"PERCENTILE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)ag.getParameterDefn()[1].isOptional());
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], 0.1});
            ++i;
        }
        ac.finish();
        Object value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)10.0);
        ac.start();
        int i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 0.0});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)10.0);
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 1.0});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)300.0);
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 0.7});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)70.0);
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 0.35});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)17.5);
        try {
            ac.start();
            i2 = 0;
            while (i2 < this.doubleArray3.length) {
                ac.onRow(new Object[]{this.doubleArray3[i2], -1.0});
                ++i2;
            }
            ac.finish();
            Assert.fail((String)"should not arrive here");
        }
        catch (DataException i22) {
            // empty catch block
        }
        ac.start();
        i = 0;
        while (i < this.doubleArray3.length) {
            try {
                ac.onRow(new Object[]{this.doubleArray3[i], -0.9});
                Assert.fail();
            }
            catch (DataException dataException) {
                // empty catch block
            }
            try {
                ac.onRow(new Object[]{this.doubleArray3[i], 4.1});
                Assert.fail();
            }
            catch (DataException dataException) {
                // empty catch block
            }
            ++i;
        }
        ac.finish();
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 0.1});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)3.0, (Object)ret);
    }

    @Test
    public void testTotalQuartile() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("quartile");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"QUARTILE", (Object)ag.getName());
        Assert.assertEquals((long)0L, (long)ag.getType());
        Assert.assertEquals((long)2L, (long)ag.getParameterDefn().length);
        Assert.assertTrue((!ag.getParameterDefn()[0].isOptional() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)ag.getParameterDefn()[1].isOptional());
        ac.start();
        int i = 0;
        while (i < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i], 0.0});
            ++i;
        }
        ac.finish();
        Object value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)10.0);
        ac.start();
        int i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 1.0});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)12.5);
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 2.0});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)30.0);
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 3.0});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)85.0);
        ac.start();
        i2 = 0;
        while (i2 < this.doubleArray3.length) {
            ac.onRow(new Object[]{this.doubleArray3[i2], 4.0});
            ++i2;
        }
        ac.finish();
        value = ac.getValue();
        Assert.assertEquals((Object)value, (Object)300.0);
        try {
            ac.start();
            i2 = 0;
            while (i2 < this.doubleArray3.length) {
                ac.onRow(new Object[]{this.doubleArray3[i2], 5.0});
                ++i2;
            }
            ac.finish();
            Assert.fail((String)"should not arrive here");
        }
        catch (DataException i22) {
            // empty catch block
        }
        ac = ag.newAccumulator();
        ac.start();
        i = 0;
        while (i < this.bigDecimalArray.length) {
            ac.onRow(new Object[]{this.bigDecimalArray[i], 1.0});
            ++i;
        }
        ac.finish();
        Object ret = ac.getValue();
        Assert.assertTrue((boolean)(ret instanceof Double));
        Assert.assertEquals((Object)4.0, (Object)ret);
    }

    @Test
    public void testTotalRunningCount() throws Exception {
        IAggrFunction ag = this.buildInAggrFactory.getAggregation("runningcount");
        Accumulator ac = ag.newAccumulator();
        Assert.assertEquals((Object)"RUNNINGCOUNT", (Object)ag.getName());
        Assert.assertEquals((long)1L, (long)ag.getType());
        Assert.assertEquals((long)1L, (long)ag.getParameterDefn().length);
        ac.start();
        int i = 0;
        while (i < this.doubleArray1.length) {
            ac.onRow((Object[])new Double[]{this.doubleArray1[i], 5.0});
            Assert.assertEquals((Object)(i + 1), (Object)ac.getValue());
            ++i;
        }
        ac.finish();
        ac.start();
        i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(new Object[]{this.anyObjectArray[i]});
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)5, (Object)ac.getValue());
        ac.start();
        i = 0;
        while (i < this.anyObjectArray.length) {
            ac.onRow(null);
            ++i;
        }
        ac.finish();
        Assert.assertEquals((Object)8, (Object)ac.getValue());
    }
}

