/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManagerTest;
import org.eclipse.birt.data.engine.odaconsumer.DataSetCapabilities;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class ConnectionTest
extends ConnectionManagerTest {
    private Connection m_connection;

    Connection getConnection() {
        return this.m_connection;
    }

    @Before
    public void connectionSetUp() throws Exception {
        Properties connProperties = this.getJdbcConnProperties();
        this.m_connection = this.getManager().openConnection("org.eclipse.birt.report.data.oda.jdbc", connProperties, null);
    }

    @After
    public void connectionTearDown() throws Exception {
        this.m_connection.close();
    }

    Connection getMySqlConnection() throws DataException {
        Properties connProperties = new Properties();
        connProperties.setProperty("odaURL", "jdbc:mysql://spmdb:3306/test");
        connProperties.setProperty("odaUser", "root");
        connProperties.setProperty("odaPassword", "root");
        connProperties.setProperty("odaDriverClass", "com.mysql.jdbc.Driver");
        Connection connection = ConnectionManager.getInstance().openConnection("org.eclipse.birt.report.data.oda.jdbc", connProperties, null);
        return connection;
    }

    public final void testGetMetaData() throws DataException {
        DataSetCapabilities capabilities = this.m_connection.getMetaData("JDBC");
        Assert.assertNotNull((Object)capabilities);
    }

    public final void testMetaDataCache() throws DataException {
        DataSetCapabilities c1 = this.m_connection.getMetaData("JDBC");
        Assert.assertNotNull((Object)c1);
        DataSetCapabilities c2 = this.m_connection.getMetaData("JDBC");
        Assert.assertNotNull((Object)c2);
        Assert.assertSame((Object)c1, (Object)c2);
    }

    public final void testCreateStatement() throws DataException {
        String command = "select * from \"testtable\"";
        PreparedStatement stmt = this.m_connection.prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)stmt);
        stmt.close();
    }

    public final void testPrepareStatement() throws DataException {
        String command = "select * from \"testtable\" where \"intColumn\" > ?";
        PreparedStatement stmt = this.m_connection.prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Assert.assertNotNull((Object)stmt);
        stmt.close();
    }

    public final void testPrepareStatementWithNullQuery() {
        PreparedStatement stmt;
        block2: {
            String queryText = null;
            stmt = null;
            try {
                stmt = this.m_connection.prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
            }
            catch (DataException ex) {
                Assert.assertNotNull((Object)ex.getCause());
                Assert.assertTrue((boolean)(ex.getCause() instanceof OdaException));
                if (!(ex.getCause() instanceof OdaException)) break block2;
                OdaException driverException = (OdaException)ex.getCause();
                Assert.assertNotNull((Object)driverException.getCause());
                Assert.assertTrue((boolean)(driverException.getCause() instanceof SQLException));
            }
        }
        Assert.assertNull((Object)stmt);
    }

    public final void testClose() throws DataException {
        this.m_connection.close();
    }

    public final void testGetMaxQueries() throws DataException {
        Assert.assertEquals((long)1L, (long)this.m_connection.getMaxQueries());
    }
}

