/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseLinkDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.NamedObject;
import org.eclipse.birt.data.engine.olap.impl.query.ComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.DerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.EdgeDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;

public class CubeQueryDefinition
extends NamedObject
implements ICubeQueryDefinition {
    private IEdgeDefinition columnEdge;
    private IEdgeDefinition rowEdge;
    private IEdgeDefinition pageEdge;
    private List measureList;
    private List bindingList;
    private List filterList;
    private List sortList;
    private List computedMeasureList;
    private List derivedMeasureList;
    private List<ICubeOperation> cubeOperations;
    private String queryResultsID;
    private boolean cacheQueryResults = false;
    private boolean needAccessFactTable;
    private int breakHierarchyOption = 0;
    private String ID;
    private Set<IBaseLinkDefinition> links = new HashSet<IBaseLinkDefinition>();

    public CubeQueryDefinition(String name) {
        super(name);
        this.bindingList = new ArrayList();
        this.measureList = new ArrayList();
        this.filterList = new ArrayList();
        this.sortList = new ArrayList();
        this.computedMeasureList = new ArrayList();
        this.derivedMeasureList = new ArrayList();
        this.cubeOperations = new ArrayList<ICubeOperation>();
    }

    @Override
    public void addBinding(IBinding binding) {
        if (CubeQueryDefinition.needReconstructure(binding)) {
            binding = CubeQueryDefinition.constructNewBinding(binding);
        }
        this.bindingList.add(binding);
    }

    private static boolean needReconstructure(IBinding binding) {
        block4: {
            IAggrFunction aggrFunction;
            block5: {
                if (binding.getAggrFunction() == null || binding.getExpression() != null) break block4;
                aggrFunction = AggregationManager.getInstance().getAggregation(binding.getAggrFunction());
                if (aggrFunction != null) break block5;
                return false;
            }
            try {
                IParameterDefn[] parameterDefn = aggrFunction.getParameterDefn();
                if (parameterDefn != null && parameterDefn.length > 0 && parameterDefn[0].isDataField()) {
                    return true;
                }
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        return false;
    }

    private static IBinding constructNewBinding(IBinding binding) {
        Binding newBinding = null;
        try {
            int i;
            newBinding = new Binding(binding.getBindingName());
            List<String> aggregationOn = binding.getAggregatOns();
            if (aggregationOn != null) {
                i = 0;
                while (i < aggregationOn.size()) {
                    newBinding.addAggregateOn(aggregationOn.get(i));
                    ++i;
                }
            }
            if (binding.getArguments() != null) {
                i = 1;
                while (i < binding.getArguments().size()) {
                    newBinding.addArgument(binding.getArguments().get(i));
                    ++i;
                }
            }
            if (binding.getArguments().size() > 0) {
                newBinding.setExpression(binding.getArguments().get(0));
            }
            newBinding.setAggrFunction(binding.getAggrFunction());
            newBinding.setDataType(binding.getDataType());
            newBinding.setDisplayName(binding.getDisplayName());
            newBinding.setFilter(binding.getFilter());
            newBinding.setTimeFunction(binding.getTimeFunction());
        }
        catch (DataException dataException) {
            // empty catch block
        }
        return newBinding;
    }

    @Override
    public void addFilter(IFilterDefinition filterDefn) {
        this.filterList.add(filterDefn);
    }

    @Override
    public void addSort(ISortDefinition sortDefn) {
        this.sortList.add(sortDefn);
    }

    @Override
    public IEdgeDefinition createEdge(int type) {
        if (type == 2) {
            this.columnEdge = new EdgeDefinition("COLUMN_EDGE");
            return this.columnEdge;
        }
        if (type == 1) {
            this.rowEdge = new EdgeDefinition("ROW_EDGE");
            return this.rowEdge;
        }
        if (type == 3) {
            this.pageEdge = new EdgeDefinition("PAGE_EDGE");
            return this.pageEdge;
        }
        return null;
    }

    @Override
    public IMeasureDefinition createMeasure(String name) {
        MeasureDefinition measureDfn = new MeasureDefinition(name);
        this.measureList.add(measureDfn);
        return measureDfn;
    }

    public List getBindings() {
        return Collections.unmodifiableList(this.bindingList);
    }

    @Override
    public IEdgeDefinition getEdge(int type) {
        if (type == 2) {
            return this.columnEdge;
        }
        if (type == 1) {
            return this.rowEdge;
        }
        if (type == 3) {
            return this.pageEdge;
        }
        return null;
    }

    @Override
    public List getFilters() {
        return this.filterList;
    }

    @Override
    public List getMeasures() {
        return this.measureList;
    }

    @Override
    public List getDerivedMeasures() {
        return this.derivedMeasureList;
    }

    @Override
    public List getSorts() {
        return this.sortList;
    }

    @Override
    public String getQueryResultsID() {
        return this.queryResultsID;
    }

    @Override
    public void setQueryResultsID(String queryResultsID) {
        this.queryResultsID = queryResultsID;
    }

    @Override
    public boolean cacheQueryResults() {
        return this.cacheQueryResults;
    }

    @Override
    public void setCacheQueryResults(boolean cacheQueryResults) {
        this.cacheQueryResults = cacheQueryResults;
    }

    @Override
    public int getFilterOption() {
        return this.breakHierarchyOption;
    }

    @Override
    public void setFilterOption(int breakHierarchyOption) {
        this.breakHierarchyOption = breakHierarchyOption;
    }

    @Override
    public IComputedMeasureDefinition createComputedMeasure(String measureName, int type, IBaseExpression expr) throws DataException {
        ComputedMeasureDefinition cmd = new ComputedMeasureDefinition(measureName, type, expr);
        this.computedMeasureList.add(cmd);
        return cmd;
    }

    @Override
    public IDerivedMeasureDefinition createDerivedMeasure(String measureName, int type, IBaseExpression expr) throws DataException {
        DerivedMeasureDefinition dmd = new DerivedMeasureDefinition(measureName, type, expr);
        this.derivedMeasureList.add(dmd);
        return dmd;
    }

    @Override
    public List getComputedMeasures() {
        return this.computedMeasureList;
    }

    @Override
    public void addCubeOperation(ICubeOperation cubeOperation) {
        if (cubeOperation == null) {
            throw new NullPointerException("cubeOperation is null");
        }
        this.cubeOperations.add(cubeOperation);
    }

    @Override
    public ICubeOperation[] getCubeOperations() {
        return this.cubeOperations.toArray(new ICubeOperation[0]);
    }

    @Override
    public boolean needAccessFactTable() {
        return this.needAccessFactTable;
    }

    @Override
    public void setNeedAccessFactTable(boolean needAccessFactTable) {
        this.needAccessFactTable = needAccessFactTable;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    @Override
    public void setID(String ID) {
        this.ID = ID;
    }

    @Override
    public ICubeQueryDefinition clone() {
        CubeQueryDefinition cloned = new CubeQueryDefinition(this.getName());
        this.cloneFields(cloned);
        return cloned;
    }

    protected void cloneFields(CubeQueryDefinition cloned) {
        cloned.bindingList.addAll(this.bindingList);
        cloned.breakHierarchyOption = this.breakHierarchyOption;
        cloned.cacheQueryResults = this.cacheQueryResults;
        cloned.columnEdge = this.columnEdge != null ? this.columnEdge.clone() : null;
        cloned.computedMeasureList.addAll(this.computedMeasureList);
        cloned.cubeOperations.addAll(this.cubeOperations);
        cloned.derivedMeasureList.addAll(this.derivedMeasureList);
        cloned.filterList.addAll(this.filterList);
        cloned.ID = this.ID;
        cloned.measureList.addAll(this.measureList);
        cloned.needAccessFactTable = this.needAccessFactTable;
        cloned.pageEdge = this.pageEdge != null ? this.pageEdge.clone() : null;
        cloned.queryResultsID = this.queryResultsID;
        cloned.rowEdge = this.rowEdge != null ? this.rowEdge.clone() : null;
        cloned.sortList.addAll(this.sortList);
        cloned.links.addAll(this.links);
    }

    @Override
    public Set<IBaseLinkDefinition> getLinks() {
        return this.links;
    }

    @Override
    public void addLink(IBaseLinkDefinition link) {
        this.links.add(link);
    }
}

